/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.DisplayEvent;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.papyrus.uml.service.types.element.UMLDIElementTypes;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomExecutionSpecificationCreationEditPolicy
extends DefaultCreationEditPolicy {
    private DisplayEvent displayEvent;

    public void setHost(EditPart host) {
        super.setHost(host);
        LifelineEditPart lifeline = SequenceUtil.getParentLifelinePart(this.getHost());
        this.displayEvent = new DisplayEvent((EditPart)(lifeline != null ? lifeline : host));
    }

    protected ICommand getSetBoundsCommand(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor) {
        if (UMLDIElementTypes.TIME_CONSTRAINT_SHAPE.getSemanticHint().equals(descriptor.getSemanticHint()) || UMLDIElementTypes.TIME_OBSERVATION_SHAPE.getSemanticHint().equals(descriptor.getSemanticHint())) {
            Point location = request.getLocation().getCopy();
            location.setX(-10);
            IFigure execFigure = ((IGraphicalEditPart)this.getHost()).getFigure();
            boolean isStart = OccurrenceSpecificationUtil.isStart(execFigure, location);
            if (isStart) {
                location.setY(-1);
            } else {
                location.setY(Short.MAX_VALUE);
            }
            Dimension size = new Dimension(40, 1);
            return new SetBoundsCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)descriptor, new Rectangle(location, size));
        }
        return super.getSetBoundsCommand(request, descriptor);
    }

    public EditPart getTargetEditPart(Request request) {
        EditPart result = super.getTargetEditPart(request);
        if (!(request instanceof CreateRequest)) {
            return result;
        }
        CreateRequest create = (CreateRequest)request;
        Stream<Object> elementTypes = null;
        if (request instanceof CreateViewAndElementRequest) {
            elementTypes = ((CreateViewAndElementRequest)request).getViewDescriptors().stream().map(v -> (IElementType)v.getElementAdapter().getAdapter(IElementType.class));
        } else if (request instanceof CreateUnspecifiedTypeRequest) {
            elementTypes = ((CreateUnspecifiedTypeRequest)request).getElementTypes().stream();
        }
        if (elementTypes != null) {
            Predicate<IElementType> isInteresting = type -> ElementUtil.isTypeOf((IElementType)type, (IElementType)UMLElementTypes.TIME_CONSTRAINT);
            isInteresting = isInteresting.or(type -> ElementUtil.isTypeOf((IElementType)type, (IElementType)UMLElementTypes.TIME_OBSERVATION));
            isInteresting = isInteresting.or(type -> ElementUtil.isTypeOf((IElementType)type, (IElementType)UMLElementTypes.EXECUTION_SPECIFICATION));
            Optional<EClass> interestingType = elementTypes.map(type -> {
                if (ElementUtil.isTypeOf((IElementType)type, (IElementType)UMLElementTypes.TIME_CONSTRAINT)) {
                    return UMLPackage.Literals.TIME_CONSTRAINT;
                }
                if (ElementUtil.isTypeOf((IElementType)type, (IElementType)UMLElementTypes.TIME_OBSERVATION)) {
                    return UMLPackage.Literals.TIME_OBSERVATION;
                }
                if (ElementUtil.isTypeOf((IElementType)type, (IElementType)UMLElementTypes.EXECUTION_SPECIFICATION)) {
                    return UMLPackage.Literals.EXECUTION_SPECIFICATION;
                }
                return null;
            }).findFirst();
            result = interestingType.map(type -> {
                switch (type.getClassifierID()) {
                    case 240: 
                    case 242: {
                        MessageOccurrenceSpecification messageOcc;
                        Point loc = create.getLocation();
                        if (loc == null || (messageOcc = this.displayEvent.getMessageEvent(((IGraphicalEditPart)this.getHost()).getFigure(), loc)) == null) break;
                        return SequenceUtil.getParentLifelinePart(this.getHost());
                    }
                    case 212: {
                        return SequenceUtil.getParentLifelinePart(this.getHost());
                    }
                }
                return null;
            }).orElse(result);
        }
        return result;
    }
}

