/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.properties.widgets;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.helper.IDeleteEmptyDecoratorModelsPolicy;
import org.eclipse.papyrus.uml.decoratormodel.internal.properties.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.ExternalizeProfileApplicationsWizard;
import org.eclipse.papyrus.uml.decoratormodel.properties.Activator;
import org.eclipse.papyrus.uml.decoratormodel.ui.providers.DeleteEmptyDecoratorModelsPolicy;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.properties.widgets.ProfileApplicationEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ProfileApplicationPropertyEditor
extends org.eclipse.papyrus.uml.properties.widgets.ProfileApplicationPropertyEditor {
    public ProfileApplicationPropertyEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected ProfileApplicationEditor createProfileApplicationEditor(Composite parent, int style) {
        return new ExternalizableProfileApplicationEditor(parent, style);
    }

    static class ExternalizableProfileApplicationEditor
    extends ProfileApplicationEditor {
        private Button externalizeButton;
        private Button internalizeButton;

        ExternalizableProfileApplicationEditor(Composite parent, int style) {
            super(parent, style);
        }

        protected void createListControls() {
            super.createListControls();
            this.externalizeButton = this.createButton(Activator.getDefault().getImage("/icons/full/ctool16/externalize.gif"), Messages.ProfileApplicationPropertyEditor_0);
            this.internalizeButton = this.createButton(Activator.getDefault().getImage("/icons/full/ctool16/internalize.gif"), Messages.ProfileApplicationPropertyEditor_1);
        }

        protected ProfileApplicationEditor.ProfileColumnsLabelProvider createProfileColumnsLabelProvider(IBaseLabelProvider labelProvider) {
            return new ExternalizableProfileColumnsLabelProvider(labelProvider);
        }

        protected void updateControls() {
            super.updateControls();
            Package package_ = this.getInputPackage();
            Iterable<ProfileApplication> profileApplications = this.getSelectedProfileApplications();
            boolean allInternalized = false;
            for (ProfileApplication next : profileApplications) {
                boolean bl = allInternalized = next.getApplyingPackage() == package_;
                if (!allInternalized) break;
            }
            this.externalizeButton.setEnabled(allInternalized);
            boolean allExternalized = false;
            for (ProfileApplication next : profileApplications) {
                boolean bl = allExternalized = next.getApplyingPackage() != package_;
                if (!allExternalized) break;
            }
            this.internalizeButton.setEnabled(allExternalized);
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            if (e.widget == this.externalizeButton) {
                this.externalizeProfileApplications();
            } else if (e.widget == this.internalizeButton) {
                this.internalizeProfileApplications();
            }
        }

        Iterable<ProfileApplication> getSelectedProfileApplications() {
            final Package package_ = this.getInputPackage();
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            return Iterables.transform((Iterable)selection.toList(), (Function)new Function<Object, ProfileApplication>(){

                public ProfileApplication apply(Object input) {
                    return package_.getProfileApplication((Profile)input, true);
                }
            });
        }

        Package getInputPackage() {
            return (Package)this.getContextElement();
        }

        void externalizeProfileApplications() {
            Package package_ = this.getInputPackage();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)package_);
            if (domain != null) {
                ExternalizeProfileApplicationsWizard wizard = new ExternalizeProfileApplicationsWizard();
                Iterable<ProfileApplication> profileApplications = this.getSelectedProfileApplications();
                wizard.init(package_, profileApplications);
                WizardDialog dlg = new WizardDialog(this.getShell(), (IWizard)wizard);
                if (dlg.open() == 0) {
                    this.commit();
                    this.updateControls();
                }
            }
        }

        void internalizeProfileApplications() {
            Package package_ = this.getInputPackage();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)package_);
            if (domain != null) {
                Iterable<ProfileApplication> profileApplications = this.getSelectedProfileApplications();
                domain.getCommandStack().execute(DecoratorModelUtils.createReclaimProfileApplicationsCommand(profileApplications, (IDeleteEmptyDecoratorModelsPolicy)new DeleteEmptyDecoratorModelsPolicy((IShellProvider)new SameShellProvider((Control)this.internalizeButton))));
                this.commit();
                this.updateControls();
            }
        }

        protected class ExternalizableProfileColumnsLabelProvider
        extends ProfileApplicationEditor.ProfileColumnsLabelProvider {
            public ExternalizableProfileColumnsLabelProvider(IBaseLabelProvider defaultLabelProvider) {
                super((ProfileApplicationEditor)ExternalizableProfileApplicationEditor.this, defaultLabelProvider);
            }

            public StyledString getStyledText(Object element) {
                StyledString result = super.getStyledText(element);
                ProfileApplication application = null;
                if (element instanceof Profile) {
                    application = ExternalizableProfileApplicationEditor.this.getInputPackage().getProfileApplication((Profile)element, true);
                } else if (element instanceof ProfileApplication) {
                    application = (ProfileApplication)element;
                }
                if (application != null && application.eResource() != ExternalizableProfileApplicationEditor.this.getInputPackage().eResource()) {
                    Package rootPackage = (Package)EcoreUtil.getRootContainer((EObject)application);
                    String modelName = UMLLabelInternationalization.getInstance().getLabel((NamedElement)rootPackage);
                    if (Strings.isNullOrEmpty((String)modelName)) {
                        modelName = rootPackage.eResource().getURI().trimFileExtension().lastSegment();
                    }
                    String qualifier = " " + NLS.bind((String)Messages.ProfileApplicationPropertyEditor_2, (Object)modelName);
                    result.append(qualifier, StyledString.DECORATIONS_STYLER);
                }
                return result;
            }
        }
    }
}

