/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.plugin.builder.quickfix;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.papyrus.eclipse.project.editors.file.ManifestEditor;
import org.eclipse.papyrus.toolsmiths.plugin.builder.Activator;
import org.eclipse.papyrus.toolsmiths.plugin.builder.helper.BundleVersionHelper;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.AbstractPapyrusMarkerResolution;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Version;

public class DependencyRangeMarkerResolution
extends AbstractPapyrusMarkerResolution {
    public String getLabel() {
        return "Add dependency version range";
    }

    public void run(IMarker marker) {
        String dependency = marker.getAttribute("dependency", "");
        IResource resource = marker.getResource();
        IProject project = resource != null ? resource.getProject() : null;
        BundleVersionHelper bundleHelper = new BundleVersionHelper(dependency);
        if (project != null) {
            try {
                ManifestEditor me = new ManifestEditor(project);
                me.init();
                String version = "";
                BundleSpecification bundle = null;
                switch (marker.getAttribute("kind", 0)) {
                    case 3: 
                    case 4: {
                        bundle = this.getBundle(project, dependency);
                        if (bundle != null) {
                            Version minimumVersion = bundle.getVersionRange().getLeft();
                            Version maximumVersion = bundle.getVersionRange().getRight();
                            version = bundleHelper.getVersionRangeForManifest(minimumVersion, maximumVersion);
                            break;
                        }
                        version = bundleHelper.getVersionRangeForManifest();
                        break;
                    }
                    case 2: {
                        bundle = this.getBundle(project, dependency);
                        if (bundle != null) {
                            Version minimumVersion = bundle.getVersionRange().getLeft();
                            Version maximumVersion = bundleHelper.getVersionRange().getRight();
                            version = bundleHelper.getVersionRangeForManifest(minimumVersion, maximumVersion);
                            break;
                        }
                        version = bundleHelper.getVersionRangeForManifest();
                        break;
                    }
                    case 1: {
                        version = bundleHelper.getVersionRangeForManifest();
                        break;
                    }
                    default: {
                        version = bundleHelper.getVersionRangeForManifest();
                    }
                }
                me.addDependency(dependency, version);
                me.save();
            }
            catch (IOException | CoreException e) {
                Activator.log.error(e);
            }
        }
    }

    public String getDescription() {
        return "Add dependency version range";
    }

    private BundleSpecification getBundle(IProject project, String dependency) {
        IPluginModelBase pluginModelBase = PluginRegistry.findModel((IProject)project);
        BundleSpecification[] requiredBundles = pluginModelBase.getBundleDescription().getRequiredBundles();
        BundleSpecification bundle = Arrays.stream(requiredBundles).filter(b -> b.getName().equals(dependency)).findFirst().orElse(null);
        return bundle;
    }
}

