/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactLifelineCompartmentEditPartCN;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLPackage;

public class AbstractTimelineLayoutPolicy
extends XYLayoutEditPolicy {
    public static final Request UPDATE_LAYOUT_REQUEST = new Request((Object)"UPDATE_LAYOUT");

    public Command getCommand(Request request) {
        if (request instanceof ChangeBoundsRequest && request.getType() == "add children") {
            request.setType((Object)"move children");
        }
        if (request == UPDATE_LAYOUT_REQUEST) {
            return this.getUpdateTimeElementsCommand();
        }
        Command superCommand = super.getCommand(request);
        if (superCommand != null && (request instanceof ChangeBoundsRequest || request.getType() == "create child")) {
            CompoundCommand compoundCommand = new CompoundCommand();
            compoundCommand.add(superCommand);
            compoundCommand.add(this.getUpdateTimeElementsCommand());
            return compoundCommand;
        }
        return superCommand;
    }

    protected static Command getMoveOccurrenceSpecificationCommand(final Node occurrenceSpecificationNode, Point moveDelta, View timelineCompartmentView, int occurrenceSpecificationIndex, List<Node> nodesToIgnore) {
        LayoutConstraint layoutConstraint = occurrenceSpecificationNode.getLayoutConstraint();
        if (layoutConstraint instanceof Location) {
            Location location = (Location)layoutConstraint;
            final int posX = location.getX() + moveDelta.x;
            final int posY = location.getY() + moveDelta.y;
            final int min = AbstractTimelineLayoutPolicy.findMin(timelineCompartmentView, occurrenceSpecificationIndex, nodesToIgnore);
            final int max = AbstractTimelineLayoutPolicy.findMax(timelineCompartmentView, occurrenceSpecificationIndex, nodesToIgnore);
            OccurrenceSpecification occurrenceSpecification = (OccurrenceSpecification)occurrenceSpecificationNode.getElement();
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)occurrenceSpecification);
            return new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, Messages.AbstractTimelineLayoutPolicy_MoveOccurrenceSpecification, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    Location loc = NotationFactory.eINSTANCE.createLocation();
                    int newX = Math.max(Math.min(posX, max), min);
                    loc.setX(newX);
                    loc.setY(posY);
                    occurrenceSpecificationNode.setLayoutConstraint((LayoutConstraint)loc);
                    return CommandResult.newOKCommandResult();
                }
            });
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected static int findMax(View timelineCompartmentView, int index, List<Node> nodesToIgnore) {
        EList children = timelineCompartmentView.getChildren();
        int i = index + 1;
        while (i < children.size()) {
            LayoutConstraint layoutConstraint;
            View childView = (View)children.get(i);
            if (!nodesToIgnore.contains(childView) && childView.getElement() instanceof OccurrenceSpecification && (layoutConstraint = ((Node)childView).getLayoutConstraint()) instanceof Location) {
                Location location = (Location)layoutConstraint;
                return location.getX() - 4;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    protected static int findMin(View timelineCompartmentView, int index, List<Node> nodesToIgnore) {
        EList children = timelineCompartmentView.getChildren();
        int i = index - 1;
        while (i >= 0) {
            LayoutConstraint layoutConstraint;
            View childView = (View)children.get(i);
            if (!nodesToIgnore.contains(childView) && childView.getElement() instanceof OccurrenceSpecification && (layoutConstraint = ((Node)childView).getLayoutConstraint()) instanceof Location) {
                Location location = (Location)layoutConstraint;
                return location.getX() + 4;
            }
            --i;
        }
        return 0;
    }

    protected Command getUpdateTimeElementsCommand() {
        GraphicalEditPart timelineCompartmentEditPart = this.getHost();
        final Node compartmentView = (Node)timelineCompartmentEditPart.getModel();
        final boolean compact = timelineCompartmentEditPart instanceof CompactLifelineCompartmentEditPartCN;
        final int width = timelineCompartmentEditPart.getFigure().getSize().width;
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)compartmentView);
        return new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, Messages.AbstractTimelineLayoutPolicy_UpdateLocationOfTimeElements, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EList children = compartmentView.getChildren();
                for (View child : children) {
                    Element startEndElement;
                    Element endElement;
                    Element startElement;
                    EObject element = child.getElement();
                    if (element instanceof TimeObservation) {
                        TimeObservation timeObservation = (TimeObservation)element;
                        Node timeObservationNode = (Node)child;
                        AbstractTimelineLayoutPolicy.updateTimeElementLocation(timeObservationNode, (EObject)timeObservation.getEvent(), (EList<View>)children, compact, width);
                        continue;
                    }
                    if (element instanceof TimeConstraint) {
                        TimeConstraint timeConstraint = (TimeConstraint)element;
                        Node timeConstraintNode = (Node)child;
                        EList constrainedElements = timeConstraint.getConstrainedElements();
                        if (constrainedElements.size() <= 0) continue;
                        Element constrainedElement = (Element)constrainedElements.get(0);
                        AbstractTimelineLayoutPolicy.updateTimeElementLocation(timeConstraintNode, (EObject)constrainedElement, (EList<View>)children, compact, width);
                        continue;
                    }
                    if (element instanceof DurationObservation) {
                        DurationObservation durationObservation = (DurationObservation)element;
                        Node durationObservationNode = (Node)child;
                        EList events = durationObservation.getEvents();
                        if (events.size() == 2) {
                            startElement = (Element)events.get(0);
                            endElement = (Element)events.get(1);
                            AbstractTimelineLayoutPolicy.this.updateDurationElementLocation(durationObservationNode, startElement, endElement, (EList<View>)children);
                            continue;
                        }
                        if (events.size() != 1) continue;
                        startEndElement = (Element)events.get(0);
                        AbstractTimelineLayoutPolicy.this.updateDurationElementLocation(durationObservationNode, startEndElement, startEndElement, (EList<View>)children);
                        continue;
                    }
                    if (element instanceof DurationConstraint) {
                        DurationConstraint durationConstraint = (DurationConstraint)element;
                        Node durationConstraintNode = (Node)child;
                        EList elements = durationConstraint.getConstrainedElements();
                        if (elements.size() == 2) {
                            startElement = (Element)elements.get(0);
                            endElement = (Element)elements.get(1);
                            AbstractTimelineLayoutPolicy.this.updateDurationElementLocation(durationConstraintNode, startElement, endElement, (EList<View>)children);
                            continue;
                        }
                        if (elements.size() != 1) continue;
                        startEndElement = (Element)elements.get(0);
                        AbstractTimelineLayoutPolicy.this.updateDurationElementLocation(durationConstraintNode, startEndElement, startEndElement, (EList<View>)children);
                        continue;
                    }
                    if (!(element instanceof GeneralOrdering)) continue;
                    GeneralOrdering generalOrdering = (GeneralOrdering)element;
                    Node generalOrderingNode = (Node)child;
                    OccurrenceSpecification before = generalOrdering.getBefore();
                    OccurrenceSpecification after = generalOrdering.getAfter();
                    AbstractTimelineLayoutPolicy.updateGeneralOrderingLocation(generalOrderingNode, before, after, (EList<View>)children);
                }
                return CommandResult.newOKCommandResult();
            }
        });
    }

    protected static void updateTimeElementLocation(Node timeElementNode, EObject alignmentElement, EList<View> timelineViews, boolean compact, int max) {
        int occurrencePositionBefore = -1;
        int occurrencePositionAfter = -1;
        int lastOccurrencePosition = -1;
        boolean after = false;
        for (View view : timelineViews) {
            Node node;
            LayoutConstraint layoutConstraint;
            if (view instanceof Node && ViewUtils.isViewFor(view, UMLPackage.eINSTANCE.getOccurrenceSpecification()) && (layoutConstraint = (node = (Node)view).getLayoutConstraint()) instanceof Location) {
                Location location = (Location)layoutConstraint;
                lastOccurrencePosition = location.getX();
            }
            if (after && view instanceof Node && ViewUtils.isViewFor(view, UMLPackage.eINSTANCE.getStateInvariant())) {
                occurrencePositionAfter = lastOccurrencePosition;
                after = false;
            }
            if (view.getElement() != alignmentElement) continue;
            occurrencePositionBefore = lastOccurrencePosition;
            after = true;
        }
        boolean firstEvent = true;
        EObject element = timeElementNode.getElement();
        if (element instanceof TimeObservation) {
            TimeObservation timeObservation = (TimeObservation)element;
            firstEvent = timeObservation.isFirstEvent();
        } else if (element instanceof TimeConstraint) {
            TimeConstraint timeConstraint = (TimeConstraint)element;
            firstEvent = timeConstraint.isFirstEvent();
        }
        if (firstEvent) {
            if (occurrencePositionBefore != -1) {
                AbstractTimelineLayoutPolicy.setTimeElementNodeLocation(timeElementNode, occurrencePositionBefore);
            } else if (compact) {
                AbstractTimelineLayoutPolicy.setTimeElementNodeLocation(timeElementNode, 100);
            } else {
                AbstractTimelineLayoutPolicy.setTimeElementNodeLocation(timeElementNode, 0);
            }
        } else if (occurrencePositionAfter != -1) {
            AbstractTimelineLayoutPolicy.setTimeElementNodeLocation(timeElementNode, occurrencePositionAfter);
        } else {
            int margin = 5;
            AbstractTimelineLayoutPolicy.setTimeElementNodeLocation(timeElementNode, max - 5);
        }
    }

    protected void updateDurationElementLocation(Node durationElementNode, Element startElement, Element endElement, EList<View> timelineViews) {
        int lastOccurrencePosition = this.getOriginX();
        int startPos = this.getOriginX();
        int endPos = -1;
        boolean onEndElement = false;
        for (View view : timelineViews) {
            if (view instanceof Node) {
                Node node = (Node)view;
                LayoutConstraint layoutConstraint = node.getLayoutConstraint();
                Location location = (Location)layoutConstraint;
                if (onEndElement && ViewUtils.isViewFor(view, UMLPackage.eINSTANCE.getDestructionOccurrenceSpecification())) {
                    endPos = location.getX() + 2 + 1;
                    onEndElement = false;
                }
                if (ViewUtils.isViewFor(view, UMLPackage.eINSTANCE.getOccurrenceSpecification())) {
                    lastOccurrencePosition = location.getX();
                } else if (ViewUtils.isViewFor(view, UMLPackage.eINSTANCE.getStateInvariant()) && onEndElement) {
                    endPos = lastOccurrencePosition + 2 + 1;
                    onEndElement = false;
                }
            }
            if (view.getElement() == startElement) {
                startPos = lastOccurrencePosition + 2;
            }
            if (view.getElement() != endElement) continue;
            if (endElement instanceof OccurrenceSpecification) {
                endPos = lastOccurrencePosition + 2 + 1;
                continue;
            }
            onEndElement = true;
        }
        if (endPos == -1) {
            endPos = Integer.MAX_VALUE;
        }
        AbstractTimelineLayoutPolicy.setDurationElementNodeLocation(durationElementNode, startPos, endPos);
    }

    protected int getOriginX() {
        return 0;
    }

    protected static void setTimeElementNodeLocation(Node timeElementNode, int x) {
        int y;
        Location timeElementLocation;
        LayoutConstraint layoutConstraint = timeElementNode.getLayoutConstraint();
        if (layoutConstraint instanceof Bounds) {
            Bounds initialBounds = (Bounds)layoutConstraint;
            timeElementLocation = NotationFactory.eINSTANCE.createLocation();
            y = initialBounds.getY() - 12 - 5;
        } else if (layoutConstraint instanceof Location) {
            timeElementLocation = (Location)layoutConstraint;
            y = timeElementLocation.getY();
        } else {
            timeElementLocation = NotationFactory.eINSTANCE.createLocation();
            y = 0;
        }
        timeElementLocation.setX(x);
        timeElementLocation.setY(y);
        timeElementNode.setLayoutConstraint((LayoutConstraint)timeElementLocation);
    }

    private static void setDurationElementNodeLocation(Node durationElementNode, int startPos, int endPos) {
        Bounds bounds;
        LayoutConstraint layoutConstraint = durationElementNode.getLayoutConstraint();
        if (layoutConstraint instanceof Bounds) {
            bounds = (Bounds)layoutConstraint;
        } else {
            bounds = NotationFactory.eINSTANCE.createBounds();
            durationElementNode.setLayoutConstraint((LayoutConstraint)bounds);
        }
        bounds.setX(startPos);
        if (endPos == Integer.MAX_VALUE) {
            bounds.setWidth(Integer.MAX_VALUE);
        } else {
            bounds.setWidth(endPos - startPos);
        }
    }

    protected static void updateGeneralOrderingLocation(Node generalOrderingNode, OccurrenceSpecification before, OccurrenceSpecification after, EList<View> timelineViews) {
        int startPos = -1;
        int endPos = -1;
        for (View view : timelineViews) {
            if (!(view instanceof Node)) continue;
            Node node = (Node)view;
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            Location location = (Location)layoutConstraint;
            if (view.getElement() == before) {
                startPos = location.getX() + 2;
            }
            if (view.getElement() != after) continue;
            endPos = location.getX() + 2 + 1;
        }
        if (startPos != -1 && endPos != -1) {
            AbstractTimelineLayoutPolicy.setGeneralOrderingNodeLocation(generalOrderingNode, startPos, endPos);
        }
    }

    private static void setGeneralOrderingNodeLocation(Node generalOrderingNode, int startPos, int endPos) {
        Bounds bounds;
        LayoutConstraint layoutConstraint = generalOrderingNode.getLayoutConstraint();
        if (layoutConstraint instanceof Bounds) {
            bounds = (Bounds)layoutConstraint;
        } else {
            bounds = NotationFactory.eINSTANCE.createBounds();
            generalOrderingNode.setLayoutConstraint((LayoutConstraint)bounds);
        }
        bounds.setX(startPos);
        bounds.setWidth(endPos - startPos);
    }
}

