/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.emf.Activator;

public abstract class TextReferencesHelper {
    public static final String URI_CHARS = "[^#]";
    public static final String FRAGMENT_CHARS = "[-A-Za-z0-9_/]";
    public static final String URI_REGEX = String.format("%s*#%s+", "[^#]", "[-A-Za-z0-9_/]");
    public static final String UNKNOWN_ELEMENT = "UNKNOWN";
    public static final String PROXY_ELEMENT = "PROXY";
    protected Resource baseResource;
    protected ResourceSet resourceSet;

    protected TextReferencesHelper() {
    }

    protected TextReferencesHelper(Resource baseResource) {
        if (baseResource != null) {
            this.baseResource = baseResource;
            this.resourceSet = baseResource.getResourceSet();
        }
    }

    public String replaceReferences(String text) {
        if (text == null) {
            return null;
        }
        if ("".equals(text)) {
            return text;
        }
        String replaceRegex = String.format("\\{@link (%s)(\\|([^}]*))?\\}", URI_REGEX);
        Pattern pattern = Pattern.compile(replaceRegex);
        Matcher matcher = pattern.matcher(text);
        String newText = text;
        while (matcher.find()) {
            String uriToReplace = matcher.group(1);
            String cachedValue = matcher.group(3);
            String replacement = this.decorate(this.getReplacement(uriToReplace, cachedValue));
            newText = matcher.replaceFirst(replacement);
            matcher = pattern.matcher(newText);
        }
        return newText;
    }

    public String insertReference(EObject toElement, String inText, int atPosition) {
        URI baseURI;
        Object result = inText;
        if (inText == null) {
            return null;
        }
        if (toElement == null) {
            return inText;
        }
        URI elementURI = EcoreUtil.getURI((EObject)toElement);
        if (this.baseResource != null && (baseURI = this.baseResource.getURI()) != null) {
            elementURI = elementURI.deresolve(baseURI);
        }
        String reference = "{@link " + String.valueOf(elementURI) + "}";
        if (atPosition == 0) {
            return reference + (String)result;
        }
        if (atPosition < 0 || atPosition >= inText.length()) {
            result = (String)result + reference;
        } else {
            result = inText.substring(0, atPosition);
            result = (String)result + reference;
            result = (String)result + inText.substring(atPosition, inText.length());
        }
        return result;
    }

    protected String decorate(String text) {
        return text;
    }

    protected String getReplacement(String uriToReplace, String cachedValue) {
        if (this.baseResource == null || this.resourceSet == null || this.baseResource.getURI() == null) {
            return UNKNOWN_ELEMENT;
        }
        if (!uriToReplace.contains("#")) {
            return UNKNOWN_ELEMENT;
        }
        String uri = uriToReplace.substring(0, uriToReplace.indexOf(35));
        String fragment = uriToReplace.substring(uriToReplace.indexOf(35) + 1, uriToReplace.length());
        URI resourceURI = this.baseResource.getURI();
        URI targetURI = URI.createURI((String)uri);
        targetURI = targetURI.resolve(resourceURI);
        if (targetURI == null) {
            return UNKNOWN_ELEMENT;
        }
        targetURI = targetURI.appendFragment(fragment);
        return this.getReplacement(targetURI, cachedValue);
    }

    protected String getReplacement(URI uriToReplace, String cachedValue) {
        try {
            EObject targetElement = this.resourceSet.getEObject(uriToReplace, true);
            return this.getReplacement(targetElement, cachedValue);
        }
        catch (Exception ex) {
            Activator.log.debug("An error occurred while loading the following URI: " + String.valueOf(uriToReplace) + ". The reference cannot be replaced");
            return UNKNOWN_ELEMENT;
        }
    }

    protected abstract String getReplacement(EObject var1, String var2);
}

