/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints.impl;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdvicePackage;
import org.eclipse.papyrus.infra.emf.types.constraints.EndKind;
import org.eclipse.papyrus.infra.emf.types.constraints.EndPermission;
import org.eclipse.papyrus.infra.emf.types.constraints.operations.EndPermissionOperations;
import org.eclipse.papyrus.infra.filters.Filter;
import org.eclipse.papyrus.infra.filters.impl.FilteredElementImpl;

public class EndPermissionImpl
extends FilteredElementImpl
implements EndPermission {
    protected static final EndKind END_KIND_EDEFAULT = EndKind.ALL;
    protected EndKind endKind = END_KIND_EDEFAULT;
    protected static final boolean PERMITTED_EDEFAULT = true;
    protected boolean permitted = true;
    protected Filter endFilter;

    protected EndPermissionImpl() {
    }

    protected EClass eStaticClass() {
        return ConstraintAdvicePackage.Literals.END_PERMISSION;
    }

    @Override
    public EndKind getEndKind() {
        return this.endKind;
    }

    @Override
    public void setEndKind(EndKind newEndKind) {
        EndKind oldEndKind = this.endKind;
        EndKind endKind = this.endKind = newEndKind == null ? END_KIND_EDEFAULT : newEndKind;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldEndKind, (Object)this.endKind));
        }
    }

    @Override
    public boolean isPermitted() {
        return this.permitted;
    }

    @Override
    public void setPermitted(boolean newPermitted) {
        boolean oldPermitted = this.permitted;
        this.permitted = newPermitted;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldPermitted, this.permitted));
        }
    }

    @Override
    public Filter getEndFilter() {
        return this.endFilter;
    }

    public NotificationChain basicSetEndFilter(Filter newEndFilter, NotificationChain msgs) {
        Filter oldEndFilter = this.endFilter;
        this.endFilter = newEndFilter;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldEndFilter, (Object)newEndFilter);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setEndFilter(Filter newEndFilter) {
        if (newEndFilter != this.endFilter) {
            NotificationChain msgs = null;
            if (this.endFilter != null) {
                msgs = ((InternalEObject)this.endFilter).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newEndFilter != null) {
                msgs = ((InternalEObject)newEndFilter).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetEndFilter(newEndFilter, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newEndFilter, (Object)newEndFilter));
        }
    }

    @Override
    public boolean matches(EObject end) {
        return EndPermissionOperations.matches(this, end);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetEndFilter(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getEndKind();
            }
            case 2: {
                return this.isPermitted();
            }
            case 3: {
                return this.getEndFilter();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setEndKind((EndKind)((Object)newValue));
                return;
            }
            case 2: {
                this.setPermitted((Boolean)newValue);
                return;
            }
            case 3: {
                this.setEndFilter((Filter)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setEndKind(END_KIND_EDEFAULT);
                return;
            }
            case 2: {
                this.setPermitted(true);
                return;
            }
            case 3: {
                this.setEndFilter(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.endKind != END_KIND_EDEFAULT;
            }
            case 2: {
                return !this.permitted;
            }
            case 3: {
                return this.endFilter != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.matches((EObject)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (endKind: ");
        result.append((Object)this.endKind);
        result.append(", permitted: ");
        result.append(this.permitted);
        result.append(')');
        return result.toString();
    }
}

