/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.databinding;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.appearance.commands.SetNameLabelIconCommand;
import org.eclipse.papyrus.infra.emf.appearance.commands.SetQualifiedNameDepthCommand;
import org.eclipse.papyrus.infra.emf.appearance.commands.SetShadowFigureCommand;
import org.eclipse.papyrus.infra.emf.appearance.helper.AppearanceHelper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.tools.databinding.CommandBasedObservableValue;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.databinding.AbstractUMLAggregatedObservableValue;

public class ElementCustomizationObservableValue
extends AbstractUMLAggregatedObservableValue
implements CommandBasedObservableValue,
AggregatedObservable {
    private EditPart sourceElement;
    private Property property;
    private TransactionalEditingDomain transactionalDomain;
    private View notationElement;

    public ElementCustomizationObservableValue(EditPart sourceElement, Property property) {
        super(EMFHelper.resolveEditingDomain((Object)sourceElement));
        this.sourceElement = sourceElement;
        this.property = property;
        this.notationElement = (View)sourceElement.getModel();
        if (this.domain instanceof TransactionalEditingDomain) {
            this.transactionalDomain = (TransactionalEditingDomain)this.domain;
        }
    }

    public Object getValueType() {
        switch (this.property) {
            case QUALIFIED_NAME: {
                return Integer.class;
            }
            case ELEMENT_ICON: 
            case SHADOW: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    protected Object doGetValue() {
        switch (this.property) {
            case ELEMENT_ICON: {
                return AppearanceHelper.showElementIcon((EModelElement)this.notationElement);
            }
            case SHADOW: {
                return AppearanceHelper.showShadow((EModelElement)this.notationElement);
            }
            case QUALIFIED_NAME: {
                return AppearanceHelper.getQualifiedNameDepth((EModelElement)this.notationElement);
            }
        }
        return null;
    }

    protected void doSetValue(Object value) {
        Command command = this.getCommand(value);
        this.domain.getCommandStack().execute(command);
    }

    public Command getCommand(Object value) {
        switch (this.property) {
            case ELEMENT_ICON: {
                if (value instanceof Boolean) {
                    return new SetNameLabelIconCommand(this.transactionalDomain, (EModelElement)this.notationElement, ((Boolean)value).booleanValue());
                }
                Activator.log.warn(String.valueOf(value) + " is not a valid value for ElementIcon ; need a Boolean");
                break;
            }
            case SHADOW: {
                if (value instanceof Boolean) {
                    return new SetShadowFigureCommand(this.transactionalDomain, (EModelElement)this.notationElement, ((Boolean)value).booleanValue());
                }
                Activator.log.warn(String.valueOf(value) + " is not a valid value for Shadow ; need a Boolean");
                break;
            }
            case QUALIFIED_NAME: {
                if (value instanceof Integer) {
                    return new SetQualifiedNameDepthCommand(this.transactionalDomain, (EModelElement)this.notationElement, ((Integer)value).intValue());
                }
                Activator.log.warn(String.valueOf(value) + " is not a valid value for QualifiedNameDepth ; need an Integer");
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    public static enum Property {
        ELEMENT_ICON,
        SHADOW,
        QUALIFIED_NAME;

    }
}

