/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.statemachine.services;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.CommonDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.DomainBasedEdgeServices;
import org.eclipse.papyrus.sirius.uml.diagram.statemachine.StateMachineServices;
import org.eclipse.papyrus.uml.domain.services.labels.ElementDefaultNameProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

public class StateMachineDiagramServices
extends AbstractDiagramServices {
    public static final StateMachineDiagramServices INSTANCE = new StateMachineDiagramServices();

    public EObject createSMD(Element parent, String type, String referenceName, DSemanticDecorator targetView) {
        CommonDiagramServices commonDiagramServices = new CommonDiagramServices();
        if (type.equalsIgnoreCase("Constraint") || type.equalsIgnoreCase("Region")) {
            StateMachineServices stateMachineServices = new StateMachineServices();
            EObject stateParent = stateMachineServices.getStateParent((EObject)parent);
            return commonDiagramServices.createElement((Element)stateParent, type, referenceName, targetView);
        }
        return commonDiagramServices.createElement(parent, type, referenceName, targetView);
    }

    public EObject createPseudoState(Element parent, String type, String referenceName, DSemanticDecorator targetView, String pseudoStateKind) {
        StateMachineServices stateMachineServices = new StateMachineServices();
        EObject stateParent = stateMachineServices.getStateParent((EObject)parent);
        EObject newObject = null;
        String containerViewExpression = "aql:containerView";
        Session session = SessionManager.INSTANCE.getSession((EObject)parent);
        if (referenceName.equalsIgnoreCase("subvertex")) {
            newObject = this.createSMD(parent, type, referenceName, targetView);
            if (parent instanceof Region) {
                this.createView(newObject, targetView, session, containerViewExpression);
            }
        }
        if (referenceName.equalsIgnoreCase("connectionPoint")) {
            if (parent instanceof State) {
                newObject = this.createSMD(parent, type, referenceName, targetView);
                this.createView(newObject, (DSemanticDecorator)targetView.eContainer(), session, containerViewExpression);
            }
            if (parent instanceof Region) {
                newObject = this.createSMD((Element)stateParent, type, referenceName, targetView);
            }
        }
        if (newObject instanceof Pseudostate) {
            Pseudostate pseudostate = (Pseudostate)newObject;
            pseudostate.setKind(PseudostateKind.get((String)pseudoStateKind));
            this.resetDefaultName((NamedElement)pseudostate);
        }
        return newObject;
    }

    public NamedElement resetDefaultName(NamedElement self) {
        if (self == null) {
            return self;
        }
        self.setName(null);
        self.setName(new ElementDefaultNameProvider().getDefaultName(self, self.eContainer()));
        return self;
    }

    public EObject createDomainBasedEdgeSMD(EObject source, EObject target, String type, String containementReferenceName, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        DomainBasedEdgeServices domainBasedEdgeServices = new DomainBasedEdgeServices();
        return domainBasedEdgeServices.createDomainBasedEdge(source, target, type, containementReferenceName, sourceView, targetView);
    }

    public static Collection<Element> link_getTarget_SMD(Element source) {
        if (source instanceof Constraint) {
            Constraint sourceElement = (Constraint)source;
            return sourceElement.getConstrainedElements();
        }
        if (source instanceof Comment) {
            Comment sourceElement = (Comment)source;
            return sourceElement.getAnnotatedElements();
        }
        return null;
    }

    public boolean link_canReconnectSource_SMD(Element context, Element newSource) {
        if (context instanceof Constraint && newSource instanceof Constraint) {
            return true;
        }
        return context instanceof Comment && newSource instanceof Comment;
    }

    public boolean link_canReconnectTarget_SMD(Element context, Element newSource) {
        return newSource instanceof State || newSource instanceof Comment || newSource instanceof Constraint || newSource instanceof FinalState || newSource instanceof Transition || newSource instanceof Pseudostate;
    }

    public void link_reconnectSource_SMD(Element context, Element oldSource, Element newSource, EObject otherEnd) {
        Element target = null;
        if (otherEnd instanceof DSemanticDecorator) {
            target = (Element)((DSemanticDecorator)otherEnd).getTarget();
        }
        if (oldSource instanceof Comment) {
            ((Comment)oldSource).getAnnotatedElements().remove((Object)target);
        } else if (oldSource instanceof Constraint) {
            ((Constraint)oldSource).getConstrainedElements().remove((Object)target);
        }
        if (newSource instanceof Comment) {
            ((Comment)newSource).getAnnotatedElements().add((Object)target);
        } else if (newSource instanceof Constraint) {
            ((Constraint)newSource).getConstrainedElements().add((Object)target);
        }
    }

    public void link_reconnectTarget_SMD(Element context, Element oldTarget, Element newTarget, EObject otherEnd) {
        Element source = null;
        if (otherEnd instanceof DSemanticDecorator) {
            source = (Element)((DSemanticDecorator)otherEnd).getTarget();
        }
        if (source instanceof Comment) {
            ((Comment)source).getAnnotatedElements().remove((Object)oldTarget);
            ((Comment)source).getAnnotatedElements().add((Object)newTarget);
        } else if (source instanceof Constraint) {
            ((Constraint)source).getConstrainedElements().remove((Object)oldTarget);
            ((Constraint)source).getConstrainedElements().add((Object)newTarget);
        }
    }

    public boolean contextLink_isValidSourceAndTarget_SMD(EObject context, EObject sourceView, EObject targetView, Element source, Element target) {
        boolean isValid = false;
        if (source == target) {
            return false;
        }
        if (source instanceof Constraint) {
            isValid = target instanceof Namespace;
        }
        return isValid;
    }

    public boolean transition_canReconnectSource(Element context, Element newSource) {
        return newSource instanceof FinalState || newSource instanceof Pseudostate || newSource instanceof State;
    }

    public boolean transition_canReconnectTarget(Element context, Element newTarget) {
        return newTarget instanceof FinalState || newTarget instanceof Pseudostate || newTarget instanceof State;
    }

    public void transition_reconnectSource(Transition transition, Vertex oldSource, Vertex newSource) {
        transition.setSource(newSource);
        Region region = newSource.getContainer();
        Element owner = transition.getOwner();
        if (owner != region) {
            region.getTransitions().add((Object)transition);
        }
    }

    public void transition_reconnectTarget(Transition transition, Vertex oldTarget, Vertex newTarget) {
        transition.setTarget(newTarget);
    }

    public Collection<Transition> transition_getSemanticCandidates(EObject semanticContext) {
        HashSet<Transition> transitions = new HashSet<Transition>();
        if (semanticContext instanceof StateMachine) {
            StateMachine stateMachine = (StateMachine)semanticContext;
            for (Region r : stateMachine.getRegions()) {
                transitions.addAll(StateMachineDiagramServices.getAllTransition(r));
            }
        }
        return transitions;
    }

    private static final Collection<Transition> getAllTransition(Region reg) {
        HashSet<Transition> transitions = new HashSet<Transition>();
        for (NamedElement current : reg.getMembers()) {
            if (current instanceof Region) {
                transitions.addAll(StateMachineDiagramServices.getAllTransition((Region)current));
            }
            if (current instanceof State) {
                transitions.addAll(StateMachineDiagramServices.getAllTransition((State)current));
            }
            if (!(current instanceof Transition)) continue;
            transitions.add((Transition)current);
        }
        return transitions;
    }

    private static final Collection<Transition> getAllTransition(State state) {
        HashSet<Transition> transitions = new HashSet<Transition>();
        Iterator iter = state.getRegions().iterator();
        while (iter.hasNext()) {
            transitions.addAll(StateMachineDiagramServices.getAllTransition((Region)iter.next()));
        }
        return transitions;
    }
}

