/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.util.GCFactory;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class MaxCellBoundsHelper {
    private MaxCellBoundsHelper() {
    }

    public static int[] getPreferredColumnWidths(IConfigRegistry configRegistry, GCFactory gcFactory, ILayer layer, int[] columnPositions) {
        GC gc = gcFactory.createGC();
        if (gc != null) {
            try {
                int[] columnWidths = new int[columnPositions.length];
                int i = 0;
                while (i < columnPositions.length) {
                    columnWidths[i] = MaxCellBoundsHelper.getPreferredColumnWidth(layer, columnPositions[i], configRegistry, gc);
                    ++i;
                }
                int[] nArray = columnWidths;
                return nArray;
            }
            finally {
                gc.dispose();
            }
        }
        return new int[0];
    }

    private static int getPreferredColumnWidth(ILayer layer, int columnPosition, IConfigRegistry configRegistry, GC gc) {
        int maxWidth = -1;
        int rowPosition = 0;
        while (rowPosition < layer.getRowCount()) {
            ILayerCell cell = layer.getCellByPosition(columnPosition, rowPosition);
            if (cell != null) {
                ICellPainter painter;
                boolean atEndOfCellSpan;
                boolean bl = atEndOfCellSpan = cell.getOriginColumnPosition() + cell.getColumnSpan() - 1 == columnPosition;
                if (atEndOfCellSpan && (painter = layer.getCellPainter(cell.getColumnPosition(), cell.getRowPosition(), cell, configRegistry)) != null) {
                    int preferredWidth = painter.getPreferredWidth(cell, gc, configRegistry);
                    Rectangle bounds = cell.getBounds();
                    bounds.width = preferredWidth;
                    Rectangle adjustedCellBounds = cell.getLayer().getLayerPainter().adjustCellBounds(columnPosition, rowPosition, bounds);
                    preferredWidth += preferredWidth - adjustedCellBounds.width;
                    if (cell.getColumnSpan() > 1) {
                        int columnStartX = layer.getStartXOfColumnPosition(columnPosition);
                        int cellStartX = layer.getStartXOfColumnPosition(cell.getOriginColumnPosition());
                        preferredWidth = Math.max(0, preferredWidth - (columnStartX - cellStartX));
                    }
                    maxWidth = preferredWidth > maxWidth ? preferredWidth : maxWidth;
                }
            }
            ++rowPosition;
        }
        return maxWidth;
    }

    public static int[] getPreferredRowHeights(IConfigRegistry configRegistry, GCFactory gcFactory, ILayer layer, int[] rowPositions) {
        GC gc = gcFactory.createGC();
        if (gc != null) {
            try {
                int[] rowHeights = new int[rowPositions.length];
                int i = 0;
                while (i < rowPositions.length) {
                    rowHeights[i] = MaxCellBoundsHelper.getPreferredRowHeight(layer, rowPositions[i], configRegistry, gc);
                    ++i;
                }
                int[] nArray = rowHeights;
                return nArray;
            }
            finally {
                gc.dispose();
            }
        }
        return new int[0];
    }

    private static int getPreferredRowHeight(ILayer layer, int rowPosition, IConfigRegistry configRegistry, GC gc) {
        int maxHeight = -1;
        int columnPosition = 0;
        while (columnPosition < layer.getColumnCount()) {
            ILayerCell cell = layer.getCellByPosition(columnPosition, rowPosition);
            if (cell != null) {
                ICellPainter painter;
                boolean atEndOfCellSpan;
                boolean bl = atEndOfCellSpan = cell.getOriginRowPosition() + cell.getRowSpan() - 1 == rowPosition;
                if (atEndOfCellSpan && (painter = layer.getCellPainter(cell.getColumnPosition(), cell.getRowPosition(), cell, configRegistry)) != null) {
                    int preferredHeight = painter.getPreferredHeight(cell, gc, configRegistry);
                    Rectangle bounds = cell.getBounds();
                    bounds.height = preferredHeight;
                    Rectangle adjustedCellBounds = cell.getLayer().getLayerPainter().adjustCellBounds(columnPosition, rowPosition, bounds);
                    preferredHeight += preferredHeight - adjustedCellBounds.height;
                    if (cell.getRowSpan() > 1) {
                        int rowStartY = layer.getStartYOfRowPosition(rowPosition);
                        int cellStartY = layer.getStartYOfRowPosition(cell.getOriginRowPosition());
                        preferredHeight = Math.max(0, preferredHeight - (rowStartY - cellStartY));
                    }
                    maxHeight = preferredHeight > maxHeight ? preferredHeight : maxHeight;
                }
            }
            ++columnPosition;
        }
        return maxHeight;
    }

    public static int[] greater(int[] array1, int[] array2) {
        int resultSize = array1.length < array2.length ? array1.length : array2.length;
        int[] result = new int[resultSize];
        int i = 0;
        while (i < resultSize) {
            result[i] = array1[i] > array2[i] ? array1[i] : array2[i];
            ++i;
        }
        return result;
    }
}

