/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.activity.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sirius.uml.diagram.activity.services.ActivityDomainBasedEdgeServices;
import org.eclipse.papyrus.sirius.uml.diagram.activity.services.ActivityFeatureProvider;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.EditableChecker;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.CommonDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.ReconnectServices;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityGroup;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExpansionNode;
import org.eclipse.uml2.uml.ExpansionRegion;
import org.eclipse.uml2.uml.InterruptibleActivityRegion;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.UMLPackage;

public class ActivityDiagramServices
extends AbstractDiagramServices {
    private static final String ACTIVITY_EDGE_CONTAINMENT_FEATURE_NAME = "edge";
    private static final String AD_DECISION_NODE = "AD_DecisionNode";
    private static final String DECISION_INPUT = "decisionInput";

    public Collection<ActivityNode> getActivityNodeCandidates(EObject semanticContext) {
        Object activityNodes = Collections.emptyList();
        if (semanticContext instanceof Activity) {
            Activity activity = (Activity)semanticContext;
            activityNodes = activity.getNodes().stream().filter(node -> node.getInGroups().isEmpty() && node.getInStructuredNode() == null).collect(Collectors.toList());
        } else if (semanticContext instanceof ActivityPartition) {
            ActivityPartition activityPartition = (ActivityPartition)semanticContext;
            activityNodes = activityPartition.getNodes().stream().filter(node -> node.getInStructuredNode() == null).collect(Collectors.toList());
        } else if (semanticContext instanceof InterruptibleActivityRegion) {
            InterruptibleActivityRegion interruptibleActivityRegion = (InterruptibleActivityRegion)semanticContext;
            activityNodes = interruptibleActivityRegion.getNodes().stream().filter(node -> node.getInStructuredNode() == null).collect(Collectors.toList());
        } else if (semanticContext instanceof StructuredActivityNode) {
            StructuredActivityNode structuredActivityNode = (StructuredActivityNode)semanticContext;
            activityNodes = structuredActivityNode.getNodes();
        }
        return activityNodes;
    }

    public Collection<ActivityPartition> getActivityPartitionCandidates(EObject semanticContext) {
        EList activityPartitions = Collections.emptyList();
        if (semanticContext instanceof Activity) {
            Activity activity = (Activity)semanticContext;
            activityPartitions = activity.getPartitions();
        } else if (semanticContext instanceof ActivityPartition) {
            ActivityPartition activityPartition = (ActivityPartition)semanticContext;
            activityPartitions = activityPartition.getSubpartitions();
        }
        return activityPartitions;
    }

    public Collection<InterruptibleActivityRegion> getInterruptibleActivityRegionCandidates(EObject semanticContext) {
        Collection<Object> interruptibleActivityRegions = Collections.emptyList();
        if (semanticContext instanceof Activity) {
            Activity activity = (Activity)semanticContext;
            interruptibleActivityRegions = activity.getOwnedGroups().stream().filter(InterruptibleActivityRegion.class::isInstance).map(InterruptibleActivityRegion.class::cast).collect(Collectors.toList());
        }
        return interruptibleActivityRegions;
    }

    public Collection<ExpansionNode> getExpansionNodesCandidates(ExpansionRegion expansionRegion) {
        HashSet<ExpansionNode> expansionNodes = new HashSet<ExpansionNode>();
        expansionNodes.addAll((Collection<ExpansionNode>)expansionRegion.getInputElements());
        expansionNodes.addAll((Collection<ExpansionNode>)expansionRegion.getOutputElements());
        return expansionNodes;
    }

    public EObject createAD(Element parent, String type, String referenceName, DSemanticDecorator targetView) {
        CommonDiagramServices commonDiagramServices = new CommonDiagramServices();
        return commonDiagramServices.createElement(parent, type, referenceName, targetView);
    }

    private EObject caseActivityNodeInActivityGroup(Element parent, String type, DSemanticDecorator targetView, CommonDiagramServices commonDiagramServices, EStructuralFeature parentActivityContainmentFeature) {
        Activity parentActivity = this.findActivity((EObject)parent);
        EObject createdElement = null;
        if (parentActivity != null && (createdElement = commonDiagramServices.createElement((Element)parentActivity, type, parentActivityContainmentFeature.getName(), targetView)) instanceof ActivityNode) {
            ElementFeatureModifier featureModifier = new ElementFeatureModifier(this.getECrossReferenceAdapter((EObject)parent), (IEditableChecker)new EditableChecker());
            String featureName = null;
            if (parent instanceof ActivityPartition) {
                featureName = UMLPackage.eINSTANCE.getActivityPartition_Node().getName();
            } else if (parent instanceof InterruptibleActivityRegion) {
                featureName = UMLPackage.eINSTANCE.getInterruptibleActivityRegion_Node().getName();
            }
            if (featureName != null) {
                featureModifier.addValue((EObject)parent, featureName, (Object)createdElement);
            }
        }
        return createdElement;
    }

    public EObject createActivityPartition(Element parent, DSemanticDecorator targetView) {
        EObject returnedElement = null;
        if (parent instanceof Activity) {
            returnedElement = this.createAD(parent, UMLPackage.eINSTANCE.getActivityPartition().getName(), UMLPackage.eINSTANCE.getActivity_Partition().getName(), targetView);
        } else if (parent instanceof ActivityPartition) {
            returnedElement = this.createAD(parent, UMLPackage.eINSTANCE.getActivityPartition().getName(), UMLPackage.eINSTANCE.getActivityPartition_Subpartition().getName(), targetView);
        }
        return returnedElement;
    }

    public EObject createInterruptibleActivityRegion(Element parent, DSemanticDecorator targetView) {
        EObject returnedElement = null;
        if (parent instanceof Activity) {
            returnedElement = this.createAD(parent, UMLPackage.eINSTANCE.getInterruptibleActivityRegion().getName(), UMLPackage.eINSTANCE.getActivity_OwnedGroup().getName(), targetView);
        }
        return returnedElement;
    }

    public void createStructuredActivityNode(Element parent, String type, DSemanticDecorator targetView) {
        this.createActivityNode(parent, type, targetView, (EStructuralFeature)UMLPackage.eINSTANCE.getActivity_StructuredNode());
    }

    public void createActivityNode(Element parent, String type, DSemanticDecorator targetView) {
        this.createActivityNode(parent, type, targetView, (EStructuralFeature)UMLPackage.eINSTANCE.getActivity_OwnedNode());
    }

    private void createActivityNode(Element parent, String type, DSemanticDecorator targetView, EStructuralFeature parentActivityContainmentFeature) {
        CommonDiagramServices commonDiagramServices = new CommonDiagramServices();
        if (parent instanceof Activity) {
            commonDiagramServices.createElement(parent, type, parentActivityContainmentFeature.getName(), targetView);
        } else if (parent instanceof ActivityGroup && !(parent instanceof StructuredActivityNode)) {
            this.caseActivityNodeInActivityGroup(parent, type, targetView, commonDiagramServices, parentActivityContainmentFeature);
        } else if (parent instanceof StructuredActivityNode) {
            commonDiagramServices.createElement(parent, type, UMLPackage.eINSTANCE.getStructuredActivityNode_Node().getName(), targetView);
        }
    }

    private Activity findActivity(EObject editElement) {
        Activity container = null;
        if (editElement instanceof ActivityGroup) {
            ActivityGroup activityGroup = (ActivityGroup)editElement;
            container = activityGroup.eContainer() instanceof Activity ? (Activity)activityGroup.eContainer() : this.findActivity(activityGroup.eContainer());
        }
        return container;
    }

    public EObject createActionInputPin(Element parent, DSemanticDecorator targetView) {
        return this.createPin(parent, UMLPackage.eINSTANCE.getActionInputPin().getName(), targetView);
    }

    public EObject createInputPin(Element parent, DSemanticDecorator targetView) {
        return this.createPin(parent, UMLPackage.eINSTANCE.getInputPin().getName(), targetView);
    }

    public EObject createOutputPin(Element parent, DSemanticDecorator targetView) {
        return this.createPin(parent, UMLPackage.eINSTANCE.getOutputPin().getName(), targetView);
    }

    public EObject createValuePin(Element parent, DSemanticDecorator targetView) {
        return this.createPin(parent, UMLPackage.eINSTANCE.getValuePin().getName(), targetView);
    }

    private EObject createPin(Element parent, String typeToCreate, DSemanticDecorator targetView) {
        EObject createdObject = null;
        EStructuralFeature feature = new ActivityFeatureProvider().getActivityFeature((EObject)parent, typeToCreate);
        if (feature != null) {
            createdObject = this.createAD(parent, typeToCreate, feature.getName(), targetView);
        }
        return createdObject;
    }

    public String getDecisionInputNoteLabel(DecisionNode decisionNode) {
        return Optional.ofNullable(decisionNode).map(DecisionNode::getDecisionInput).map(this::computeDecisionInputLabel).orElse("");
    }

    private String computeDecisionInputLabel(Behavior behavior) {
        return "\u00abdecisionInput\u00bb " + behavior.getName();
    }

    public boolean isDecisionNodeMappingVisible(DecisionNode decisionNode, DSemanticDecorator containerView) {
        return Optional.ofNullable(containerView).filter(DNodeContainer.class::isInstance).map(DNodeContainer.class::cast).map(DDiagramElementContainer::getNodes).stream().flatMap(Collection::stream).filter(dNode -> this.isRepresentingDecisionNode((DNode)dNode, decisionNode)).findFirst().isPresent();
    }

    private boolean isRepresentingDecisionNode(DNode dNode, DecisionNode decisionNode) {
        return decisionNode.equals(dNode.getTarget()) && AD_DECISION_NODE.equals(dNode.getActualMapping().getName());
    }

    public void createExpansionNode(ExpansionRegion parentExpansionRegion, DSemanticDecorator targetView, boolean isInput) {
        CommonDiagramServices commonDiagramServices = new CommonDiagramServices();
        EObject createdElement = commonDiagramServices.createElement((Element)parentExpansionRegion, "uml::ExpansionNode", UMLPackage.eINSTANCE.getStructuredActivityNode_Node().getName(), targetView);
        if (createdElement instanceof ExpansionNode) {
            EReference expansionRegionFeature;
            EReference expansionNodeFeature;
            if (isInput) {
                expansionNodeFeature = UMLPackage.eINSTANCE.getExpansionNode_RegionAsInput();
                expansionRegionFeature = UMLPackage.eINSTANCE.getExpansionRegion_InputElement();
            } else {
                expansionNodeFeature = UMLPackage.eINSTANCE.getExpansionNode_RegionAsOutput();
                expansionRegionFeature = UMLPackage.eINSTANCE.getExpansionRegion_OutputElement();
            }
            ElementFeatureModifier featureModifier = new ElementFeatureModifier(this.getECrossReferenceAdapter((EObject)parentExpansionRegion), (IEditableChecker)new EditableChecker());
            featureModifier.addValue(createdElement, expansionNodeFeature.getName(), (Object)parentExpansionRegion);
            featureModifier.addValue((EObject)parentExpansionRegion, expansionRegionFeature.getName(), (Object)createdElement);
        }
    }

    public boolean canCreateIntoParent(EObject container, EClass objectToCreate) {
        EStructuralFeature feature = new ActivityFeatureProvider().getActivityFeature(container, objectToCreate.getName());
        return super.canCreate(container, objectToCreate, feature);
    }

    public boolean canCreateAD(EObject container, EClass objectToCreate, String containmentReferenceName) {
        return super.canCreate(container, objectToCreate, containmentReferenceName);
    }

    public boolean canCreateActivityPartition(EObject container) {
        boolean canCreate = false;
        if (container instanceof Activity) {
            canCreate = super.canCreate(container, UMLPackage.eINSTANCE.getActivityPartition(), (EStructuralFeature)UMLPackage.eINSTANCE.getActivity_OwnedGroup());
        } else if (container instanceof ActivityPartition) {
            canCreate = super.canCreate(container, UMLPackage.eINSTANCE.getActivityPartition(), (EStructuralFeature)UMLPackage.eINSTANCE.getActivityPartition_Subpartition());
        }
        return canCreate;
    }

    public boolean canCreateActivityNode(EObject container, EClass objectToCreate) {
        return this.canCreateActivityNode(container, objectToCreate, (EStructuralFeature)UMLPackage.eINSTANCE.getActivity_OwnedNode());
    }

    public boolean canCreateStructuredActivityNode(EObject container, EClass objectToCreate) {
        return this.canCreateActivityNode(container, objectToCreate, (EStructuralFeature)UMLPackage.eINSTANCE.getActivity_StructuredNode());
    }

    private boolean canCreateActivityNode(EObject container, EClass objectToCreate, EStructuralFeature activityContainmentFeature) {
        boolean canCreate = false;
        if (container instanceof Activity) {
            canCreate = super.canCreate(container, objectToCreate, activityContainmentFeature);
        } else if (container instanceof ActivityGroup && !(container instanceof StructuredActivityNode)) {
            canCreate = this.canCreateActivityNodeInActivityGroup(container, objectToCreate, activityContainmentFeature);
        } else if (container instanceof StructuredActivityNode) {
            canCreate = super.canCreate(container, objectToCreate, (EStructuralFeature)UMLPackage.eINSTANCE.getStructuredActivityNode_Node());
        }
        return canCreate;
    }

    private boolean canCreateActivityNodeInActivityGroup(EObject container, EClass objectToCreate, EStructuralFeature activityContainmentFeature) {
        boolean canCreate = false;
        Activity parentActivity = this.findActivity(container);
        if (parentActivity != null) {
            canCreate = super.canCreate((EObject)parentActivity, objectToCreate, activityContainmentFeature);
        }
        return canCreate;
    }

    public boolean canCreateInterruptibleActivityRegion(EObject container) {
        boolean canCreate = false;
        if (container instanceof Activity) {
            canCreate = super.canCreate(container, UMLPackage.eINSTANCE.getInterruptibleActivityRegion(), (EStructuralFeature)UMLPackage.eINSTANCE.getActivity_OwnedGroup());
        }
        return canCreate;
    }

    public boolean canCreateExpansionNode(EObject container) {
        boolean canCreate = false;
        if (container instanceof ExpansionRegion) {
            canCreate = super.canCreate(container, UMLPackage.eINSTANCE.getExpansionNode(), (EStructuralFeature)UMLPackage.eINSTANCE.getStructuredActivityNode_Node());
        }
        return canCreate;
    }

    public Collection<ActivityEdge> getActivityEdgesCandidates(EObject semanticContext) {
        HashSet<ActivityEdge> activityEdges = new HashSet<ActivityEdge>();
        if (semanticContext instanceof Activity) {
            Activity activity = (Activity)semanticContext;
            activityEdges.addAll((Collection<ActivityEdge>)activity.getEdges());
            activity.allOwnedElements().stream().forEach(ownedElement -> activityEdges.addAll(this.getActivityEdgesInElement((Element)ownedElement)));
        }
        return activityEdges;
    }

    private Collection<ActivityEdge> getActivityEdgesInElement(Element element) {
        ArrayList<ActivityEdge> activityEdges = new ArrayList<ActivityEdge>();
        if (element instanceof Activity) {
            activityEdges.addAll((Collection<ActivityEdge>)((Activity)element).getEdges());
            this.addActivityEdgesFromSubElement(element, activityEdges);
        } else if (element instanceof StructuredActivityNode) {
            activityEdges.addAll((Collection<ActivityEdge>)((StructuredActivityNode)element).getEdges());
            this.addActivityEdgesFromSubElement(element, activityEdges);
        }
        return activityEdges;
    }

    private void addActivityEdgesFromSubElement(Element element, Collection<ActivityEdge> activityEdges) {
        element.allOwnedElements().stream().forEach(ownedElement -> activityEdges.addAll(this.getActivityEdgesInElement((Element)ownedElement)));
    }

    public EObject createControlFlow(EObject source, EObject target, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        ActivityDomainBasedEdgeServices domainBasedEdgeServices = new ActivityDomainBasedEdgeServices();
        return domainBasedEdgeServices.createDomainBasedEdge(source, target, UMLPackage.eINSTANCE.getControlFlow().getName(), ACTIVITY_EDGE_CONTAINMENT_FEATURE_NAME, sourceView, targetView);
    }

    public EObject createObjectFlow(EObject source, EObject target, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        ActivityDomainBasedEdgeServices domainBasedEdgeServices = new ActivityDomainBasedEdgeServices();
        return domainBasedEdgeServices.createDomainBasedEdge(source, target, UMLPackage.eINSTANCE.getObjectFlow().getName(), ACTIVITY_EDGE_CONTAINMENT_FEATURE_NAME, sourceView, targetView);
    }

    public void reconnectSourceAD(EObject semanticElementEdge, Element oldSource, Element newSource, DSemanticDecorator newSourceView) {
        ReconnectServices reconnectServices = new ReconnectServices();
        Element newSourceToReconnectTo = newSource;
        DSemanticDecorator newSourceViewToReconnectTo = newSourceView;
        if (UMLPackage.eINSTANCE.getObjectFlow().isInstance((Object)semanticElementEdge) && UMLPackage.eINSTANCE.getOpaqueAction().isInstance((Object)newSource)) {
            newSourceToReconnectTo = this.createOutputPin(newSource, newSourceView);
            ((ObjectFlow)semanticElementEdge).setSource((ActivityNode)((Pin)newSourceToReconnectTo));
            DSemanticDecorator createdView = this.createAdditionalSourceView(semanticElementEdge, newSourceViewToReconnectTo);
            if (createdView != null) {
                newSourceViewToReconnectTo = createdView;
            }
            reconnectServices.reconnectSource(semanticElementEdge, (EObject)oldSource, (EObject)newSourceToReconnectTo, newSourceViewToReconnectTo);
            Session session = SessionManager.INSTANCE.getSession((EObject)newSourceToReconnectTo);
            this.createEdgeView(semanticElementEdge, (DDiagramElement)((DNode)newSourceViewToReconnectTo), session);
        } else {
            reconnectServices.reconnectSource(semanticElementEdge, (EObject)oldSource, (EObject)newSourceToReconnectTo, newSourceViewToReconnectTo);
        }
    }

    public void reconnectTargetAD(EObject semanticElementEdge, Element oldTarget, Element newTarget, DSemanticDecorator newTargetView) {
        ReconnectServices reconnectServices = new ReconnectServices();
        Element newTargetToReconnectTo = newTarget;
        DSemanticDecorator newTargetViewToReconnectTo = newTargetView;
        if (UMLPackage.eINSTANCE.getObjectFlow().isInstance((Object)semanticElementEdge) && UMLPackage.eINSTANCE.getOpaqueAction().isInstance((Object)newTarget)) {
            newTargetToReconnectTo = this.createInputPin(newTarget, newTargetView);
            ((ObjectFlow)semanticElementEdge).setTarget((ActivityNode)((Pin)newTargetToReconnectTo));
            DSemanticDecorator createdView = this.createAdditionalTargetView(semanticElementEdge, newTargetViewToReconnectTo);
            if (createdView != null) {
                newTargetViewToReconnectTo = createdView;
            }
            reconnectServices.reconnectTarget(semanticElementEdge, (EObject)oldTarget, (EObject)newTargetToReconnectTo, newTargetViewToReconnectTo);
            Session session = SessionManager.INSTANCE.getSession((EObject)newTargetToReconnectTo);
            this.createEdgeView(semanticElementEdge, (DDiagramElement)((DNode)newTargetViewToReconnectTo), session);
        } else {
            reconnectServices.reconnectTarget(semanticElementEdge, (EObject)oldTarget, (EObject)newTargetToReconnectTo, newTargetViewToReconnectTo);
        }
    }

    private DSemanticDecorator createAdditionalSourceView(EObject semanticEdge, DSemanticDecorator sourceView) {
        DSemanticDecorator result = null;
        if (semanticEdge instanceof ObjectFlow) {
            ObjectFlow objectFlow = (ObjectFlow)semanticEdge;
            ActivityNode source = objectFlow.getSource();
            Session session = SessionManager.INSTANCE.getSession(semanticEdge);
            IInterpreter interpreter = session.getInterpreter();
            if (interpreter != null && source != sourceView.getTarget()) {
                interpreter.setVariable("containerView", (Object)sourceView);
                try {
                    this.createView((EObject)source, sourceView, session, "aql:containerView");
                }
                finally {
                    interpreter.unSetVariable("containerView");
                }
                Object createdView = interpreter.getVariable("createdView");
                if (createdView instanceof DSemanticDecorator) {
                    DSemanticDecorator dSemanticDecorator;
                    result = dSemanticDecorator = (DSemanticDecorator)createdView;
                }
            }
        }
        return result;
    }

    private DSemanticDecorator createAdditionalTargetView(EObject semanticEdge, DSemanticDecorator targetView) {
        DSemanticDecorator result = null;
        if (semanticEdge instanceof ObjectFlow) {
            ObjectFlow objectFlow = (ObjectFlow)semanticEdge;
            ActivityNode target = objectFlow.getTarget();
            Session session = SessionManager.INSTANCE.getSession(semanticEdge);
            IInterpreter interpreter = session.getInterpreter();
            if (interpreter != null && target != targetView.getTarget()) {
                interpreter.setVariable("containerView", (Object)targetView);
                try {
                    this.createView((EObject)target, targetView, session, "aql:containerView");
                }
                finally {
                    interpreter.unSetVariable("containerView");
                }
                Object createdView = interpreter.getVariable("createdView");
                if (createdView instanceof DSemanticDecorator) {
                    DSemanticDecorator dSemanticDecorator;
                    result = dSemanticDecorator = (DSemanticDecorator)createdView;
                }
            }
        }
        return result;
    }
}

