/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.search.scope;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.views.search.Activator;
import org.eclipse.papyrus.views.search.Messages;
import org.eclipse.papyrus.views.search.scope.IScopeProvider;
import org.eclipse.papyrus.views.search.scope.ResourceVisitor;
import org.eclipse.papyrus.views.search.utils.ModelUtils;

public class WorkspaceScopeProvider
implements IScopeProvider {
    @Override
    public Collection<URI> getScope() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return WorkspaceScopeProvider.findPapyrusModels((IResource)root);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Collection<URI> getScope(Object object) {
        if (object instanceof IPapyrusFile) {
            return WorkspaceScopeProvider.findPapyrusModels((IResource)((IPapyrusFile)object).getMainFile());
        }
        if (object instanceof IResource) {
            return WorkspaceScopeProvider.findPapyrusModels((IResource)object);
        }
        Object element = BusinessModelResolver.getInstance().getBusinessModel(object);
        if (!(element instanceof EObject)) return Collections.emptyList();
        Resource eResource = element instanceof Resource ? (Resource)element : ((EObject)element).eResource();
        if (eResource == null) return Collections.emptyList();
        ModelSet modelSet = null;
        try {
            Collection<URI> results;
            try {
                modelSet = ModelUtils.openResource(eResource.getURI());
                SashModel sashModel = (SashModel)modelSet.getModelChecked("org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel");
                Resource diResource = sashModel.getResource();
                results = diResource != null ? Collections.singletonList(diResource.getURI()) : Collections.emptyList();
                return results;
            }
            catch (ModelMultiException e) {
                results = Collections.emptyList();
                if (modelSet == null) return results;
                try {
                    modelSet.unload();
                    return results;
                }
                catch (Exception e2) {
                    Activator.log.error((Throwable)e2);
                }
                return results;
            }
            catch (NotFoundException e) {
                results = Collections.emptyList();
                if (modelSet == null) return results;
                try {
                    modelSet.unload();
                    return results;
                }
                catch (Exception e3) {
                    Activator.log.error((Throwable)e3);
                }
                return results;
            }
        }
        finally {
            if (modelSet != null) {
                try {
                    modelSet.unload();
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    static Collection<URI> findPapyrusModels(IResource res) {
        ResourceVisitor visitor = new ResourceVisitor();
        try {
            res.accept((IResourceProxyVisitor)visitor, 2);
        }
        catch (CoreException e) {
            Activator.log.warn(Messages.ScopeCollector_0 + String.valueOf(res));
        }
        return visitor.getParticipantURIs();
    }
}

