/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.properties.constraints;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.constraints.constraints.AbstractConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;

public class IsTreeTableConstraint
extends AbstractConstraint {
    public boolean match(Collection<?> selection) {
        boolean result = false;
        if (!selection.isEmpty()) {
            int elementMultiplicity = this.display.getElementMultiplicity();
            int selectionSize = selection.size();
            if (elementMultiplicity == 1) {
                if (selectionSize == 1 && this.match(selection.iterator().next())) {
                    result = true;
                }
            } else if (elementMultiplicity == selectionSize || elementMultiplicity < 0 && selection.size() > 1) {
                result = true;
                Iterator<?> selectionIterator = selection.iterator();
                while (selectionIterator.hasNext() && result) {
                    Object selectedItem = selectionIterator.next();
                    if (this.match(selectedItem)) continue;
                    result = false;
                }
            }
        }
        return result;
    }

    public boolean match(Object selection) {
        boolean expectedValue = Boolean.parseBoolean(this.getValue("expectedValue"));
        EObject table = EMFHelper.getEObject((Object)selection);
        return table instanceof Table && expectedValue == TableHelper.isTreeTable((Table)((Table)table));
    }

    protected boolean equivalent(Constraint constraint) {
        return constraint == this || constraint instanceof IsTreeTableConstraint;
    }
}

