/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.hierarchical;

import ca.odell.glazedlists.TreeList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalWrapper;

public class HierarchicalWrapperTreeFormat
implements TreeList.Format<HierarchicalWrapper> {
    private int levels = 0;
    private List<Map<Object, HierarchicalWrapper>> parentMapping;

    public HierarchicalWrapperTreeFormat(String ... propertyNames) {
        String[] stringArray = propertyNames;
        int n = propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            this.levels = Math.max(this.levels, property.split("\\.").length);
            ++n2;
        }
        this.parentMapping = new ArrayList<Map<Object, HierarchicalWrapper>>(this.levels);
        int i = 0;
        while (i < this.levels) {
            this.parentMapping.add(new HashMap());
            ++i;
        }
    }

    public void getPath(List<HierarchicalWrapper> path, HierarchicalWrapper element) {
        int i = 0;
        while (i < this.levels - 1) {
            Object levelObject = element.getObject(i);
            if (levelObject != null) {
                HierarchicalWrapper parent = this.parentMapping.get(i).get(levelObject);
                if (parent != null && !path.contains(parent)) {
                    path.add(parent);
                } else {
                    this.parentMapping.get(i).put(levelObject, element);
                }
            }
            ++i;
        }
        path.add(element);
    }

    public boolean allowsChildren(HierarchicalWrapper element) {
        return true;
    }

    public Comparator<? super HierarchicalWrapper> getComparator(int depth) {
        return null;
    }
}

