/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.manager.cell;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.emf.nattable.manager.cell.EMFOperationValueCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.CellHelper;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;
import org.eclipse.papyrus.uml.nattable.Activator;
import org.eclipse.papyrus.uml.nattable.utils.StereotypeOperationUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeOperationCellManager
extends EMFOperationValueCellManager {
    public static final String SEVERAL_STEREOTYPES_WITH_THIS_OPERATION_ARE_APPLIED = "Several stereotypes with this operation are applied -> not yet managed";
    private static final String OPERATION_NOT_IMPLEMENTED = "Not Implemented";

    public boolean handles(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return this.organizeAndResolvedObjects(columnElement, rowElement, null) != null;
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        List<Object> umlObjects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
        if (umlObjects.size() == 2) {
            Element el = (Element)umlObjects.get(0);
            String id = (String)umlObjects.get(1);
            Operation operation = (Operation)StereotypeOperationUtils.getRealStereotypeOperation((EObject)el, id);
            List<Stereotype> stereotypesWithThisOperation = StereotypeOperationUtils.getAppliedStereotypesWithThisOperation(el, id);
            if (stereotypesWithThisOperation.size() == 1) {
                EObject steAppl = el.getStereotypeApplication(stereotypesWithThisOperation.get(0));
                EList operations = steAppl.eClass().getEAllOperations();
                EOperation eOp = null;
                while (eOp == null) {
                    for (EOperation current : operations) {
                        if (!current.getName().equalsIgnoreCase(operation.getName())) continue;
                        eOp = current;
                    }
                }
                try {
                    Object result = steAppl.eInvoke(eOp, ECollections.emptyEList());
                    return result;
                }
                catch (UnsupportedOperationException e) {
                    return OPERATION_NOT_IMPLEMENTED;
                }
                catch (InvocationTargetException e) {
                    Activator.log.error((Throwable)e);
                }
            } else if (stereotypesWithThisOperation.size() > 1) {
                return SEVERAL_STEREOTYPES_WITH_THIS_OPERATION_ARE_APPLIED;
            }
        }
        return CellHelper.getUnsupportedCellContentsText();
    }

    protected List<Object> organizeAndResolvedObjects(Object columnElement, Object rowElement, Map<?, ?> sharedMap) {
        ArrayList<Object> objects = null;
        Object column = AxisUtils.getRepresentedElement((Object)columnElement);
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        if (column instanceof String && ((String)column).startsWith("operation_of_stereotype:/") && row instanceof Element) {
            objects = new ArrayList<Object>();
            objects.add(row);
            objects.add(column);
        }
        if (row instanceof String && ((String)row).startsWith("operation_of_stereotype:/") && column instanceof Element) {
            objects = new ArrayList();
            objects.add(column);
            objects.add(row);
        }
        return objects;
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return false;
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, Map<?, ?> sharedMap, INattableModelManager tableManager) {
        return false;
    }

    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        return null;
    }

    public Command getSetStringValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, String newValue, AbstractStringValueConverter valueSolver, INattableModelManager tableManager) {
        return null;
    }

    public void setStringValue(Object columnElement, Object rowElement, String valueAsString, AbstractStringValueConverter valueSolver, Map<?, ?> sharedMap, INattableModelManager tableManager) {
    }

    public Command getUnsetCellValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return null;
    }
}

