/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.assistant.core.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IEditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ModelingAssistantProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.core.util.IProxyElementType;
import org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core.util.ProxyElementType;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SemanticElementAdapter;
import org.eclipse.papyrus.infra.services.edit.utils.ElementTypeUtils;

public class ModelingAssistantUtil {
    private static final Pattern VISUAL_ID_PATTERN = Pattern.compile("\\d{4,}");

    private ModelingAssistantUtil() {
    }

    public static IElementType[] getElementTypes(ModelingAssistantProvider provider, Object input) {
        Object[] result;
        if (input instanceof IElementType) {
            result = new IElementType[]{(IElementType)input};
        } else if (input instanceof IEditHelperContext) {
            IEditHelperContext context = (IEditHelperContext)input;
            IElementType type = context.getElementType();
            if (type != null) {
                result = new IElementType[]{type};
            } else if (context.getClientContext() == null) {
                result = ElementTypeRegistry.getInstance().getAllTypesMatching(context.getEObject(), provider.getClientContext());
                if (provider.getClientContext() != ElementTypeUtils.getDefaultClientContext()) {
                    Object[] more = ElementTypeRegistry.getInstance().getAllTypesMatching(context.getEObject(), ElementTypeUtils.getDefaultClientContext());
                    result = more.length == 0 ? result : (result.length == 0 ? more : (IElementType[])ObjectArrays.concat((Object[])more, (Object[])result, IElementType.class));
                }
            } else {
                result = ElementTypeRegistry.getInstance().getAllTypesMatching(context.getEObject(), context.getClientContext());
            }
        } else {
            EObject object = (EObject)AdapterUtils.adapt((Object)input, EObject.class, null);
            if (object != null) {
                View view;
                List<IElementType> core = Arrays.asList(ElementTypeRegistry.getInstance().getAllTypesMatching(object, provider.getClientContext()));
                ArrayList resultList = Lists.newArrayListWithExpectedSize((int)core.size());
                if (provider.getClientContext() != ElementTypeUtils.getDefaultClientContext()) {
                    List<IElementType> more = Arrays.asList(ElementTypeRegistry.getInstance().getAllTypesMatching(object, ElementTypeUtils.getDefaultClientContext()));
                    resultList.addAll(more);
                }
                resultList.addAll(core);
                if (!resultList.isEmpty() && (view = (View)AdapterUtils.adapt((Object)input, View.class, null)) != null) {
                    ListIterator<IElementType> iter = resultList.listIterator();
                    while (iter.hasNext()) {
                        IElementType next = (IElementType)iter.next();
                        IElementType hintedType = ModelingAssistantUtil.findHintedSpecializationType(next, view.getType(), object);
                        if (hintedType == null) continue;
                        iter.previous();
                        iter.add(hintedType);
                        iter.next();
                    }
                }
                result = (IElementType[])Iterables.toArray((Iterable)resultList, IElementType.class);
            } else {
                result = new IElementType[]{};
            }
        }
        return result;
    }

    static IElementType findHintedSpecializationType(IElementType type, String hint, EObject semanticElement) {
        IHintedType result = null;
        for (IHintedType next : Iterables.filter(Arrays.asList(ElementTypeRegistry.getInstance().getSpecializationsOf(type.getId())), IHintedType.class)) {
            if (!Objects.equal((Object)next.getSemanticHint(), (Object)hint) || !ModelingAssistantUtil.matches((IElementType)next, semanticElement)) continue;
            result = next;
            break;
        }
        return result;
    }

    static boolean matches(IElementType elementType, EObject element) {
        ISpecializationType specializationType;
        boolean result = elementType instanceof ISpecializationType ? ((specializationType = (ISpecializationType)elementType).getMatcher() != null ? specializationType.getMatcher().matches(element) : (specializationType.getMetamodelType() != null ? ModelingAssistantUtil.matches((IElementType)specializationType.getMetamodelType(), element) : false)) : elementType.getEClass() != null && elementType.getEClass().isInstance((Object)element);
        return result;
    }

    public static void collectAllConcreteSubtypes(IElementType supertype, ModelingAssistantProvider provider, Collection<? super IElementType> types) {
        for (IElementType next : provider.getElementTypes()) {
            if (next.getEClass() == null || next.getEClass().isAbstract() || !ModelingAssistantUtil.isSubtype(next, supertype)) continue;
            types.add((IElementType)next);
        }
    }

    public static boolean isSubtype(IElementType subtype, IElementType supertype) {
        return subtype == supertype || Arrays.asList(subtype.getAllSuperTypes()).contains(supertype);
    }

    public static List<IHintedType> getHintedTypes(IElementType supertype, ModelingAssistantProvider provider, IAdaptable host) {
        List<IHintedType> result = ModelingAssistantUtil.getHintedTypes(supertype, provider);
        if (result.isEmpty() && supertype instanceof ISpecializationType) {
            IElementType surrogate = ((ISpecializationType)supertype).getSpecializedTypes()[0];
            result = ModelingAssistantUtil.getHintedTypes(surrogate, provider);
            boolean needQualifiers = result.size() > 1;
            ListIterator<IHintedType> iter = result.listIterator();
            while (iter.hasNext()) {
                IHintedType next = iter.next();
                if (next == surrogate || Strings.isNullOrEmpty((String)next.getSemanticHint())) continue;
                iter.set(ProxyElementType.create(supertype, next, needQualifiers));
            }
        }
        return result;
    }

    private static List<IHintedType> getHintedTypes(IElementType supertype, ModelingAssistantProvider provider) {
        ArrayList result = Lists.newArrayList();
        EList<IElementType> banned = provider.getExcludedElementTypes();
        ISpecializationType[] iSpecializationTypeArray = ElementTypeRegistry.getInstance().getSpecializationTypes(provider.getClientContext());
        int n = iSpecializationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISpecializationType next = iSpecializationTypeArray[n2];
            if (next instanceof IHintedType && next.isSpecializationOf(supertype) && !ModelingAssistantUtil.isSpecializationOfAny(next, banned)) {
                result.add((IHintedType)next);
            }
            ++n2;
        }
        return result;
    }

    public static boolean isSpecializationOfAny(ISpecializationType elementType, Iterable<? extends IElementType> types) {
        boolean result = false;
        HashSet allSupers = Sets.newHashSet((Object[])elementType.getAllSuperTypes());
        allSupers.add(elementType);
        Iterator<? extends IElementType> iter = types.iterator();
        while (!result && iter.hasNext()) {
            result = allSupers.contains(iter.next());
        }
        return result;
    }

    public static Predicate<? super IElementType> notSpecializationOfAny(final Iterable<? extends IElementType> types) {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                return !(input instanceof ISpecializationType) || !ModelingAssistantUtil.isSpecializationOfAny((ISpecializationType)input, types);
            }
        };
    }

    public static IElementType resolveSemanticType(IElementType type) {
        return type instanceof IProxyElementType ? ((IProxyElementType)type).resolveSemanticType() : type;
    }

    public static IHintedType resolveVisualType(IElementType type) {
        return type instanceof IProxyElementType ? ((IProxyElementType)type).resolveVisualType() : (type instanceof IHintedType ? (IHintedType)type : null);
    }

    @Deprecated
    public static boolean isVisualID(String hint) {
        return VISUAL_ID_PATTERN.matcher(hint = Strings.nullToEmpty((String)hint)).matches() || hint.contains("Diagram") || hint.contains("Shape") || hint.contains("Edge") || hint.contains("Compartment") || hint.contains("Label");
    }

    public static EList<IElementType> filterConnectionTypes(ModelingAssistantProvider provider, Set<IElementType> elementTypes, IAdaptable connectionEnd) {
        Iterable result = Iterables.filter(elementTypes, ModelingAssistantUtil.notSpecializationOfAny(provider.getExcludedElementTypes()));
        final View endView = (View)AdapterUtils.adapt((Object)connectionEnd, View.class, null);
        if (endView != null) {
            result = Iterables.filter((Iterable)result, (Predicate)new Predicate<IElementType>(){

                public boolean apply(IElementType input) {
                    SemanticElementAdapter semanticAdapter = new SemanticElementAdapter(input);
                    String semanticHint = input instanceof IHintedType ? ((IHintedType)input).getSemanticHint() : "";
                    return ViewService.getInstance().provides(Edge.class, (IAdaptable)semanticAdapter, (View)endView.eContainer(), semanticHint, -1, true, null);
                }
            });
        }
        Object[] array = (IElementType[])Iterables.toArray((Iterable)result, IElementType.class);
        Arrays.sort(array, ModelingAssistantUtil.alphabetical());
        return new BasicEList.UnmodifiableEList(array.length, array);
    }

    public static Function<IElementType, String> primaryNameFunction() {
        return new Function<IElementType, String>(){

            public String apply(IElementType input) {
                return input instanceof IProxyElementType ? this.apply(((IProxyElementType)input).resolveSemanticType()) : input.getDisplayName();
            }
        };
    }

    public static Function<IElementType, Integer> visualIDFunction() {
        return new Function<IElementType, Integer>(){

            public Integer apply(IElementType input) {
                String hint;
                int result = 0;
                if (input instanceof IHintedType && !Strings.isNullOrEmpty((String)(hint = ((IHintedType)input).getSemanticHint())) && CharMatcher.digit().matchesAllOf((CharSequence)hint)) {
                    result = Integer.parseInt(hint);
                }
                return result;
            }
        };
    }

    public static Ordering<IElementType> alphabetical() {
        Collator collator = Collator.getInstance();
        collator.setStrength(0);
        return Ordering.from((Comparator)collator).onResultOf(ModelingAssistantUtil.primaryNameFunction()).compound((Comparator)Ordering.natural().onResultOf(ModelingAssistantUtil.visualIDFunction()));
    }
}

