/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.services;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.EditableChecker;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.drop.DnDStatus;
import org.eclipse.papyrus.uml.domain.services.drop.IExternalSourceToRepresentationDropBehaviorProvider;
import org.eclipse.papyrus.uml.domain.services.drop.IExternalSourceToRepresentationDropChecker;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropBehaviorProvider;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.papyrus.uml.domain.services.status.Status;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class CommonDropBehaviorProvider
extends AbstractDiagramServices {
    private final IExternalSourceToRepresentationDropBehaviorProvider externalSourceToRepresentationDropBehaviorProvider;
    private final IExternalSourceToRepresentationDropChecker externalSourceToRepresentationDropChecker;
    private final IInternalSourceToRepresentationDropBehaviorProvider internalSourceToRepresentationDropBehaviorProvider;
    private final IInternalSourceToRepresentationDropChecker internalSourceToRepresentationDropChecker;

    private CommonDropBehaviorProvider(Builder builder) {
        this.externalSourceToRepresentationDropBehaviorProvider = builder.externalSourceToRepresentationDropBehaviorProvider;
        this.externalSourceToRepresentationDropChecker = builder.externalSourceToRepresentationDropChecker;
        this.internalSourceToRepresentationDropBehaviorProvider = builder.internalSourceToRepresentationDropBehaviorProvider;
        this.internalSourceToRepresentationDropChecker = builder.internalSourceToRepresentationDropChecker;
    }

    public void dragAndDropSemantic(EObject droppedElement, Object containerView) {
        this.dragAndDropSemantic(droppedElement, containerView, false);
    }

    public void dragAndDropSemantic(EObject droppedElement, Object containerView, boolean isDiagramWithRoot) {
        DSemanticDecorator targetView;
        DnDStatus semanticDroppedStatus;
        if (containerView != null && containerView instanceof DSemanticDecorator && (State.DONE == (semanticDroppedStatus = this.externalSourceToRepresentationDropBehaviorProvider.drop(droppedElement, (targetView = (DSemanticDecorator)containerView).getTarget(), this.getECrossReferenceAdapter(droppedElement), (IEditableChecker)new EditableChecker())).getState() || State.NOTHING == semanticDroppedStatus.getState())) {
            for (EObject elementToDisplay : semanticDroppedStatus.getElementsToDisplay()) {
                Status isDroppped = null;
                if (this.isCompartment(targetView) && this.isBorderNode(elementToDisplay, (DSemanticDecorator)targetView.eContainer())) {
                    isDroppped = (Status)new DropSemanticSwitch((DSemanticDecorator)targetView.eContainer(), "aql:newContainerView.eContainer()", isDiagramWithRoot).doSwitch(droppedElement);
                }
                if (isDroppped != null) continue;
                isDroppped = (Status)new DropSemanticSwitch(targetView, "aql:newContainerView", isDiagramWithRoot).doSwitch(elementToDisplay);
            }
        }
    }

    public boolean candDragAndDropSemantic(EObject droppedElement, EObject newContainer) {
        CheckStatus canDragAndDrop = this.externalSourceToRepresentationDropChecker.canDragAndDrop(droppedElement, newContainer);
        return canDragAndDrop.isValid();
    }

    public void dragAndDropGraphic(EObject droppedElement, EObject oldContainer, EObject newContainer, Object containerView) {
        Status dropStatus = this.internalSourceToRepresentationDropBehaviorProvider.drop(droppedElement, oldContainer, newContainer, this.getECrossReferenceAdapter(droppedElement), (IEditableChecker)new EditableChecker());
        if (State.DONE == dropStatus.getState() && droppedElement instanceof Property && newContainer instanceof Property && ((Property)newContainer).getType() != null) {
            this.createView(droppedElement, (DSemanticDecorator)containerView, "aql:newContainerView");
        }
    }

    public boolean candDragAndDropGraphic(EObject droppedElement, EObject newContainer) {
        CheckStatus canDragAndDrop = this.internalSourceToRepresentationDropChecker.canDragAndDrop(droppedElement, newContainer);
        return canDragAndDrop.isValid();
    }

    public static Builder newCommonDropBehaviorProvider() {
        return new Builder();
    }

    public static final class Builder {
        private IExternalSourceToRepresentationDropBehaviorProvider externalSourceToRepresentationDropBehaviorProvider;
        private IExternalSourceToRepresentationDropChecker externalSourceToRepresentationDropChecker;
        private IInternalSourceToRepresentationDropBehaviorProvider internalSourceToRepresentationDropBehaviorProvider;
        private IInternalSourceToRepresentationDropChecker internalSourceToRepresentationDropChecker;

        public Builder externalSourceToRepresentationDropBehaviorProvider(IExternalSourceToRepresentationDropBehaviorProvider externalSourceToRepresentationDropBehaviorProvider) {
            this.externalSourceToRepresentationDropBehaviorProvider = Objects.requireNonNull(externalSourceToRepresentationDropBehaviorProvider);
            return this;
        }

        public Builder externalSourceToRepresentationDropChecker(IExternalSourceToRepresentationDropChecker externalSourceToRepresentationDropChecker) {
            this.externalSourceToRepresentationDropChecker = Objects.requireNonNull(externalSourceToRepresentationDropChecker);
            return this;
        }

        public Builder internalSourceToRepresentationDropBehaviorProvider(IInternalSourceToRepresentationDropBehaviorProvider internalSourceToRepresentationDropBehaviorProvider) {
            this.internalSourceToRepresentationDropBehaviorProvider = Objects.requireNonNull(internalSourceToRepresentationDropBehaviorProvider);
            return this;
        }

        public Builder internalSourceToRepresentationDropChecker(IInternalSourceToRepresentationDropChecker internalSourceToRepresentationDropChecker) {
            this.internalSourceToRepresentationDropChecker = Objects.requireNonNull(internalSourceToRepresentationDropChecker);
            return this;
        }

        public CommonDropBehaviorProvider build() {
            return new CommonDropBehaviorProvider(this);
        }
    }

    class DropSemanticSwitch
    extends UMLSwitch<Status> {
        private final DSemanticDecorator targetView;
        private final String targetViewExpression;
        private final boolean isDiagramWithRoot;

        DropSemanticSwitch(DSemanticDecorator targetView, String targetViewExpression, boolean isDiagramWithRoot) {
            this.targetView = targetView;
            this.targetViewExpression = targetViewExpression;
            this.isDiagramWithRoot = isDiagramWithRoot;
        }

        public Status caseElement(Element droppedElement) {
            CommonDropBehaviorProvider.this.createView((EObject)droppedElement, this.targetView, this.targetViewExpression);
            return Status.createOKStatus((EObject)droppedElement);
        }

        public Status caseElementImport(ElementImport elementImport) {
            PackageableElement importedElement = elementImport.getImportedElement();
            CommonDropBehaviorProvider.this.createView((EObject)importedElement, this.targetView, this.targetViewExpression);
            return Status.createOKStatus((EObject)importedElement);
        }

        public Status caseRelationship(Relationship relationship) {
            return this.createEdgeView((EObject)relationship, this.isDiagramWithRoot);
        }

        public Status caseActivityEdge(ActivityEdge activityEdge) {
            return this.createEdgeView((EObject)activityEdge, this.isDiagramWithRoot);
        }

        private Status createEdgeView(EObject semanticElement, boolean isDiagramWithRoot) {
            Session session = new EObjectQuery(semanticElement).getSession();
            Optional<DDiagram> optionalDiagram = this.retrieveDDiagram();
            if (session != null && optionalDiagram.isPresent()) {
                CommonDropBehaviorProvider.this.createDnDEdgeView(semanticElement, optionalDiagram.get(), session, isDiagramWithRoot);
                return Status.createOKStatus((EObject)semanticElement);
            }
            return new Status(State.FAILED, "Cannot retrieve the session or the DDiagram");
        }

        public Status caseConnector(Connector connector) {
            return this.createEdgeView((EObject)connector, this.isDiagramWithRoot);
        }

        public Status caseMessage(Message message) {
            return this.createEdgeView((EObject)message, this.isDiagramWithRoot);
        }

        private Optional<DDiagram> retrieveDDiagram() {
            Optional<DDiagram> optionalDiagram = Optional.empty();
            if (this.targetView instanceof DDiagram) {
                optionalDiagram = Optional.of((DDiagram)this.targetView);
            } else if (this.targetView instanceof DDiagramElement) {
                optionalDiagram = Optional.ofNullable(((DDiagramElement)this.targetView).getParentDiagram());
            }
            return optionalDiagram;
        }
    }
}

