/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RectangularShadowBorder;
import org.eclipse.swt.graphics.Color;

public class RoundedShadowBorder
extends RectangularShadowBorder {
    int borderwidth = 3;
    int arcwidth = 20;

    public RoundedShadowBorder(Color color) {
        super(3, color);
        this.setWidth(1);
    }

    public Insets getInsets(IFigure figure) {
        Insets insetsNew = super.getInsets(figure);
        insetsNew.top = 0;
        insetsNew.left = 0;
        insetsNew.bottom = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(insetsNew.bottom + this.borderwidth);
        insetsNew.right = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(insetsNew.right + this.borderwidth);
        return insetsNew;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(RoundedShadowBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (this.getWidth() % 2 != 0) {
            --RoundedShadowBorder.tempRect.width;
            --RoundedShadowBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2 + 1, this.getWidth() / 2 + 1).translate(-1, -1);
        graphics.setLineWidth(this.getWidth());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        graphics.drawRoundRectangle(tempRect, this.arcwidth, this.arcwidth);
        graphics.setBackgroundColor(this.getColor());
        graphics.drawArc(RoundedShadowBorder.tempRect.x + RoundedShadowBorder.tempRect.width - this.arcwidth + this.borderwidth, RoundedShadowBorder.tempRect.y + this.borderwidth, this.arcwidth - 1, this.arcwidth - 1, 0, 40);
        graphics.drawArc(RoundedShadowBorder.tempRect.x + RoundedShadowBorder.tempRect.width - this.arcwidth + this.borderwidth, RoundedShadowBorder.tempRect.y + this.borderwidth + RoundedShadowBorder.tempRect.height - this.arcwidth, this.arcwidth - 1, this.arcwidth - 1, 270, 90);
        graphics.drawArc(RoundedShadowBorder.tempRect.x + RoundedShadowBorder.tempRect.width - this.arcwidth + this.borderwidth, RoundedShadowBorder.tempRect.y + this.borderwidth + RoundedShadowBorder.tempRect.height - this.arcwidth, this.arcwidth - 2, this.arcwidth - 2, 270, 90);
        graphics.drawArc(RoundedShadowBorder.tempRect.x + RoundedShadowBorder.tempRect.width - this.arcwidth + this.borderwidth, RoundedShadowBorder.tempRect.y + this.borderwidth + RoundedShadowBorder.tempRect.height - this.arcwidth, this.arcwidth - 3, this.arcwidth - 3, 270, 90);
        graphics.drawArc(RoundedShadowBorder.tempRect.x + this.borderwidth, RoundedShadowBorder.tempRect.y + this.borderwidth + RoundedShadowBorder.tempRect.height - this.arcwidth, this.arcwidth - 1, this.arcwidth - 1, 230, 40);
        graphics.fillRectangle(RoundedShadowBorder.tempRect.x + RoundedShadowBorder.tempRect.width + 1, RoundedShadowBorder.tempRect.y + this.arcwidth - 2 * this.borderwidth - 4, this.borderwidth, RoundedShadowBorder.tempRect.height - this.arcwidth + this.borderwidth);
        graphics.fillRectangle(RoundedShadowBorder.tempRect.x + this.arcwidth - 2 * this.borderwidth - 4, RoundedShadowBorder.tempRect.y + RoundedShadowBorder.tempRect.height + 1, RoundedShadowBorder.tempRect.width - this.arcwidth + this.borderwidth, this.borderwidth);
    }
}

