/**
 * Copyright (c) 2021 Christian W. Damus, CEA LIST, and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Christian W. Damus - Initial API and implementation
 */
package org.eclipse.papyrus.uml.types.core.matchers.stereotype;

import org.eclipse.papyrus.infra.emf.types.constraints.AdviceConstraint;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Required Stereotype Constraint Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A constraint that rejects any edit request
 * that would unapply any of the type's matched
 * stereotypes.
 * <!-- end-model-doc -->
 *
 *
 * @see org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcherPackage#getRequiredStereotypeConstraintConfiguration()
 * @model annotation="duplicates"
 * @generated
 */
public interface RequiredStereotypeConstraintConfiguration extends AdviceConstraint {
} // RequiredStereotypeConstraintConfiguration
