/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;

public class ShallowMarker
implements IMarker {
    private final String myType;
    private final Map<String, Object> myAttributes;
    private final long myCreationTime;

    public ShallowMarker(String type) {
        this.myType = type;
        this.myAttributes = new HashMap<String, Object>();
        this.myCreationTime = System.currentTimeMillis();
    }

    public void delete() {
    }

    public boolean exists() {
        return true;
    }

    public Object getAttribute(String attributeName) {
        return this.myAttributes.get(attributeName);
    }

    public int getAttribute(String attributeName, int defaultValue) {
        Object attr = this.getAttribute(attributeName);
        if (!(attr instanceof Integer)) {
            return defaultValue;
        }
        return (Integer)attr;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        Object attr = this.getAttribute(attributeName);
        if (!(attr instanceof String)) {
            return defaultValue;
        }
        return (String)attr;
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        Object attr = this.getAttribute(attributeName);
        if (!(attr instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)attr;
    }

    public Map getAttributes() {
        return this.myAttributes;
    }

    public Object[] getAttributes(String[] attributeNames) {
        ArrayList<Object> attributes = new ArrayList<Object>();
        int i = 0;
        while (i < attributeNames.length) {
            String attributeName = attributeNames[i];
            attributes.add(this.getAttribute(attributeName));
            ++i;
        }
        return attributes.toArray();
    }

    public long getCreationTime() {
        return this.myCreationTime;
    }

    public long getId() {
        return this.myCreationTime;
    }

    public IResource getResource() {
        return null;
    }

    public String getType() {
        return this.myType;
    }

    public boolean isSubtypeOf(String superType) {
        return false;
    }

    public void setAttribute(String attributeName, int value) {
        this.myAttributes.put(attributeName, new Integer(value));
    }

    public void setAttribute(String attributeName, Object value) {
        this.myAttributes.put(attributeName, value);
    }

    public void setAttribute(String attributeName, boolean value) {
        this.myAttributes.put(attributeName, value);
    }

    public void setAttributes(String[] attributeNames, Object[] values) {
        int i = 0;
        while (i < attributeNames.length) {
            String attributeName = attributeNames[i];
            Object value = values[i];
            this.setAttribute(attributeName, value);
            ++i;
        }
    }

    public void setAttributes(Map attributes) {
        this.myAttributes.clear();
        this.myAttributes.putAll(attributes);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

