/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverUtils {
    private ResolverUtils() {
    }

    public static String getNamespace(IPath namespacePath, IPath srcContainerPath) {
        if (namespacePath == null || srcContainerPath == null) {
            throw new IllegalArgumentException();
        }
        if (namespacePath.equals((Object)srcContainerPath)) {
            return null;
        }
        int srcContainerDepth = srcContainerPath.segmentCount();
        IPath srcRelativePath = namespacePath.removeFirstSegments(srcContainerDepth);
        return ResolverUtils.getNamespace(srcRelativePath);
    }

    public static String getNamespace(IPath srcRelativePath) {
        StringBuilder buf = new StringBuilder();
        String[] segments = srcRelativePath.segments();
        int i = 0;
        while (i < segments.length) {
            if (i > 0) {
                buf.append('.');
            }
            buf.append(segments[i]);
            ++i;
        }
        return buf.toString();
    }

    public static List<UnitProxy> findAllUnits(UnitProvider unitProvider) {
        final ArrayList<UnitProxy> result = new ArrayList<UnitProxy>();
        UnitProvider.UnitVisitor visitor = new UnitProvider.UnitVisitor(){

            public boolean visitUnit(UnitProxy unit) {
                result.add(unit);
                return true;
            }
        };
        unitProvider.accept(visitor, null, 2, true);
        return result;
    }

    public static String toQualifiedName(IPath path) {
        return path.toString().replace('/', '.');
    }

    public static String toQualifiedName(String[] nameSegments, int startPos, int endPos) {
        int len = nameSegments.length;
        if (startPos > endPos || startPos < 0 || startPos >= len || endPos < 0 || endPos >= len) {
            throw new ArrayIndexOutOfBoundsException("name segment position");
        }
        StringBuilder buf = new StringBuilder();
        int i = startPos;
        while (i <= endPos) {
            if (i > startPos) {
                buf.append('.');
            }
            buf.append(nameSegments[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String[] getNameSegments(String qualifiedName) {
        return qualifiedName.split("\\.");
    }

    public static UnitProxy createUnitProxy(String qualifiedName, URI uri, final String contents, final UnitResolver resolver) {
        String[] segments = ResolverUtils.getNameSegments(qualifiedName);
        String namespace = null;
        if (segments.length > 1) {
            namespace = ResolverUtils.toQualifiedName(segments, 0, segments.length - 2);
        }
        String name = segments[segments.length - 1];
        return new UnitProxy(namespace, name, uri){

            public UnitContents getContents() throws IOException {
                return ResolverUtils.createCSTContents(contents);
            }

            public int getContentType() {
                return 0;
            }

            public UnitResolver getResolver() {
                return resolver;
            }
        };
    }

    public static IPath toNamespaceRelativePath(String qualifiedName) {
        String path = qualifiedName.replace('.', '/');
        return new Path(path);
    }

    public static UnitContents.CSTContents createCSTContents(final String input) {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        return new UnitContents.CSTContents(){

            public Reader getContents() throws IOException {
                return new StringReader(input);
            }
        };
    }
}

