/**
* Essential OCL Grammar
* <copyright>
*
* Copyright (c) 2005, 2010 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Elimination of some shift-reduce conflicts
*   E.D.Willink - Remove unnecessary warning suppression
*   E.D.Willink - Bugs 184048, 225493, 243976, 259818, 282882, 287993, 288040, 292112, 295166
*   Borland - Bug 242880
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias):
*        - 242153: LPG v 2.0.17 adoption.
*        - 299396: Introducing new LPG templates
*        - 300534: Removing the use of deprecated macros.
* </copyright>
*
* $Id: EssentialOCL.gi,v 1.5 2010/02/11 15:40:41 sboyko Exp $
*/
/**
* <copyright>
*
* Copyright (c) 2006, 2013 Borland Inc.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   Borland - Initial API and implementation
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - LPG v 2.0.17 adoption (297966)
*   Alex Paperno - bugs 314443, 274105, 274505, 419299 
*
* </copyright>
*
*/
/**
* <copyright>
*
* Copyright (c) 2006, 2013 Borland Inc.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   Borland - Initial API and implementation
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - LPG v 2.0.17 adoption (297966)
*   Alex Paperno - bugs 392429, 419299 
*
* </copyright>
*
*/

package org.eclipse.m2m.internal.qvt.oml.cst.parser;

public class QVTOParserprs implements lpg.runtime.ParseTable, QVTOParsersym {
    public final static int ERROR_SYMBOL = 2;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 132;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 133;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 39;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 643;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 163;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 14400;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 2;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 837;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 344;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 507;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 3216;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 3;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 126;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 126;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 13547;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 13563;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = true;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return QVTOParsersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,1,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            1,0,0,0,0,0,0,0,0,0,
            1,0,0,0,0,0,0,0,0,0,
            0,0,0,0,1,0,0,0,0,0,
            0,0,0,0,0,0,0,0,1,0,
            0,0,0,0,0,0,0,1,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,1,0,0,0,0,0,0,0,
            1,0,0,0,1,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,1,0,0,0,1,0,0,0,0,
            0,0,0,0,0,0,1,0,0,0,
            0,1,0,1,0,0,0,0,1,1,
            0,1,0,0,0,0,1,1,0,0,
            0,1,0,0,1,0,0,0,1,0,
            1,0,0,1,0,0,0,1,0,0,
            1,1,0,0,0,1,0,0,1,0,
            1,0,1,0,0,0,0,0,0,0,
            1,1,1,0,0,0,0,0,0,0,
            0,0,0,0,0,0,1,0,0,1,
            1,0,0,1,1,0,1,0,0,1,
            1,1,1,0,0,0,1,1,1,1,
            1,1,0,0,0,0,0,0,1,1,
            1,0,0,0,1,1,0,0,0,0,
            1,1,0,0,0,0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static char prosthesesIndex[] = {0,
            12,13,9,10,15,17,18,39,37,41,
            32,38,40,42,43,330,331,333,334,11,
            29,30,31,46,47,48,49,50,51,52,
            53,54,59,60,61,89,90,91,93,95,
            97,103,104,122,179,180,198,209,211,212,
            322,324,86,88,102,83,84,85,80,81,
            82,190,113,117,120,148,193,77,78,79,
            74,75,76,71,72,73,68,69,70,65,
            66,67,24,55,62,63,64,108,94,96,
            16,173,175,176,177,178,170,171,172,167,
            168,169,56,164,165,166,269,58,161,162,
            163,158,159,160,155,156,157,214,21,152,
            153,154,136,145,146,147,149,150,151,22,
            27,57,284,343,344,25,138,143,247,118,
            137,144,210,233,23,140,87,131,142,223,
            248,253,254,255,306,342,6,8,14,26,
            35,36,112,114,115,121,123,128,139,141,
            174,227,228,229,230,231,232,241,267,268,
            273,274,285,286,287,288,289,292,293,294,
            295,296,297,299,300,301,303,341,33,34,
            99,100,107,110,116,119,135,181,183,184,
            187,188,205,206,213,216,217,221,237,245,
            256,257,258,260,266,270,271,272,276,290,
            291,321,323,326,327,328,337,339,2,3,
            4,19,20,44,92,98,101,105,106,109,
            111,124,125,126,127,129,130,132,133,134,
            182,185,186,189,191,192,194,195,196,197,
            199,200,201,202,203,204,207,208,215,218,
            219,220,222,224,225,226,234,235,236,238,
            239,240,242,243,244,246,249,250,251,252,
            259,261,262,263,264,265,275,277,278,279,
            280,281,282,283,298,302,304,305,307,308,
            309,310,311,312,313,314,315,316,317,318,
            319,320,325,329,332,335,336,338,340,1,
            5,7,28,45
        };
    };
    public final static char prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,1,1,0,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,0,1,1,0,0,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,0,1,1,1,1,1,1,
            1,1,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,1,1,1,1,1,1,1,0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,0,0,0,0,0,1,1,
            1,1,1,1,1,0,0,0,0,0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,0,0,1,1,1,1,1,1,
            1,1,1
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck0 {
        public final static short baseCheck0[] = {0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,2,1,1,1,
            3,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,4,4,
            0,1,1,3,1,3,3,5,1,1,
            1,1,1,1,1,1,1,1,1,4,
            0,1,1,3,1,1,3,1,1,1,
            1,1,1,1,4,1,3,1,1,1,
            2,1,1,1,1,1,1,1,1,1,
            1,1,1,8,10,10,8,10,1,1,
            1,5,6,8,8,7,7,5,6,9,
            1,4,6,4,0,0,1,1,3,1,
            1,1,1,1,1,1,1,1,3,1,
            3,1,1,1,3,1,3,1,1,1,
            3,1,3,1,1,1,3,1,3,1,
            1,1,3,3,1,3,3,1,1,1,
            3,3,3,3,1,3,3,3,3,1,
            1,1,3,3,1,3,3,1,1,1,
            3,3,1,3,3,1,1,1,2,2,
            1,2,2,1,1,1,1,1,1,3,
            4,1,3,1,1,1,1,1,4,4,
            1,6,4,1,1,1,3,1,0,1,
            3,2,1,1,3,2,1,0,3,3,
            1,2,5,7,1,0,1,2,1,0,
            1,2,4,4,1,2,4,4,2,3,
            3,5,5,3,3,3,3,1,1,1,
            1,3,3,3,3,1,7,7,5,3,
            5,1,3,1,1,1,3,0,2,2,
            6,2,1,1,1,1,1,1,0,2,
            0,1,4,1,2,2,7,6,4,2,
            5,6,7,8,9,3,6,7,6,7,
            1,5,1,2,0,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,3,1,3,1,1,1,
            3,1,3,1,1,1,3,1,3,1,
            1,1,3,1,3,1,1,1,3,3,
            1,3,3,1,1,1,3,3,3,3,
            1,3,3,3,3,1,1,1,3,3,
            1,3,3,1,1,1,3,3,1,3,
            3,1,1,1,2,1,2,1,1,1,
            1,3,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,2,1,
            2,1,1,3,8,7,2,4,4,2,
            1,2,5,5,0,1,2,2,1,1,
            2,1,0,5,1,1,1,0,2,1,
            0,6,5,1,3,1,1,1,1,1,
            1,1,1,4,4,2,1,3,5,5,
            1,3,0,1,2,0,1,6,3,1,
            5,1,1,1,1,1,1,3,5,5,
            3,1,0,0,1,2,1,1,3,2,
            3,2,2,2,1,6,4,2,4,4,
            1,1,3,1,2,1,2,0,1,1,
            1,1,1,1,1,1,1,2,1,1,
            1,2,5,1,1,2,5,5,0,1,
            1,1,1,2,4,1,2,0,1,1,
            1,2,0,1,1,1,3,3,0,1,
            1,1,1,3,2,2,2,0,1,1,
            1,1,1,1,2,1,7,1,2,0,
            1,2,1,3,2,1,4,1,0,1,
            1,1,8,7,0,2,1,3,2,0,
            2,1,3,2,9,1,0,2,0,3,
            1,3,2,0,2,2,1,1,1,1,
            1,0,3,1,1,3,3,3,3,1,
            0,0,4,1,0,6,6,7,5,5,
            6,8,1,1,1,3,2,2,1,1,
            2,2,4,3,1,1,4,2,2,3,
            1,1,2,2,2,3,4,0,2,1,
            1,2,5,3,3,6,5,3,2,0,
            1,2,1,1,1,1,0,2,2,1,
            0,2,2,3,0,1,2,2,0,1,
            1,2,2,0,1,2,2,0,1,1,
            1,1,1,3,3,3,5,5,7,7,
            5,5,0,2,2,0,2,0,1,3,
            1,1,1,1,0,1,5,5,3,2,
            1,1,1,1,7,5,7,5,4,3,
            1,1,3,3,1,3,3,1,1,1,
            1,1,3,4,4,3,3,4,3,1,
            7,0,2,1,1,1,0,2,2,0,
            1,3,0,1,3,3,1,1,4,2,
            0,1,1,1,1,1,3,1,1,1,
            1,1,3,3,1,1,1,3,3,1,
            3,2,1,3,3,2,1,-365,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            -64,1,2,3,4,-307,1,2,-232,62,
            63,64,65,66,67,-89,1,2,-360,-227,
            5,-166,1,2,3,4,8,9,10,11,
            12,13,14,15,-2,88,-256,1,2,92,
            93,94,95,96,97,98,99,100,101,102,
            -65,104,105,106,-4,-8,109,110,111,112,
            113,114,115,116,117,-46,-15,120,121,122,
            123,124,125,126,127,128,129,-519,1,2,
            -643,-90,1,2,137,138,5,-17,141,-612,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,-349,1,2,3,4,-257,1,2,
            145,62,63,64,65,66,67,157,158,159,
            152,153,154,-20,-337,-22,-75,1,2,-121,
            -326,152,153,154,-304,1,2,88,157,158,
            159,92,93,94,95,96,97,98,99,100,
            101,102,-24,104,105,106,119,-25,109,110,
            111,112,113,114,115,116,117,130,131,120,
            121,122,123,124,125,126,127,128,129,201,
            202,-364,142,-10,55,55,137,138,220,149,
            141,-627,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,-395,1,2,118,118,5,
            213,226,8,62,63,64,65,66,67,157,
            158,159,294,295,296,-92,-434,-336,1,2,
            136,88,5,-354,1,2,152,153,154,88,
            -325,1,2,92,93,94,95,96,97,98,
            99,100,101,102,-435,104,105,106,-26,-7,
            109,110,111,112,113,114,115,116,117,-402,
            -27,120,121,122,123,124,125,126,127,128,
            129,55,-99,1,2,315,-335,5,137,138,
            8,-96,141,-634,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,-283,107,207,-171,
            1,2,119,267,268,62,63,64,65,66,
            67,-172,-28,130,131,16,17,18,19,8,
            9,10,11,12,13,14,15,-215,151,88,
            -29,88,-279,179,-30,92,93,94,95,96,
            97,98,99,100,101,102,142,104,105,106,
            259,260,109,110,111,112,113,114,115,116,
            117,-220,-21,120,121,122,123,124,125,126,
            127,128,129,169,-56,1,2,-225,-40,225,
            137,138,55,207,141,-37,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-249,1,2,3,4,5,6,
            7,107,155,156,-629,-5,1,2,3,4,
            5,6,7,-60,1,2,3,4,5,6,
            7,311,-190,-6,-81,144,-330,211,123,334,
            335,8,201,202,-61,1,2,3,4,5,
            6,7,-58,-188,150,198,317,-134,55,-170,
            1,2,233,324,5,-411,1,2,-404,320,
            321,322,181,182,-230,16,17,18,19,164,
            165,252,253,-139,-41,319,-187,246,247,263,
            264,55,89,90,91,238,234,235,236,-122,
            271,272,273,274,89,90,91,55,55,-507,
            1,2,89,90,91,-413,1,2,227,228,
            -36,-164,218,231,-38,-62,1,2,221,237,
            223,216,217,89,90,91,-32,-154,55,-68,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,279,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,144,-88,1,
            2,3,4,5,6,7,204,-44,118,-509,
            1,2,118,-12,119,136,3,4,214,6,
            7,-11,-495,167,-57,172,173,174,175,176,
            177,178,123,180,211,-34,183,184,185,186,
            187,188,189,190,191,192,193,194,195,196,
            197,-67,250,226,-132,1,2,3,4,5,
            6,7,233,-574,-290,209,-50,-18,55,240,
            241,215,-52,164,165,231,55,224,-493,1,
            2,237,-340,5,62,262,-615,89,90,91,
            55,-516,1,2,-216,9,10,206,314,-14,
            1,2,89,90,-237,1,2,269,270,88,
            304,-191,306,-71,1,2,3,4,5,6,
            7,55,55,-70,-72,216,217,55,119,-63,
            1,2,3,4,5,6,7,242,243,130,
            131,143,-474,89,90,91,133,134,135,-523,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,89,90,91,139,107,338,210,146,
            119,62,63,64,65,66,67,163,89,90,
            91,130,131,119,318,-626,-252,155,156,151,
            232,325,-42,170,140,328,327,88,331,330,
            -356,92,93,94,95,96,97,98,99,100,
            101,102,-73,104,105,106,143,-153,109,110,
            111,112,113,114,115,116,117,-425,204,120,
            121,122,123,124,125,126,127,128,129,-505,
            1,2,3,4,5,6,7,-16,1,2,
            141,-575,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,-224,1,2,265,266,5,
            118,316,8,62,63,64,65,66,67,248,
            249,326,-161,297,329,-74,300,142,89,90,
            91,146,305,-78,149,118,234,235,236,88,
            -45,1,2,92,93,94,95,96,97,98,
            99,100,101,102,107,104,105,106,-79,313,
            109,110,111,112,113,114,115,116,117,-226,
            -524,120,121,122,123,124,125,126,127,128,
            129,-343,143,-93,1,2,3,4,5,6,
            7,-202,141,-619,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,-76,107,-138,210,
            -141,-621,-400,-49,254,62,63,64,65,66,
            67,8,140,277,278,132,-246,-324,-431,-142,
            -610,232,89,90,91,-228,-398,-80,-48,1,
            2,88,255,179,8,92,93,94,95,96,
            97,98,99,100,101,102,-39,104,105,106,
            -380,55,109,110,111,112,113,114,115,116,
            117,-82,142,120,121,122,146,124,125,126,
            127,128,129,55,55,-51,143,205,-55,225,
            137,138,-640,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,107,140,206,88,139,
            221,139,223,118,62,63,64,65,66,67,
            152,153,154,-247,-630,214,140,303,139,-620,
            -9,-233,-126,9,10,-83,146,-59,1,2,
            88,-489,1,2,92,93,94,95,96,97,
            98,99,100,101,102,139,104,105,106,-551,
            170,109,110,111,112,113,114,115,116,117,
            -84,205,120,121,122,179,124,125,126,127,
            128,129,-98,-85,-86,55,166,55,220,137,
            138,-642,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,107,257,230,88,107,118,
            -631,-475,-614,62,63,64,65,66,67,9,
            10,-94,-628,140,219,-97,298,219,-234,139,
            88,142,140,301,-392,302,8,-101,149,88,
            309,-635,293,92,93,94,95,96,97,98,
            99,100,101,102,307,104,105,106,169,-251,
            109,110,111,112,113,114,115,116,117,-253,
            -102,120,121,122,-255,124,125,126,127,128,
            129,-637,1,2,-103,166,-409,-389,137,138,
            -355,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,144,-363,
            1,2,-517,1,2,-424,-641,146,107,-430,
            -432,132,-333,1,2,-104,-105,5,-478,-568,
            -106,132,-115,1,2,118,132,-491,-107,119,
            -108,170,-109,-110,-111,181,182,-112,132,-116,
            130,131,-117,-118,-600,-119,136,-511,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,136,118,132,136,-639,
            308,132,-120,-125,145,118,-130,145,142,-131,
            103,132,310,-503,-133,149,-135,-136,136,160,
            -144,-145,160,151,333,-146,119,145,-147,-148,
            -149,-150,-151,-156,-157,169,-160,130,131,-173,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,222,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,245,258,-552,
            -162,-373,-397,229,-194,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,-163,
            56,57,58,59,60,61,-165,-167,-176,-179,
            161,162,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,88,336,88,
            88,208,-180,-181,-182,-183,-186,-192,229,-193,
            -201,-203,-204,-205,-217,-218,-223,-229,199,200,
            -175,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,166,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-553,-560,
            -570,-613,-239,-241,-242,-213,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            -254,56,57,58,59,60,61,-258,-259,-260,
            -263,161,162,68,69,70,71,72,73,74,
            75,76,77,78,79,-1,88,88,88,88,
            -264,-265,-266,-268,-269,-270,-271,-272,-274,-281,
            -282,-285,-286,-287,-288,-289,-291,-293,-294,199,
            200,-273,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            -295,-296,-297,-298,-299,-300,-54,1,2,-301,
            -302,-303,-310,-311,-312,-313,-314,-315,-316,-317,
            -318,-319,-323,-328,-358,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,168,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,-331,107,-332,-338,-339,-342,-344,-347,
            -348,-350,-351,-352,239,-366,-367,-370,-372,-378,
            -384,-385,-386,-334,1,2,-387,-388,5,-394,
            -396,-406,-407,119,-415,-416,-417,-418,-419,-420,
            -421,-422,-423,-426,130,131,150,-427,-428,-429,
            -436,-437,-438,-439,-440,280,-441,256,-159,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,-442,-443,-444,-445,
            -446,-447,-448,-449,-451,-452,-453,-454,-455,-456,
            -457,103,-458,-459,-460,-461,108,-462,-463,-464,
            -465,-467,-468,-469,151,-470,-471,-472,-476,-479,
            -481,-482,-483,-484,-485,-488,-490,-492,-496,275,
            -214,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,222,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-91,-123,
            -124,-184,-185,-221,-244,-245,-261,-262,-267,-320,
            -322,-368,-369,-376,-391,-399,-401,-480,-486,-497,
            -498,-499,-500,-501,-502,-513,-514,-520,-522,-525,
            -526,-533,-544,123,-561,-562,-563,-564,-565,-566,
            -567,-569,-571,-572,-577,-578,-579,-580,-581,-582,
            -583,-584,-585,55,55,55,55,55,55,55,
            55,55,55,55,55,55,55,55,55,55,
            55,55,55,55,164,165,-250,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,-586,-587,-588,-589,-590,-591,
            -592,-593,-594,-595,-596,-597,-598,-602,-603,103,
            -604,-611,-616,-617,108,-276,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-618,-622,-623,-625,-633,-638,0,
            0,0,0,0,0,0,0,0,103,0,
            0,0,0,108,-277,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,103,0,0,
            0,0,108,-280,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,103,0,0,0,
            0,108,-345,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,103,0,0,0,0,
            108,-377,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            -408,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,103,0,0,0,0,108,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,212,-410,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,103,0,0,
            0,0,108,-412,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,103,0,0,0,
            0,108,-414,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,103,0,0,0,0,
            108,-550,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            -557,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,103,0,0,0,0,108,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,212,-558,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,103,0,0,
            0,0,108,-559,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,103,0,0,0,
            0,108,-87,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            -199,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,0,56,57,58,0,
            148,-127,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,0,
            0,0,0,0,-362,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,148,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,-196,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,0,56,57,
            58,59,60,61,0,0,0,0,0,0,
            68,69,70,0,0,161,162,-473,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,-200,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            0,56,57,58,0,148,-510,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,103,
            -521,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,-543,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            55,0,0,-573,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,168,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,88,-195,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,0,56,57,
            58,59,60,61,0,0,0,0,0,0,
            68,69,70,71,72,73,74,75,76,0,
            0,168,-624,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            0,0,0,0,0,-77,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            148,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-168,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,203,-169,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,-189,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,0,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,-212,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            0,56,57,58,59,60,61,0,0,0,
            0,0,0,68,69,70,71,72,73,0,
            0,0,0,0,167,-248,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-284,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,-292,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,0,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,-306,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,203,-341,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-405,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,-515,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,-545,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,-43,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,0,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,-100,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            0,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-128,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,0,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,-152,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,0,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,-177,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,0,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,-243,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,0,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,-305,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            0,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-309,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37
        };
    };

    public interface BaseCheck1 {
        public final static short baseCheck1[] = {
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,0,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            -321,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,0,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-346,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,0,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,-359,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,0,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,-361,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,0,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,-374,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,0,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            -379,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,0,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-381,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,0,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,-382,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,0,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,-393,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,0,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,-403,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,0,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            -433,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,0,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-450,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,0,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,-477,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,0,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,-487,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,0,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,-504,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,0,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            -506,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,0,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-508,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,0,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,-518,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,0,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,-542,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,0,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,-546,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,0,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            -547,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,0,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-549,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,0,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,-576,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,0,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,-605,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,0,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,-606,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,0,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            -607,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,0,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-608,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,0,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,-609,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,0,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,-632,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,0,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,-636,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,0,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            -527,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,-174,1,2,0,0,0,0,
            0,0,0,-548,-556,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,92,93,94,95,96,97,98,99,
            100,101,102,0,104,105,106,0,0,109,
            110,111,112,113,114,115,116,117,55,55,
            120,121,122,-541,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,-599,0,0,0,
            0,0,0,0,0,0,0,0,0,136,
            0,0,0,0,0,0,0,0,145,0,
            0,0,0,0,0,-275,1,2,3,4,
            5,6,7,160,0,92,93,94,95,96,
            97,98,99,100,101,102,0,104,105,106,
            0,55,109,110,111,112,113,114,115,116,
            117,-528,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,89,90,91,244,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -240,1,2,3,4,5,6,7,0,0,
            0,0,0,92,93,94,95,96,97,98,
            99,100,101,102,0,104,105,106,143,0,
            109,110,111,112,113,114,-540,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,89,
            90,91,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-129,1,2,3,4,5,6,7,
            -219,1,2,3,4,5,6,7,92,93,
            94,95,96,97,98,99,100,101,102,0,
            104,105,106,143,0,109,110,111,-529,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,89,90,91,0,0,0,0,0,89,
            90,91,0,0,0,0,0,332,0,-222,
            1,2,3,4,5,6,7,-235,1,2,
            3,4,5,6,7,0,0,0,0,0,
            92,93,94,95,96,97,98,99,100,101,
            102,0,104,105,106,-530,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,89,90,
            91,0,0,0,0,0,89,90,91,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-383,1,2,3,4,
            5,6,7,0,0,0,0,92,93,94,
            95,96,97,98,99,100,101,102,0,104,
            105,106,-197,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,0,56,57,
            58,59,60,61,89,90,91,0,0,0,
            68,69,70,-198,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,0,56,
            57,58,59,60,61,0,0,0,163,0,
            0,68,69,70,-536,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-236,1,2,3,4,5,6,7,0,
            0,0,0,0,0,0,251,-308,1,2,
            3,4,5,6,7,0,92,93,94,95,
            96,97,98,99,100,101,102,-537,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            89,90,91,0,0,0,0,0,0,0,
            0,0,0,0,0,0,89,90,91,-327,
            1,2,3,4,5,6,7,-371,1,2,
            3,4,5,6,7,0,0,0,0,92,
            93,94,95,96,97,98,99,100,101,102,
            -538,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,0,0,0,0,0,89,90,
            91,0,0,0,0,0,89,90,91,-375,
            1,2,3,4,5,6,7,-512,1,2,
            3,4,5,6,7,0,0,0,0,0,
            0,0,92,93,94,95,96,97,98,99,
            100,101,102,-539,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,0,0,89,90,
            91,0,0,0,0,0,89,90,91,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,92,93,94,95,96,
            97,98,99,100,101,102,-208,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,0,56,57,58,59,60,61,-209,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,0,56,57,58,59,60,61,
            -210,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,0,56,57,58,59,
            60,61,-211,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,0,56,57,
            58,59,60,61,-531,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,0,0,0,
            0,0,0,0,0,0,0,0,-555,1,
            2,3,4,5,6,7,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,92,93,94,95,
            96,97,98,99,-532,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,89,90,91,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,92,93,94,95,
            96,97,98,99,-466,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-554,1,
            2,3,4,5,6,7,92,93,94,95,
            96,-534,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,-357,1,2,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,171,0,89,90,91,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,92,93,94,95,96,-535,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,163,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,171,119,0,0,0,0,0,0,
            0,0,0,0,130,131,0,0,0,0,
            92,93,94,95,96,-113,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,213,0,171,
            -114,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,0,0,0,0,0,
            276,0,-329,0,0,0,0,0,0,0,
            0,0,147,-206,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,-494,0,
            0,3,4,-31,6,7,3,4,-47,6,
            7,3,4,0,6,7,0,147,-207,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,-3,-278,0,144,3,4,-53,
            6,7,3,4,-231,6,7,89,90,0,
            147,-13,89,90,-23,1,2,89,90,-143,
            -140,-95,0,3,4,-601,6,7,3,4,
            0,6,7,181,182,-390,1,2,-137,1,
            2,0,-33,-66,0,0,0,-69,55,55,
            -155,133,134,135,-353,0,133,134,135,55,
            0,133,134,135,-35,0,55,-158,-178,55,
            0,0,0,0,55,0,55,0,0,227,
            228,0,0,89,90,147,-238,0,89,90,
            55,0,0,55,-19,1,2,55,55,88,
            0,0,55,0,0,55,0,0,0,89,
            90,0,0,0,89,90,0,0,0,55,
            0,107,55,55,0,0,0,133,134,135,
            88,88,133,134,135,88,0,144,88,0,
            0,55,107,139,0,107,0,0,0,55,
            0,0,0,133,134,135,88,0,133,134,
            135,0,0,144,150,172,173,174,175,176,
            177,178,0,180,88,0,183,184,185,186,
            187,188,189,190,191,192,193,194,195,196,
            197,172,173,174,175,176,177,178,0,180,
            0,107,183,184,185,186,187,188,189,190,
            191,192,193,194,195,196,197,0,0,155,
            156,167,155,156,0,0,0,0,0,208,
            0,0,218,0,230,0,0,0,0,0,
            0,323,0,224,150,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,198,209,0,198,0,0,0,215,
            0,0,0,0,281,282,0,284,285,286,
            287,288,289,290,291,292,0,0,0,0,
            0,0,0,0,0,0,0,283,0,0,
            0,0,238,0,0,0,0,0,0,0,
            0,0,0,0,0,261,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            337,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,312,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,299,0,0,0,0,0,0,
            0,0,0,339,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0
        };
    };

    public final static short baseCheck[] = new short[BaseCheck0.baseCheck0.length + BaseCheck1.baseCheck1.length];
    {
        int index = 0;
        System.arraycopy(BaseCheck0.baseCheck0, 0, baseCheck, index, BaseCheck0.baseCheck0.length);
        index += BaseCheck0.baseCheck0.length;
        System.arraycopy(BaseCheck1.baseCheck1, 0, baseCheck, index, BaseCheck1.baseCheck1.length);
    };
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction0 {
        public final static char baseAction0[] = {
            239,240,240,240,240,240,240,240,240,240,
            240,240,240,240,240,240,241,341,341,341,
            341,341,341,341,341,341,341,341,157,342,
            158,158,158,20,1,1,2,2,159,159,
            5,5,4,4,4,4,4,4,4,4,
            3,3,3,3,3,91,91,91,91,6,
            7,242,242,243,243,130,119,145,136,160,
            160,131,131,343,343,343,343,21,21,21,
            22,199,199,200,200,161,161,162,11,11,
            11,11,11,11,11,23,244,244,9,12,
            8,8,13,13,10,14,15,344,344,344,
            24,24,26,26,27,27,27,28,28,25,
            25,25,30,30,30,30,30,30,30,30,
            30,32,31,31,33,132,108,108,103,103,
            83,83,35,34,84,84,87,87,85,85,
            86,86,81,81,80,80,82,82,78,78,
            77,77,79,79,75,75,74,74,76,76,
            72,72,71,71,71,73,73,73,69,69,
            68,68,68,68,68,70,70,70,70,70,
            60,60,59,59,59,61,61,61,57,57,
            56,56,56,58,58,58,147,147,53,53,
            53,54,54,54,29,29,36,36,36,36,
            36,37,245,245,21,21,21,36,91,89,
            40,91,90,41,201,21,21,202,246,246,
            247,247,247,39,39,42,42,248,248,249,
            43,250,250,204,204,251,251,83,63,203,
            203,164,165,165,165,83,64,64,64,64,
            205,205,140,140,140,140,140,140,206,206,
            206,83,65,65,65,65,166,44,44,44,
            27,27,103,103,253,253,254,254,255,255,
            255,252,252,39,168,168,256,257,148,258,
            258,259,259,207,260,260,260,38,38,38,
            38,123,123,123,123,123,149,138,138,138,
            138,164,142,169,169,146,146,170,124,124,
            141,141,137,137,125,125,125,125,125,125,
            126,126,129,129,127,127,128,128,121,121,
            120,120,122,122,116,116,115,115,117,117,
            113,113,112,112,114,114,110,110,109,109,
            109,111,111,111,105,105,104,104,104,104,
            104,106,106,106,106,106,101,101,100,100,
            100,102,102,102,98,98,97,97,97,99,
            99,99,171,171,92,92,93,93,94,94,
            94,94,94,94,95,95,95,95,95,95,
            95,95,96,96,96,96,96,96,39,45,
            39,46,261,261,261,28,28,46,208,208,
            208,262,262,211,211,263,263,264,264,83,
            66,265,266,266,62,66,267,268,268,269,
            270,270,67,47,39,28,272,272,272,272,
            273,273,274,274,271,271,271,275,275,275,
            276,213,213,214,214,277,278,278,28,28,
            39,48,49,50,39,39,209,209,167,167,
            167,215,118,118,279,279,216,164,217,217,
            217,88,88,212,212,55,211,211,211,264,
            264,239,281,282,283,282,218,280,280,281,
            281,281,281,281,281,281,281,281,281,281,
            284,284,287,288,285,285,290,291,289,294,
            294,295,295,293,296,292,299,292,297,297,
            300,220,220,298,298,152,152,153,154,221,
            221,223,223,222,222,222,151,219,219,224,
            224,224,224,224,224,224,224,286,305,286,
            304,304,306,303,303,303,225,225,225,302,
            302,179,172,180,180,226,226,163,163,163,
            227,227,228,228,228,181,181,310,310,182,
            182,311,311,311,307,307,307,312,312,312,
            312,312,229,229,313,313,313,313,313,313,
            308,308,309,309,314,314,173,173,173,173,
            173,173,173,174,174,174,186,186,187,231,
            231,183,183,184,185,175,175,190,188,188,
            189,176,176,193,193,191,192,144,315,315,
            177,177,194,195,195,196,197,197,197,319,
            319,320,321,322,322,322,317,317,324,324,
            318,318,325,325,316,326,326,329,329,327,
            327,330,330,330,328,328,331,331,332,332,
            210,232,232,232,210,51,51,233,233,233,
            233,52,52,333,333,333,234,234,235,235,
            236,334,334,334,334,16,16,17,17,17,
            17,335,335,335,335,18,18,18,18,18,
            18,19,19,30,30,39,30,30,39,39,
            1,1,336,336,37,37,71,73,282,289,
            281,337,178,178,237,237,237,338,338,230,
            301,301,139,339,339,238,238,238,238,198,
            198,155,155,156,156,156,143,143,134,134,
            134,134,134,133,133,133,135,135,135,135,
            323,323,323,150,150,150,150,107,2418,2094,
            1351,2425,3493,2238,3492,3491,3591,3593,92,79,
            3592,3590,3589,3588,1196,771,772,775,142,218,
            3587,3497,3597,110,111,112,113,1525,119,120,
            121,131,3604,3596,214,416,3595,3594,3495,3494,
            243,244,303,438,440,474,500,504,505,779,
            778,3739,38,1351,30,31,232,3463,1351,4166,
            460,346,347,348,349,465,232,40,1351,2785,
            4037,3025,3739,38,1351,30,31,2411,88,92,
            234,89,91,93,94,91,339,232,3453,1351,
            406,409,414,420,426,3598,3612,401,3600,3611,
            391,2488,3599,3613,381,6,68,3603,3610,374,
            3601,3614,368,3606,3609,362,3339,3389,3605,3616,
            356,341,3618,338,344,3617,351,3608,232,3478,
            1351,4416,232,40,1351,1225,343,3026,3342,321,
            2483,2094,1351,2425,3493,2238,3492,3491,3591,3593,
            92,79,3592,3590,3589,3588,1196,771,772,775,
            142,218,3587,3497,3597,110,111,112,113,1525,
            119,120,121,131,3604,3596,214,416,3595,3594,
            3495,3494,243,244,303,438,440,474,500,504,
            505,779,778,3739,38,1351,30,31,232,3454,
            1351,783,460,346,347,348,349,465,32,39,
            41,571,575,576,2883,4383,3879,2678,466,1351,
            3725,3478,572,575,576,232,3462,1351,339,32,
            39,2540,406,409,414,420,426,3598,3612,401,
            3600,3611,391,2427,3599,3613,381,72,2546,3603,
            3610,374,3601,3614,368,3606,3609,362,71,491,
            3605,3616,356,341,3618,338,344,3617,351,3608,
            3223,241,4201,334,2731,520,624,2370,343,1055,
            328,321,3176,2094,1351,2425,3493,2238,3492,3491,
            3591,3593,92,79,3592,3590,3589,3588,1196,771,
            772,775,142,218,3587,3497,3597,110,111,112,
            113,1525,119,120,121,131,3604,3596,214,416,
            3595,3594,3495,3494,243,244,303,438,440,474,
            500,504,505,779,778,2669,40,1351,516,621,
            3445,3764,2810,3443,460,346,347,348,349,465,
            32,39,2567,558,560,562,71,3804,232,40,
            1351,223,1611,2213,232,3478,1351,572,575,576,
            339,232,837,1351,406,409,414,420,426,3598,
            3612,401,3600,3611,391,3782,3599,3613,381,2682,
            212,3603,3610,374,3601,3614,368,3606,3609,362,
            4068,3556,3605,3616,356,341,3618,338,344,3617,
            351,3608,316,2669,40,1351,687,887,1832,2522,
            343,3028,3972,1784,3176,2094,1351,2425,3493,2238,
            3492,3491,3591,3593,92,79,3592,3590,3589,3588,
            1196,771,772,775,142,218,3587,3497,3597,110,
            111,112,113,1525,119,120,121,131,3604,3596,
            214,416,3595,3594,3495,3494,243,244,303,438,
            440,474,500,504,505,779,778,4276,631,314,
            3763,3200,1351,72,467,2837,460,346,347,348,
            349,465,2667,3632,71,3477,1196,771,772,773,
            2411,88,92,234,89,91,93,94,3338,564,
            439,3659,339,3230,608,4453,406,409,414,420,
            426,3598,3612,401,3600,3611,391,333,3599,3613,
            381,2671,1197,3603,3610,374,3601,3614,368,3606,
            3609,362,3981,2689,3605,3616,356,341,3618,338,
            344,3617,351,3608,2131,232,837,1351,3910,4464,
            604,2522,343,808,315,2231,248,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,1525,119,120,121,131,
            2681,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,522,2518,2700,195,2565,2698,185,460,257,
            265,281,459,465,2551,2703,175,2677,2695,168,
            2676,2704,162,2691,2694,156,2689,2706,150,517,
            140,2803,145,2693,98,40,1351,1333,55,1355,
            57,58,833,1834,812,4800,3552,40,1351,1333,
            55,1355,57,58,3552,40,1351,1333,55,1355,
            57,58,3735,4543,2704,4323,626,3824,452,331,
            3723,3722,13065,3223,240,3552,40,1351,1333,55,
            1355,57,58,3907,2945,1543,807,1627,3339,277,
            3396,2555,1351,776,706,3191,232,3742,1351,4658,
            699,701,13060,622,2228,2783,1196,771,772,774,
            518,261,290,3727,3712,4513,1240,3172,3222,3729,
            3734,456,605,228,231,2142,3352,11889,3733,749,
            1076,475,3221,3201,3728,228,231,1083,836,450,
            232,3462,1351,228,231,2826,232,3744,1351,3353,
            1061,2357,3425,2821,668,2357,312,2831,1351,2673,
            793,580,515,1060,228,231,2829,1415,3406,596,
            2613,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,1525,
            119,120,121,131,2681,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,1973,2518,2700,195,2565,
            2698,185,460,257,265,281,459,465,2551,2703,
            175,2677,2695,168,2676,2704,162,2691,2694,156,
            2689,2706,150,517,140,2803,145,2693,3038,67,
            40,1351,1333,55,1355,57,58,251,3293,686,
            232,3478,1351,680,3655,63,3756,1333,818,2998,
            820,819,3837,4704,506,3231,589,590,591,592,
            593,594,1565,331,612,451,1,663,664,665,
            13153,1734,675,676,1742,681,682,1114,690,691,
            946,1230,125,1785,3037,3552,40,1351,1333,55,
            1355,57,58,777,4763,4601,3230,3372,1148,667,
            16,2550,507,3365,518,261,668,679,587,232,
            40,1351,793,2690,2213,469,1317,4511,228,231,
            2834,694,232,3478,1351,3008,3996,645,6806,2562,
            232,837,1351,821,822,232,2831,1351,470,472,
            1615,3471,4147,601,3580,40,1351,1333,55,1355,
            57,58,836,598,102,504,721,1060,698,72,
            3552,40,1351,1333,55,1355,57,58,2830,2832,
            71,3758,730,4474,228,231,617,2257,1399,1575,
            3060,2094,1351,2425,3493,2238,3492,3491,3591,3593,
            92,79,3592,3590,3589,3588,1196,771,772,775,
            142,218,3587,3497,3597,110,111,112,113,1525,
            119,120,121,131,3604,3596,214,416,3595,3594,
            3495,3494,243,244,303,438,440,474,500,504,
            505,779,778,228,231,2834,570,1728,799,13210,
            337,72,460,346,347,348,349,465,3724,228,
            231,2833,71,492,64,695,4398,4554,13162,812,
            584,3000,710,2357,324,3730,714,1628,339,725,
            720,4628,406,409,414,420,426,3598,3612,401,
            3600,3611,391,2537,3599,3613,381,810,2357,3603,
            3610,374,3601,3614,368,3606,3609,362,1396,252,
            3605,3616,356,341,340,338,344,3617,351,3608,
            67,40,1351,1333,55,1355,57,58,232,837,
            1351,1784,3060,2094,1351,2425,3493,2238,3492,3491,
            3591,3593,92,79,3592,3590,3589,3588,1196,771,
            772,775,142,218,3587,3497,3597,110,111,112,
            113,1525,119,120,121,131,3604,3596,214,416,
            3595,3594,3495,3494,243,244,303,438,440,474,
            500,504,505,779,778,2669,40,1351,462,464,
            3445,674,1772,3443,460,346,347,348,349,465,
            245,247,1630,3008,2209,716,3734,569,334,228,
            231,2834,323,599,236,328,693,11889,6026,3753,
            339,232,837,1351,406,409,414,420,426,3598,
            3612,401,3600,3611,391,956,3599,3613,381,3874,
            3995,3603,3610,374,3601,3614,368,3606,3609,362,
            3910,4335,3605,3616,356,341,340,338,344,3617,
            351,3608,3872,730,3552,40,1351,1333,55,1355,
            57,58,3851,2231,3118,2094,1351,2425,3493,2238,
            3492,3491,3591,3593,92,79,3592,3590,3589,3588,
            1196,771,772,775,142,218,3587,3497,3597,110,
            111,112,113,1525,119,120,121,131,3604,3596,
            214,416,3595,3594,3495,3494,243,244,303,438,
            440,474,500,504,505,779,778,241,2807,4023,
            3130,3662,4771,4449,3987,1988,460,346,347,348,
            349,465,2818,3726,497,8330,2997,3008,455,3707,
            3793,4763,3000,228,231,2834,2357,2704,4518,232,
            837,1351,339,3746,608,3443,406,409,414,420,
            426,3598,3612,401,3600,3611,391,3662,3599,3613,
            381,3972,269,3603,3610,374,3601,3614,368,3606,
            3609,362,311,334,3605,3616,356,323,342,338,
            344,3617,351,3608,307,836,69,3027,3725,69,
            603,332,343,2548,2094,1351,2425,3493,2238,3492,
            3491,3591,3593,92,79,3592,3590,3589,3588,1196,
            771,772,775,142,218,3587,3497,3597,110,111,
            112,113,1525,119,120,121,131,3604,3596,214,
            416,3595,3594,3495,3494,243,244,303,438,440,
            474,500,504,505,779,778,1548,2990,7274,286,
            677,3464,801,580,557,460,346,347,348,349,
            465,571,575,576,3008,4511,2998,271,1527,563,
            4368,64,2357,513,647,649,2887,337,232,837,
            1351,339,232,837,1351,406,409,414,420,426,
            3598,3612,401,3600,3611,391,1590,3599,3613,381,
            3972,325,3603,3610,374,3601,3614,368,3606,3609,
            362,4104,2931,3605,3616,356,3628,342,338,344,
            3617,351,3608,3972,3173,3456,684,289,269,910,
            2667,343,3118,2094,1351,2425,3493,2238,3492,3491,
            3591,3593,92,79,3592,3590,3589,3588,1196,771,
            772,775,142,218,3587,3497,3597,110,111,112,
            113,1525,119,120,121,131,3604,3596,214,416,
            3595,3594,3495,3494,243,244,303,438,440,474,
            500,504,505,779,778,2822,318,666,286,632,
            553,4511,4695,3970,460,346,347,348,349,465,
            646,648,3921,4799,270,1574,4026,565,13161,2704,
            683,1523,333,266,586,4165,2817,3446,2807,327,
            339,2503,4801,899,406,409,414,420,426,3598,
            3612,401,3600,3611,391,13177,3599,3613,381,1946,
            4289,3603,3610,374,3601,3614,368,3606,3609,362,
            441,2724,3605,3616,356,4558,342,338,344,3617,
            351,3608,232,837,1351,3460,287,4660,2357,2522,
            343,770,2666,1351,2425,224,2238,225,226,2411,
            88,92,79,89,91,93,94,1196,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1525,119,120,121,131,2681,217,2119,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,291,2518,2700,195,
            2565,2698,185,460,257,265,281,459,465,2551,
            2703,175,2677,2695,168,2676,2704,162,2691,2694,
            156,2689,2706,150,3479,3483,2803,145,2693,626,
            232,3034,1351,232,3034,1351,4045,4411,337,2800,
            4272,3736,132,232,40,1351,2602,2611,2213,2357,
            4347,3436,3451,232,3034,1351,614,3452,2357,4251,
            3482,3781,326,99,3844,3407,623,2228,3483,3740,
            3660,71,3481,3608,4178,761,4298,3480,2103,2680,
            1351,2425,224,2238,225,226,2411,88,92,79,
            89,91,93,94,1196,771,772,775,142,218,
            77,78,216,110,111,112,113,1525,119,120,
            121,131,2681,217,2119,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,292,2518,2700,195,2565,2698,185,
            460,257,265,281,459,465,2551,2703,175,2677,
            2695,168,2676,2704,162,2691,2694,156,2689,2706,
            150,138,140,2803,145,2693,70,524,2997,70,
            761,2212,2997,3790,3547,69,613,1333,69,333,
            3974,3761,2997,625,4731,2409,327,4109,4238,222,
            97,4212,4520,3763,583,750,1139,72,782,204,
            317,3393,4075,2674,2818,4044,971,4102,71,3760,
            2820,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,1525,
            119,120,121,131,2681,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,3736,2518,2700,195,2565,
            2698,185,460,257,265,281,459,465,2551,2703,
            175,2677,2695,168,2676,2704,162,2691,2694,156,
            2689,2706,150,3225,140,2803,145,2693,3032,3748,
            3972,4523,3972,3972,2493,3238,2094,1351,2425,224,
            2238,225,226,2411,88,92,79,89,91,93,
            94,1196,771,772,775,142,218,77,78,216,
            110,111,112,113,2152,119,120,121,131,3238,
            217,2119,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            4526,2518,2700,195,2565,2698,185,4539,635,4521,
            4531,83,85,2551,2703,175,2677,2695,168,2676,
            2704,162,2691,2694,156,152,3239,151,286,3033,
            473,602,446,4534,4537,4002,4136,4541,4545,653,
            3441,3486,3838,3882,3516,4546,3427,4547,4549,3224,
            3226,2820,2094,1351,2425,224,2238,225,226,2411,
            88,92,79,89,91,93,94,1196,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1525,119,120,121,131,2681,217,2119,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,288,2518,2700,195,
            2565,2698,185,460,257,265,281,459,465,2551,
            2703,175,2677,2695,168,2676,2704,162,2691,2694,
            156,2689,2706,150,3225,140,2803,145,2693,3972,
            3972,3972,3972,3741,4548,4552,3238,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,2152,119,120,121,131,
            3350,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,4556,2518,2700,195,2565,2698,185,4559,4561,
            4565,4570,83,85,2551,2703,175,2677,2695,168,
            2676,2704,162,158,3351,157,55,253,445,301,
            254,4572,4567,4563,4574,4575,4576,2876,4580,4582,
            4583,3511,4584,4592,4590,4596,4600,4602,3764,4605,
            3228,3226,450,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1525,119,120,121,131,2681,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,306,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,304,140,2803,145,2693,
            305,3914,4275,4067,3886,3984,4084,232,837,1351,
            3935,4009,4228,4070,4172,4185,4265,4417,4001,3765,
            3799,4606,4608,4609,3720,2952,2670,1351,2425,224,
            2238,225,226,2411,88,92,79,89,91,93,
            94,1196,771,772,775,142,218,77,78,216,
            110,111,112,113,1525,119,120,121,131,2681,
            217,2119,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1112,2518,2700,195,2565,2698,185,460,257,265,
            281,459,465,2551,2703,175,2677,2695,168,2676,
            2704,162,2691,2694,156,2689,2706,150,487,140,
            2803,145,2693,4611,833,4319,4438,4613,4616,4617,
            4619,4623,4625,4445,4447,925,4629,4641,4633,4643,
            4645,4647,4637,4639,232,40,1351,4651,4653,2213,
            4654,4657,4659,4031,72,4662,2819,4665,4661,4672,
            4663,3637,4671,4673,4674,71,3490,2230,2727,4675,
            4678,4110,4123,4141,4144,4156,13135,4159,319,324,
            2094,1351,2425,224,2238,225,226,2411,88,92,
            79,89,91,93,94,1196,771,772,775,142,
            218,77,78,216,110,111,112,113,1525,119,
            120,121,131,2681,217,2119,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,292,2518,2700,195,2565,2698,
            185,460,257,265,281,459,465,2551,2703,175,
            2677,2695,168,2676,2704,162,2691,2694,156,2689,
            2706,150,138,140,2803,145,2693,4171,4183,4196,
            4217,3455,4231,4239,4252,4264,4267,4279,4456,4091,
            4459,4681,3135,3792,3652,4682,4683,3134,4685,4686,
            4433,4461,4463,4324,4688,583,4687,4689,4325,3434,
            4691,4694,4697,4698,4700,4709,4711,4696,4707,4713,
            3489,2729,2094,1351,2425,224,2238,225,226,2411,
            88,92,79,89,91,93,94,1196,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1525,119,120,121,131,2681,217,2119,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,3737,2518,2700,195,
            2565,2698,185,460,257,265,281,459,465,2551,
            2703,175,2677,2695,168,2676,2704,162,2691,2694,
            156,2689,2706,150,517,140,2803,145,2693,3392,
            1405,3234,94,245,3395,4376,4389,3369,3707,4114,
            2668,4242,4390,3115,3994,4297,4030,4087,4478,4405,
            4714,4716,4724,4717,4727,4730,4732,4733,4738,4742,
            4743,4746,4350,4747,331,4748,4749,4750,4756,4487,
            4758,4496,4759,4761,4454,4292,3848,4764,3971,4765,
            4086,4358,4363,4367,760,824,829,770,759,619,
            264,268,302,486,242,268,657,768,758,449,
            633,585,585,527,619,519,261,387,2094,1351,
            2425,224,2238,225,226,2411,88,92,79,89,
            91,93,94,1196,771,772,775,142,218,77,
            78,216,110,111,112,113,1525,119,120,121,
            131,2681,217,2119,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,292,2518,2700,195,2565,2698,185,460,
            257,265,281,459,465,2551,2703,175,2677,2695,
            168,2676,2704,162,2691,2694,156,2689,2706,150,
            138,140,2803,145,2693,4479,4505,4307,4497,4507,
            4508,4510,4029,4443,3943,4767,4774,4768,4778,4781,
            3135,4785,4787,4788,4789,3449,518,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,1525,119,120,121,131,
            2681,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,292,2518,2700,195,2565,2698,185,460,257,
            265,281,459,465,2551,2703,175,2677,2695,168,
            2676,2704,162,2691,2694,156,2689,2706,150,138,
            140,2803,145,2693,4791,4795,4471,4382,4406,4802,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,3135,
            13563,13563,13563,13563,3456,581,2094,1351,2425,224,
            2238,225,226,2411,88,92,79,89,91,93,
            94,1196,771,772,775,142,218,77,78,216,
            110,111,112,113,1525,119,120,121,131,2681,
            217,2119,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            292,2518,2700,195,2565,2698,185,460,257,265,
            281,459,465,2551,2703,175,2677,2695,168,2676,
            2704,162,2691,2694,156,2689,2706,150,138,140,
            2803,145,2693,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,3135,13563,
            13563,13563,13563,3457,644,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,292,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,138,140,2803,
            145,2693,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,3135,13563,13563,
            13563,13563,3459,707,2094,1351,2425,224,2238,225,
            226,2411,88,92,79,89,91,93,94,1196,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1525,119,120,121,131,2681,217,2119,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,292,2518,
            2700,195,2565,2698,185,460,257,265,281,459,
            465,2551,2703,175,2677,2695,168,2676,2704,162,
            2691,2694,156,2689,2706,150,138,140,2803,145,
            2693,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,3135,13563,13563,13563,
            13563,3472,136,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1525,119,120,121,131,2681,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,458,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,3620,140,2803,145,2693,
            2679,833,2094,1351,2425,224,2238,225,226,2411,
            88,92,79,89,91,93,94,1196,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1525,119,120,121,131,2681,217,2119,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,292,2518,2700,195,
            2565,2698,185,460,257,265,281,459,465,2551,
            2703,175,2677,2695,168,2676,2704,162,2691,2694,
            156,2689,2706,150,138,140,2803,145,2693,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,3135,13563,13563,13563,13563,3629,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,457,896,2094,1351,2425,224,
            2238,225,226,2411,88,92,79,89,91,93,
            94,1196,771,772,775,142,218,77,78,216,
            110,111,112,113,1525,119,120,121,131,2681,
            217,2119,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            292,2518,2700,195,2565,2698,185,460,257,265,
            281,459,465,2551,2703,175,2677,2695,168,2676,
            2704,162,2691,2694,156,2689,2706,150,138,140,
            2803,145,2693,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,3135,13563,
            13563,13563,13563,3741,959,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,292,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,138,140,2803,
            145,2693,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,3135,13563,13563,
            13563,13563,3743,1022,2094,1351,2425,224,2238,225,
            226,2411,88,92,79,89,91,93,94,1196,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1525,119,120,121,131,2681,217,2119,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,292,2518,
            2700,195,2565,2698,185,460,257,265,281,459,
            465,2551,2703,175,2677,2695,168,2676,2704,162,
            2691,2694,156,2689,2706,150,138,140,2803,145,
            2693,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,3135,13563,13563,13563,
            13563,3745,1085,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1525,119,120,121,131,2681,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,454,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,3620,140,2803,145,2693,
            2679,1153,2094,1351,2425,224,2238,225,226,2411,
            88,92,79,89,91,93,94,1196,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1525,119,120,121,131,2681,217,2119,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,292,2518,2700,195,
            2565,2698,185,460,257,265,281,459,465,2551,
            2703,175,2677,2695,168,2676,2704,162,2691,2694,
            156,2689,2706,150,138,140,2803,145,2693,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,3135,13563,13563,13563,13563,3898,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,453,1216,2094,1351,2425,224,
            2238,225,226,2411,88,92,79,89,91,93,
            94,1196,771,772,775,142,218,77,78,216,
            110,111,112,113,1525,119,120,121,131,2681,
            217,2119,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            292,2518,2700,195,2565,2698,185,460,257,265,
            281,459,465,2551,2703,175,2677,2695,168,2676,
            2704,162,2691,2694,156,2689,2706,150,138,140,
            2803,145,2693,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,3135,13563,
            13563,13563,13563,3899,1279,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,292,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,138,140,2803,
            145,2693,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,3135,13563,13563,
            13563,13563,3901,1410,2094,1351,2425,224,2238,225,
            226,2411,88,92,79,89,91,93,94,1196,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1525,119,120,121,131,2681,217,2119,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,308,2518,
            2700,195,2565,2698,185,460,257,265,281,459,
            465,2551,2703,175,2677,2695,168,2676,2704,162,
            2691,2694,156,2689,2706,150,2999,140,2803,145,
            2693,3238,2094,1351,2425,224,2238,225,226,2411,
            88,92,79,89,91,93,94,1196,771,772,
            775,142,218,77,78,216,110,111,112,113,
            2152,119,120,121,131,3340,217,2119,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,13563,198,3341,197,
            13563,320,1473,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1525,119,120,121,131,2681,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,308,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,2999,140,2803,145,2693,
            13563,13563,13563,13563,13563,2952,2094,1351,2425,224,
            2238,225,226,2411,88,92,79,89,91,93,
            94,1196,771,772,775,142,218,77,78,216,
            110,111,112,113,1525,119,120,121,131,2681,
            217,2119,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            320,2518,2700,195,2565,2698,185,460,257,265,
            281,459,465,2551,2703,175,2677,2695,168,2676,
            2704,162,2691,2694,156,2689,2706,150,3225,140,
            2803,145,2693,3238,2094,1351,2425,224,2238,225,
            226,2411,88,92,79,89,91,93,94,1196,
            771,772,775,142,218,77,78,216,110,111,
            112,113,2152,119,120,121,131,3333,217,2119,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,13563,2518,
            2700,195,2565,2698,185,13563,13563,13563,13563,13563,
            13563,178,3334,787,13563,13563,84,85,1977,2094,
            1351,2425,224,2238,225,226,2411,88,92,79,
            89,91,93,94,1196,771,772,775,142,218,
            77,78,216,110,111,112,113,1525,119,120,
            121,131,2681,217,2119,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,308,2518,2700,195,2565,2698,185,
            460,257,265,281,459,465,2551,2703,175,2677,
            2695,168,2676,2704,162,2691,2694,156,2689,2706,
            150,2999,140,2803,145,2693,3238,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,2152,119,120,121,131,
            3340,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,13563,198,3342,196,13563,320,2040,2094,1351,
            2425,224,2238,225,226,2411,88,92,79,89,
            91,93,94,1196,771,772,775,142,218,77,
            78,216,110,111,112,113,1525,119,120,121,
            131,2681,217,2119,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,292,2518,2700,195,2565,2698,185,460,
            257,265,281,459,465,2551,2703,175,2677,2695,
            168,2676,2704,162,2691,2694,156,2689,2706,150,
            138,140,2803,145,2693,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            3759,2890,2094,1351,2425,224,2238,225,226,2411,
            88,92,79,89,91,93,94,1196,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1525,119,120,121,131,2681,217,2119,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,3707,2518,2700,195,
            2565,2698,185,460,257,265,281,459,465,2551,
            2703,175,2677,2695,168,2676,2704,162,2691,2694,
            156,2689,2706,150,304,140,2803,145,2693,305,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,767,13563,13563,2890,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,310,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,304,140,2803,
            145,2693,305,3238,2094,1351,2425,224,2238,225,
            226,2411,88,92,79,89,91,93,94,1196,
            771,772,775,142,218,77,78,216,110,111,
            112,113,2152,119,120,121,131,3331,217,2119,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,13563,2518,
            2700,195,2565,2698,185,13563,13563,13563,13563,13563,
            13563,2551,2703,175,2677,2695,168,164,3332,163,
            13563,13563,313,2292,2094,1351,2425,224,2238,225,
            226,2411,88,92,79,89,91,93,94,1196,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1525,119,120,121,131,2681,217,2119,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,308,2518,
            2700,195,2565,2698,185,460,257,265,281,459,
            465,2551,2703,175,2677,2695,168,2676,2704,162,
            2691,2694,156,2689,2706,150,2999,140,2803,145,
            2693,13563,13563,13563,13563,13563,2355,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,1525,119,120,121,131,
            2681,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,320,2518,2700,195,2565,2698,185,460,257,
            265,281,459,465,2551,2703,175,2677,2695,168,
            2676,2704,162,2691,2694,156,2689,2706,150,259,
            140,2803,145,2693,1536,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,285,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,284,140,2803,
            145,2693,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,258,
            1599,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,1525,
            119,120,121,131,2681,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,283,2518,2700,195,2565,
            2698,185,460,257,265,281,459,465,2551,2703,
            175,2677,2695,168,2676,2704,162,2691,2694,156,
            2689,2706,150,282,140,2803,145,2693,3006,2094,
            1351,2425,224,2238,225,226,2411,88,92,79,
            89,91,93,94,1196,771,772,775,142,218,
            77,78,216,110,111,112,113,1525,119,120,
            121,131,2681,217,2119,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,13563,2518,2700,195,2565,2698,185,
            460,257,265,3236,459,465,2551,2703,175,2677,
            2695,168,2676,2704,162,2691,2694,156,2689,2706,
            150,3233,140,2803,145,2693,3238,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,2152,119,120,121,131,
            3348,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,13563,2518,2700,195,2565,2698,185,13563,13563,
            13563,13563,13563,13563,2551,2703,175,170,3349,169,
            13563,13563,13563,13563,13563,3234,1662,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,1525,119,120,121,131,
            2681,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,275,2518,2700,195,2565,2698,185,460,257,
            265,281,459,465,2551,2703,175,2677,2695,168,
            2676,2704,162,2691,2694,156,2689,2706,150,274,
            140,2803,145,2693,1725,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,528,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,3460,140,2803,
            145,2693,2355,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1525,119,120,121,131,2681,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,13563,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,259,140,2803,145,2693,
            1788,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,1525,
            119,120,121,131,2681,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,785,2518,2700,195,2565,
            2698,185,460,257,265,281,459,465,2551,2703,
            175,2677,2695,168,2676,2704,162,2691,2694,156,
            2689,2706,150,784,140,2803,145,2693,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,3461,1851,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,1525,119,120,121,131,
            2681,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,293,2518,2700,195,2565,2698,185,460,257,
            265,281,459,465,2551,2703,175,2677,2695,168,
            2676,2704,162,2691,2694,156,2689,2706,150,139,
            140,2803,145,2693,1914,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,273,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,272,140,2803,
            145,2693,2166,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1525,119,120,121,131,2681,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,300,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,299,140,2803,145,2693,
            2229,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,1525,
            119,120,121,131,2681,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,745,2518,2700,195,2565,
            2698,185,460,257,265,281,459,465,2551,2703,
            175,2677,2695,168,2676,2704,162,2691,2694,156,
            2689,2706,150,744,140,2803,145,2693,2952,2094,
            1351,2425,224,2238,225,226,2411,88,92,79,
            89,91,93,94,1196,771,772,775,142,218,
            77,78,216,110,111,112,113,1525,119,120,
            121,131,2681,217,2119,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,13563,2518,2700,195,2565,2698,185,
            460,257,265,281,459,465,2551,2703,175,2677,
            2695,168,2676,2704,162,2691,2694,156,2689,2706,
            150,2804,140,2803,145,2693,2952,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,1525,119,120,121,131,
            2681,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,13563,2518,2700,195,2565,2698,185,460,257,
            265,281,459,465,2551,2703,175,2677,2695,168,
            2676,2704,162,2691,2694,156,2689,2706,150,3030,
            140,2803,145,2693,2952,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,13563,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,3035,140,2803,
            145,2693,2952,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1525,119,120,121,131,2681,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,13563,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,689,140,2803,145,2693,
            2952,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,1525,
            119,120,121,131,2681,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,13563,2518,2700,195,2565,
            2698,185,460,257,265,281,459,465,2551,2703,
            175,2677,2695,168,2676,2704,162,2691,2694,156,
            2689,2706,150,3229,140,2803,145,2693,2952,2094,
            1351,2425,224,2238,225,226,2411,88,92,79,
            89,91,93,94,1196,771,772,775,142,218,
            77,78,216,110,111,112,113,1525,119,120,
            121,131,2681,217,2119,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,13563,2518,2700,195,2565,2698,185,
            460,257,265,281,459,465,2551,2703,175,2677,
            2695,168,2676,2704,162,2691,2694,156,2689,2706,
            150,3448,140,2803,145,2693,2952,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,1525,119,120,121,131,
            2681,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,13563,2518,2700,195,2565,2698,185,460,257,
            265,281,459,465,2551,2703,175,2677,2695,168,
            2676,2704,162,2691,2694,156,2689,2706,150,221,
            140,2803,145,2693,2952,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211
        };
    };

    public interface BaseAction1 {
        public final static char baseAction1[] = {
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,13563,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,67,140,2803,145,2693,
            2952,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,1525,
            119,120,121,131,2681,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,13563,2518,2700,195,2565,
            2698,185,460,257,265,281,459,465,2551,2703,
            175,2677,2695,168,2676,2704,162,2691,2694,156,
            2689,2706,150,3468,140,2803,145,2693,2952,2094,
            1351,2425,224,2238,225,226,2411,88,92,79,
            89,91,93,94,1196,771,772,775,142,218,
            77,78,216,110,111,112,113,1525,119,120,
            121,131,2681,217,2119,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,13563,2518,2700,195,2565,2698,185,
            460,257,265,281,459,465,2551,2703,175,2677,
            2695,168,2676,2704,162,2691,2694,156,2689,2706,
            150,3473,140,2803,145,2693,2952,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,1525,119,120,121,131,
            2681,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,13563,2518,2700,195,2565,2698,185,460,257,
            265,281,459,465,2551,2703,175,2677,2695,168,
            2676,2704,162,2691,2694,156,2689,2706,150,237,
            140,2803,145,2693,2952,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,13563,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,87,140,2803,
            145,2693,2952,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1525,119,120,121,131,2681,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,13563,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,511,140,2803,145,2693,
            2952,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,1525,
            119,120,121,131,2681,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,13563,2518,2700,195,2565,
            2698,185,460,257,265,281,459,465,2551,2703,
            175,2677,2695,168,2676,2704,162,2691,2694,156,
            2689,2706,150,3621,140,2803,145,2693,2952,2094,
            1351,2425,224,2238,225,226,2411,88,92,79,
            89,91,93,94,1196,771,772,775,142,218,
            77,78,216,110,111,112,113,1525,119,120,
            121,131,2681,217,2119,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,13563,2518,2700,195,2565,2698,185,
            460,257,265,281,459,465,2551,2703,175,2677,
            2695,168,2676,2704,162,2691,2694,156,2689,2706,
            150,3622,140,2803,145,2693,2952,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,1525,119,120,121,131,
            2681,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,13563,2518,2700,195,2565,2698,185,460,257,
            265,281,459,465,2551,2703,175,2677,2695,168,
            2676,2704,162,2691,2694,156,2689,2706,150,3623,
            140,2803,145,2693,2952,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,13563,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,3627,140,2803,
            145,2693,2952,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1525,119,120,121,131,2681,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,13563,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,461,140,2803,145,2693,
            2952,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,1525,
            119,120,121,131,2681,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,13563,2518,2700,195,2565,
            2698,185,460,257,265,281,459,465,2551,2703,
            175,2677,2695,168,2676,2704,162,2691,2694,156,
            2689,2706,150,3749,140,2803,145,2693,2952,2094,
            1351,2425,224,2238,225,226,2411,88,92,79,
            89,91,93,94,1196,771,772,775,142,218,
            77,78,216,110,111,112,113,1525,119,120,
            121,131,2681,217,2119,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,13563,2518,2700,195,2565,2698,185,
            460,257,265,281,459,465,2551,2703,175,2677,
            2695,168,2676,2704,162,2691,2694,156,2689,2706,
            150,3751,140,2803,145,2693,2952,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,1525,119,120,121,131,
            2681,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,13563,2518,2700,195,2565,2698,185,460,257,
            265,281,459,465,2551,2703,175,2677,2695,168,
            2676,2704,162,2691,2694,156,2689,2706,150,10945,
            140,2803,145,2693,2952,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,13563,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,68,140,2803,
            145,2693,2952,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1525,119,120,121,131,2681,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,13563,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,444,140,2803,145,2693,
            2952,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,1525,
            119,120,121,131,2681,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,13563,2518,2700,195,2565,
            2698,185,460,257,265,281,459,465,2551,2703,
            175,2677,2695,168,2676,2704,162,2691,2694,156,
            2689,2706,150,3755,140,2803,145,2693,2952,2094,
            1351,2425,224,2238,225,226,2411,88,92,79,
            89,91,93,94,1196,771,772,775,142,218,
            77,78,216,110,111,112,113,1525,119,120,
            121,131,2681,217,2119,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,13563,2518,2700,195,2565,2698,185,
            460,257,265,281,459,465,2551,2703,175,2677,
            2695,168,2676,2704,162,2691,2694,156,2689,2706,
            150,3757,140,2803,145,2693,2952,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,1525,119,120,121,131,
            2681,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,13563,2518,2700,195,2565,2698,185,460,257,
            265,281,459,465,2551,2703,175,2677,2695,168,
            2676,2704,162,2691,2694,156,2689,2706,150,488,
            140,2803,145,2693,2952,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,13563,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,3896,140,2803,
            145,2693,2952,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1525,119,120,121,131,2681,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,13563,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,510,140,2803,145,2693,
            2952,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,1525,
            119,120,121,131,2681,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,13563,2518,2700,195,2565,
            2698,185,460,257,265,281,459,465,2551,2703,
            175,2677,2695,168,2676,2704,162,2691,2694,156,
            2689,2706,150,509,140,2803,145,2693,2952,2094,
            1351,2425,224,2238,225,226,2411,88,92,79,
            89,91,93,94,1196,771,772,775,142,218,
            77,78,216,110,111,112,113,1525,119,120,
            121,131,2681,217,2119,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,13563,2518,2700,195,2565,2698,185,
            460,257,265,281,459,465,2551,2703,175,2677,
            2695,168,2676,2704,162,2691,2694,156,2689,2706,
            150,3897,140,2803,145,2693,2952,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,1525,119,120,121,131,
            2681,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,13563,2518,2700,195,2565,2698,185,460,257,
            265,281,459,465,2551,2703,175,2677,2695,168,
            2676,2704,162,2691,2694,156,2689,2706,150,3902,
            140,2803,145,2693,2952,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,13563,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,3903,140,2803,
            145,2693,2952,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1525,119,120,121,131,2681,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,13563,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,3904,140,2803,145,2693,
            2952,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,1525,
            119,120,121,131,2681,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,13563,2518,2700,195,2565,
            2698,185,460,257,265,281,459,465,2551,2703,
            175,2677,2695,168,2676,2704,162,2691,2694,156,
            2689,2706,150,3994,140,2803,145,2693,2952,2094,
            1351,2425,224,2238,225,226,2411,88,92,79,
            89,91,93,94,1196,771,772,775,142,218,
            77,78,216,110,111,112,113,1525,119,120,
            121,131,2681,217,2119,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,13563,2518,2700,195,2565,2698,185,
            460,257,265,281,459,465,2551,2703,175,2677,
            2695,168,2676,2704,162,2691,2694,156,2689,2706,
            150,490,140,2803,145,2693,2952,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,1525,119,120,121,131,
            2681,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,13563,2518,2700,195,2565,2698,185,460,257,
            265,281,459,465,2551,2703,175,2677,2695,168,
            2676,2704,162,2691,2694,156,2689,2706,150,489,
            140,2803,145,2693,2952,2094,1351,2425,224,2238,
            225,226,2411,88,92,79,89,91,93,94,
            1196,771,772,775,142,218,77,78,216,110,
            111,112,113,1525,119,120,121,131,2681,217,
            2119,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,13563,
            2518,2700,195,2565,2698,185,460,257,265,281,
            459,465,2551,2703,175,2677,2695,168,2676,2704,
            162,2691,2694,156,2689,2706,150,3999,140,2803,
            145,2693,2952,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1525,119,120,121,131,2681,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,13563,2518,2700,
            195,2565,2698,185,460,257,265,281,459,465,
            2551,2703,175,2677,2695,168,2676,2704,162,2691,
            2694,156,2689,2706,150,628,140,2803,145,2693,
            3288,2094,1351,2425,3493,2238,3492,3491,3591,3593,
            92,79,3592,3590,3589,3588,1196,771,772,775,
            142,218,3587,3497,3597,110,111,112,113,2152,
            119,120,121,131,3766,3596,214,416,3595,3594,
            3495,3494,243,244,303,438,440,474,500,504,
            505,779,778,232,3034,1351,13563,13563,13563,13563,
            13563,13563,13563,4484,3708,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,406,409,414,420,426,3598,3612,401,
            3600,3611,391,13563,3599,3613,381,13563,13563,3603,
            3610,374,3601,3614,368,3606,3609,362,530,832,
            358,3767,357,3288,2094,1351,2425,3493,2238,3492,
            3491,3591,3593,92,79,3592,3590,3589,3588,1196,
            771,772,775,142,218,3587,3497,3597,110,111,
            112,113,2152,119,120,121,131,3894,3596,214,
            416,3595,3594,3495,3494,243,244,303,438,440,
            474,500,504,505,779,778,4423,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,70,
            13563,13563,13563,13563,13563,13563,13563,13563,69,13563,
            13563,13563,13563,13563,13563,3604,40,1351,1333,55,
            1355,57,58,96,13563,406,409,414,420,426,
            3598,3612,401,3600,3611,391,13563,3599,3613,381,
            13563,619,3603,3610,374,3601,3614,368,364,3895,
            363,3288,2094,1351,2425,3493,2238,3492,3491,3591,
            3593,92,79,3592,3590,3589,3588,1196,771,772,
            775,142,218,3587,3497,3597,110,111,112,113,
            2152,119,120,121,131,3768,3596,214,416,3595,
            3594,3495,3494,243,244,303,438,440,474,500,
            504,505,779,778,228,231,2834,3227,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            3552,40,1351,1333,55,1355,57,58,13563,13563,
            13563,13563,13563,406,409,414,420,426,3598,3612,
            401,3600,3611,391,13563,3599,3613,381,729,13563,
            3603,3610,374,370,3769,369,3288,2094,1351,2425,
            3493,2238,3492,3491,3591,3593,92,79,3592,3590,
            3589,3588,1196,771,772,775,142,218,3587,3497,
            3597,110,111,112,113,2152,119,120,121,131,
            3892,3596,214,416,3595,3594,3495,3494,243,244,
            303,438,440,474,500,504,505,779,778,228,
            231,2834,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,3552,40,1351,1333,55,1355,57,58,
            3552,40,1351,1333,55,1355,57,58,406,409,
            414,420,426,3598,3612,401,3600,3611,391,13563,
            3599,3613,381,809,13563,376,3893,375,3288,2094,
            1351,2425,3493,2238,3492,3491,3591,3593,92,79,
            3592,3590,3589,3588,1196,771,772,775,142,218,
            3587,3497,3597,110,111,112,113,2152,119,120,
            121,131,3770,3596,214,416,3595,3594,3495,3494,
            243,244,303,438,440,474,500,504,505,779,
            778,228,231,3036,13563,13563,13563,13563,13563,228,
            231,3731,13563,13563,13563,13563,13563,734,13563,3552,
            40,1351,1333,55,1355,57,58,3552,40,1351,
            1333,55,1355,57,58,13563,13563,13563,13563,13563,
            406,409,414,420,426,3598,3612,401,3600,3611,
            391,13563,384,3771,383,3288,2094,1351,2425,3493,
            2238,3492,3491,3591,3593,92,79,3592,3590,3589,
            3588,1196,771,772,775,142,218,3587,3497,3597,
            110,111,112,113,2152,119,120,121,131,3770,
            3596,214,416,3595,3594,3495,3494,243,244,303,
            438,440,474,500,504,505,779,778,228,231,
            3354,13563,13563,13563,13563,13563,228,231,3447,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,3628,40,1351,1333,55,
            1355,57,58,13563,13563,13563,13563,406,409,414,
            420,426,3598,3612,401,3600,3611,391,13563,384,
            3772,382,3238,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,2152,119,120,121,131,3333,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,13563,2518,2700,
            195,2565,2698,185,228,231,617,13563,13563,13563,
            178,3335,177,3238,2094,1351,2425,224,2238,225,
            226,2411,88,92,79,89,91,93,94,1196,
            771,772,775,142,218,77,78,216,110,111,
            112,113,2152,119,120,121,131,3333,217,2119,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,13563,2518,
            2700,195,2565,2698,185,13563,13563,13563,3739,13563,
            13563,178,3336,176,3288,2094,1351,2425,3493,2238,
            3492,3491,3591,3593,92,79,3592,3590,3589,3588,
            1196,771,772,775,142,218,3587,3497,3597,110,
            111,112,113,2152,119,120,121,131,3887,3596,
            214,416,3595,3594,3495,3494,243,244,303,438,
            440,474,500,504,505,779,778,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,3552,40,1351,1333,55,1355,57,58,13563,
            13563,13563,13563,13563,13563,13563,3624,3552,40,1351,
            1333,55,1355,57,58,13563,406,409,414,420,
            426,3598,3612,401,396,3888,395,3288,2094,1351,
            2425,3493,2238,3492,3491,3591,3593,92,79,3592,
            3590,3589,3588,1196,771,772,775,142,218,3587,
            3497,3597,110,111,112,113,2152,119,120,121,
            131,3887,3596,214,416,3595,3594,3495,3494,243,
            244,303,438,440,474,500,504,505,779,778,
            228,231,66,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,228,231,3467,3552,
            40,1351,1333,55,1355,57,58,3552,40,1351,
            1333,55,1355,57,58,13563,13563,13563,13563,406,
            409,414,420,426,3598,3612,401,396,3889,394,
            3288,2094,1351,2425,3493,2238,3492,3491,3591,3593,
            92,79,3592,3590,3589,3588,1196,771,772,775,
            142,218,3587,3497,3597,110,111,112,113,2152,
            119,120,121,131,3887,3596,214,416,3595,3594,
            3495,3494,243,244,303,438,440,474,500,504,
            505,779,778,13563,13563,13563,13563,13563,228,231,
            618,13563,13563,13563,13563,13563,228,231,2492,3552,
            40,1351,1333,55,1355,57,58,3552,40,1351,
            1333,55,1355,57,58,13563,13563,13563,13563,13563,
            13563,13563,406,409,414,420,426,3598,3612,401,
            396,3890,393,3288,2094,1351,2425,3493,2238,3492,
            3491,3591,3593,92,79,3592,3590,3589,3588,1196,
            771,772,775,142,218,3587,3497,3597,110,111,
            112,113,2152,119,120,121,131,3887,3596,214,
            416,3595,3594,3495,3494,243,244,303,438,440,
            474,500,504,505,779,778,13563,13563,228,231,
            3619,13563,13563,13563,13563,13563,228,231,3762,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,406,409,414,420,426,
            3598,3612,401,396,3891,392,3238,2094,1351,2425,
            224,2238,225,226,2411,88,92,79,89,91,
            93,94,1196,771,772,775,142,218,77,78,
            216,110,111,112,113,2152,119,120,121,131,
            3343,217,2119,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,13563,2518,2700,195,190,3344,189,3238,2094,
            1351,2425,224,2238,225,226,2411,88,92,79,
            89,91,93,94,1196,771,772,775,142,218,
            77,78,216,110,111,112,113,2152,119,120,
            121,131,3343,217,2119,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,13563,2518,2700,195,190,3345,188,
            3238,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,2152,
            119,120,121,131,3343,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,13563,2518,2700,195,190,
            3346,187,3238,2094,1351,2425,224,2238,225,226,
            2411,88,92,79,89,91,93,94,1196,771,
            772,775,142,218,77,78,216,110,111,112,
            113,2152,119,120,121,131,3343,217,2119,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,13563,2518,2700,
            195,190,3347,186,3288,2094,1351,2425,3493,2238,
            3492,3491,3591,3593,92,79,3592,3590,3589,3588,
            1196,771,772,775,142,218,3587,3497,3597,110,
            111,112,113,2152,119,120,121,131,3773,3596,
            214,416,3595,3594,3495,3494,243,244,303,438,
            440,474,500,504,505,779,778,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,3552,40,
            1351,1333,55,1355,57,58,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,406,409,414,420,
            426,404,3885,403,3288,2094,1351,2425,3493,2238,
            3492,3491,3591,3593,92,79,3592,3590,3589,3588,
            1196,771,772,775,142,218,3587,3497,3597,110,
            111,112,113,2152,119,120,121,131,3773,3596,
            214,416,3595,3594,3495,3494,243,244,303,438,
            440,474,500,504,505,779,778,228,231,2705,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,406,409,414,420,
            426,404,3886,402,3288,2094,1351,2425,3493,2238,
            3492,3491,3591,3593,92,79,3592,3590,3589,3588,
            1196,771,772,775,142,218,3587,3497,3597,110,
            111,112,113,2152,119,120,121,131,3752,3596,
            214,416,3595,3594,3495,3494,243,244,303,438,
            440,474,500,504,505,779,778,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,3552,40,
            1351,1333,55,1355,57,58,412,417,414,420,
            426,3288,2094,1351,2425,3493,2238,3492,3491,3591,
            3593,92,79,3592,3590,3589,3588,1196,771,772,
            775,142,218,3587,3497,3597,110,111,112,113,
            2152,119,120,121,131,3752,3596,214,416,3595,
            3594,3495,3494,243,244,303,438,440,474,500,
            504,505,779,778,232,3478,1351,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,415,13563,228,231,617,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,412,411,414,420,426,3288,2094,
            1351,2425,3493,2238,3492,3491,3591,3593,92,79,
            3592,3590,3589,3588,1196,771,772,775,142,218,
            3587,3497,3597,110,111,112,113,2152,119,120,
            121,131,3752,3596,214,416,3595,3594,3495,3494,
            243,244,303,438,440,474,500,504,505,779,
            778,11058,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,408,72,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,71,491,13563,13563,13563,13563,
            412,410,414,420,426,3238,2094,1351,2425,224,
            2238,225,226,2411,88,92,79,89,91,93,
            94,1196,771,772,775,142,218,77,78,216,
            110,111,112,113,2152,119,120,121,131,3031,
            217,2119,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,206,213,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,3488,13563,407,
            3238,2094,1351,2425,224,2238,225,226,2411,88,
            92,79,89,91,93,94,1196,771,772,775,
            142,218,77,78,216,110,111,112,113,2152,
            119,120,121,131,3031,217,2119,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,206,212,13563,13563,13563,13563,13563,
            3484,13563,3981,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,210,3238,2094,1351,2425,224,2238,225,
            226,2411,88,92,79,89,91,93,94,1196,
            771,772,775,142,218,77,78,216,110,111,
            112,113,2152,119,120,121,131,3031,217,2119,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,206,205,3679,13563,
            13563,1333,818,3398,820,819,1333,818,3679,820,
            819,1333,818,13563,820,819,13563,209,3238,2094,
            1351,2425,224,2238,225,226,2411,88,92,79,
            89,91,93,94,1196,771,772,775,142,218,
            77,78,216,110,111,112,113,2152,119,120,
            121,131,3031,217,2119,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,206,204,3435,3655,13563,626,1333,818,3679,
            820,819,1333,818,64,820,819,821,822,13563,
            202,2808,821,822,3777,837,1351,821,822,3856,
            3679,3711,13563,1333,818,3679,820,819,1333,818,
            13563,820,819,622,2228,4051,837,1351,199,837,
            1351,13563,3114,3114,13563,13563,13563,3114,549,769,
            3114,830,1399,1575,4627,13563,941,1399,1575,697,
            13563,2815,1399,1575,208,13563,672,2700,3114,534,
            13563,13563,13563,13563,596,13563,447,13563,13563,3470,
            1061,13563,13563,821,822,201,3114,13563,821,822,
            636,13563,13563,835,199,837,1351,709,713,1953,
            13563,13563,718,13563,13563,723,13563,13563,13563,821,
            822,13563,13563,13563,821,822,13563,13563,13563,808,
            13563,833,806,736,13563,13563,13563,3732,1399,1575,
            708,712,2211,1399,1575,717,13563,945,722,13563,
            13563,727,3626,1590,13563,834,13563,13563,13563,566,
            13563,13563,13563,13146,1399,1575,735,13563,831,1399,
            1575,13563,13563,3038,1543,542,543,544,545,546,
            547,1383,13563,612,726,13563,663,664,665,13153,
            1734,675,676,1742,681,682,1114,690,691,946,
            1230,589,590,591,592,593,594,1565,13563,612,
            13563,833,663,664,665,13153,1734,675,676,1742,
            681,682,1114,690,691,946,1230,13563,13563,1834,
            812,506,1834,812,13563,13563,13563,13563,13563,441,
            13563,13563,1745,13563,1257,13563,13563,13563,13563,13563,
            13563,10946,13563,587,1787,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,807,442,13563,805,13563,13563,13563,507,
            13563,13563,13563,13563,537,532,13563,539,540,541,
            550,551,1056,554,555,1054,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,535,13563,13563,
            13563,13563,1845,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,3475,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            790,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,635,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,567,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,1844,13563,0,340,342,0,13899,
            335,0,322,329,0,3998,335,0,330,336,
            0
        };
    };

    public final static char baseAction[] = new char[BaseAction0.baseAction0.length + BaseAction1.baseAction1.length];
    {
        int index = 0;
        System.arraycopy(BaseAction0.baseAction0, 0, baseAction, index, BaseAction0.baseAction0.length);
        index += BaseAction0.baseAction0.length;
        System.arraycopy(BaseAction1.baseAction1, 0, baseAction, index, BaseAction1.baseAction1.length);
    };
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static char termCheck[] = {0,
            0,1,2,3,4,0,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,0,55,56,57,58,59,
            60,61,62,0,1,2,0,0,0,3,
            0,66,6,7,8,75,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            0,25,26,0,1,2,96,0,0,2,
            3,0,36,6,7,8,5,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,121,25,26,0,55,56,57,58,59,
            60,61,62,66,67,0,1,2,3,4,
            140,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,91,
            55,56,57,58,59,60,61,62,0,75,
            2,3,67,0,6,7,8,0,5,2,
            3,0,5,6,7,8,126,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,0,25,26,3,0,1,6,7,8,
            0,1,2,3,0,1,2,0,1,2,
            3,4,117,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,94,55,56,57,58,59,60,61,62,
            0,0,105,106,3,80,0,6,7,8,
            109,5,75,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,67,55,56,
            57,58,59,60,61,62,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            0,55,56,57,58,59,60,61,62,0,
            1,2,3,4,0,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,0,55,56,57,58,59,60,
            61,62,0,1,2,3,67,0,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,68,55,56,57,58,59,60,61,62,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,0,55,56,57,58,59,
            60,61,62,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,63,55,56,
            57,58,59,60,61,62,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            0,55,56,57,58,59,60,61,62,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,63,55,56,57,58,59,60,
            61,62,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,0,55,56,57,
            58,59,60,61,62,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,0,
            55,56,57,58,59,60,61,62,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,0,55,56,57,58,59,60,61,
            62,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,0,55,56,57,58,
            59,60,61,62,0,1,2,3,4,0,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,0,55,
            56,57,58,59,60,61,62,0,73,2,
            3,67,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,68,55,56,57,
            58,59,60,61,62,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,0,
            55,56,57,58,59,60,61,62,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,0,55,56,57,58,59,60,61,
            62,0,1,2,3,4,0,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,0,55,56,57,58,
            59,60,61,62,0,73,2,3,67,0,
            1,2,3,4,0,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,68,55,56,57,58,59,60,
            61,62,0,1,2,3,4,82,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,112,55,56,57,
            58,59,60,61,62,0,1,2,3,4,
            0,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,0,
            55,56,57,58,59,60,61,62,0,1,
            2,3,4,0,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,0,55,56,57,58,59,60,61,
            62,0,1,2,3,4,0,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,0,55,56,57,58,
            59,60,61,62,0,1,2,3,4,0,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,0,55,
            56,57,58,59,60,61,62,0,1,2,
            3,4,0,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,0,55,56,57,58,59,60,61,62,
            0,1,2,3,4,0,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,0,55,56,57,58,59,
            60,61,62,0,1,2,3,4,0,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,0,55,56,
            57,58,59,60,61,62,0,1,2,3,
            4,0,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            0,55,56,57,58,59,60,61,62,0,
            1,2,3,4,0,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,0,55,56,57,58,59,60,
            61,62,0,1,2,3,4,0,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,0,55,56,57,
            58,59,60,61,62,0,1,2,3,4,
            0,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,0,
            55,56,57,58,59,60,61,62,0,1,
            2,3,4,0,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,0,55,56,57,58,59,60,61,
            62,0,1,2,3,4,0,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,0,55,56,57,58,
            59,60,61,62,0,1,0,3,4,0,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,0,55,
            56,57,58,59,60,61,62,0,1,0,
            3,4,66,6,7,8,0,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,0,55,56,57,58,59,60,61,62,
            54,73,0,1,67,3,4,0,6,7,
            8,0,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,0,55,56,57,
            58,59,60,61,62,0,1,0,1,67,
            3,4,0,6,7,8,69,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,0,55,56,57,58,59,60,61,62,
            0,75,0,1,67,3,4,0,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,0,0,0,2,
            4,3,5,0,6,7,8,0,5,69,
            3,0,1,6,7,8,85,75,0,0,
            24,81,24,27,28,29,30,31,32,0,
            90,2,3,0,0,6,7,8,96,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,0,25,26,0,24,0,1,
            0,3,4,121,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,0,95,0,97,98,99,4,101,
            102,103,66,94,68,107,66,67,109,76,
            77,78,79,75,105,106,0,0,24,2,
            4,27,28,29,30,31,32,0,0,0,
            1,0,3,4,96,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,66,67,0,69,95,72,97,
            98,99,0,101,102,103,0,69,70,0,
            1,73,3,4,75,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,68,0,1,2,130,66,67,
            75,0,1,67,3,4,67,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,0,1,0,3,4,
            3,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,0,
            1,0,3,4,120,6,7,8,0,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,0,0,2,2,0,1,5,
            3,4,0,6,7,8,67,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,0,0,1,3,0,1,0,3,4,
            67,6,7,8,67,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,0,
            0,2,3,0,5,2,3,0,1,67,
            3,4,67,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,0,1,0,
            3,4,0,6,7,8,66,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,0,0,2,
            3,0,0,6,7,8,0,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,69,25,26,0,73,2,3,0,1,
            2,0,1,2,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,0,25,
            26,0,0,2,0,0,2,0,3,4,
            3,6,7,8,9,0,0,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,0,54,0,89,33,34,
            35,94,37,0,0,0,2,66,67,4,
            0,100,105,106,9,5,55,56,57,58,
            59,60,61,62,0,0,1,93,94,0,
            89,67,68,92,69,73,71,72,9,105,
            106,76,77,78,79,69,81,0,24,2,
            85,86,0,88,143,0,91,81,100,54,
            93,9,66,69,70,69,90,73,63,64,
            65,96,69,70,69,70,71,72,54,74,
            0,76,77,78,79,0,81,63,64,65,
            85,86,67,88,70,90,91,93,74,95,
            71,97,98,99,100,101,102,103,104,54,
            116,107,108,66,110,111,0,113,63,64,
            65,0,75,71,3,0,1,6,7,8,
            126,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,141,25,26,144,0,
            70,147,3,73,69,6,7,8,73,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,0,25,26,3,0,0,6,
            7,8,66,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,0,25,26,
            3,0,1,6,7,8,0,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,0,25,26,0,4,2,3,0,0,
            9,0,1,4,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,0,25,
            26,3,24,76,77,78,79,0,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,66,25,26,54,0,0,2,2,
            0,0,2,2,63,64,65,0,82,0,
            69,70,71,72,0,74,2,76,77,78,
            79,72,81,0,1,0,85,86,0,88,
            0,3,91,3,6,7,8,93,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,0,0,0,3,0,4,6,7,
            8,93,9,66,67,68,0,67,2,3,
            0,0,6,7,8,66,75,0,69,0,
            66,0,0,1,2,33,34,35,0,75,
            38,39,4,0,93,2,95,9,97,98,
            99,100,101,102,103,104,109,54,83,112,
            96,110,111,0,113,2,63,64,65,122,
            123,124,69,69,71,72,0,0,2,76,
            77,78,79,0,81,81,54,0,85,86,
            0,4,54,90,90,0,9,2,66,67,
            69,63,64,65,83,84,86,69,87,71,
            72,0,81,0,76,77,78,79,0,81,
            91,0,0,85,108,0,83,84,90,66,
            87,68,0,131,132,133,134,135,136,137,
            138,54,66,67,54,68,0,0,2,0,
            63,64,65,0,64,65,69,4,71,72,
            0,1,9,76,77,78,79,54,81,86,
            75,94,85,86,0,112,63,64,65,0,
            69,70,0,70,66,67,4,74,93,68,
            95,9,97,98,99,100,101,102,103,104,
            54,76,77,78,79,110,111,54,113,0,
            0,0,66,0,4,94,63,64,65,9,
            0,0,69,0,71,72,0,116,54,76,
            77,78,79,0,81,2,54,63,64,65,
            0,0,1,90,4,63,64,65,0,9,
            24,69,4,71,72,0,107,108,76,77,
            78,79,0,81,54,0,1,85,0,0,
            0,2,4,63,64,65,0,9,67,69,
            67,71,72,0,0,1,76,77,78,79,
            0,81,2,3,54,75,6,7,8,76,
            77,78,79,63,64,65,0,0,75,0,
            4,71,72,4,0,9,76,77,78,79,
            72,80,54,0,104,0,0,0,2,4,
            0,63,64,65,9,66,67,68,118,71,
            72,0,1,0,76,77,78,79,0,0,
            66,89,68,0,92,2,73,73,89,150,
            54,92,0,54,80,89,82,24,92,63,
            64,65,63,64,65,0,1,71,72,54,
            0,72,68,0,114,95,0,1,63,64,
            65,0,66,67,68,0,71,72,0,76,
            77,78,79,54,0,0,76,77,78,79,
            0,0,63,64,65,89,54,0,92,70,
            9,68,0,74,0,63,64,65,75,122,
            123,124,70,9,54,0,74,54,148,149,
            0,151,152,63,64,65,63,64,65,54,
            70,0,54,70,74,80,0,74,63,64,
            65,63,64,65,54,70,80,0,70,74,
            0,4,74,63,64,65,54,0,0,75,
            70,0,71,2,74,63,64,65,0,54,
            0,0,70,145,89,71,74,92,63,64,
            65,24,85,0,0,70,0,0,104,74,
            54,0,1,9,0,0,1,66,0,63,
            64,65,118,83,54,0,70,87,0,1,
            74,0,54,63,64,65,0,0,2,72,
            70,63,64,65,74,54,0,66,70,0,
            4,146,74,0,63,64,65,54,0,1,
            54,70,0,0,0,74,63,64,65,63,
            64,65,54,70,0,71,70,74,88,68,
            74,63,64,65,73,54,0,1,70,0,
            0,80,74,82,63,64,65,0,83,85,
            54,70,0,54,68,74,0,0,80,63,
            64,65,63,64,65,0,54,2,72,70,
            5,0,0,74,0,88,64,65,0,0,
            2,2,70,5,5,120,74,0,80,76,
            77,78,79,54,0,0,2,83,84,5,
            0,87,63,64,65,0,0,83,84,73,
            54,87,0,127,2,9,80,5,82,63,
            64,65,0,76,77,78,79,0,76,77,
            78,79,0,68,0,1,0,1,0,1,
            83,84,0,0,87,0,68,68,0,4,
            0,24,0,0,83,84,4,9,87,9,
            0,89,68,0,92,2,3,0,0,2,
            83,84,4,0,87,2,0,71,83,84,
            68,5,87,83,84,0,0,87,83,84,
            5,69,87,66,0,9,0,0,4,0,
            0,69,0,81,4,9,9,0,9,0,
            0,68,0,81,80,0,80,72,80,71,
            0,71,80,0,72,82,0,27,0,1,
            0,1,0,80,0,0,0,0,0,66,
            72,0,5,0,68,0,3,0,0,1,
            0,1,0,68,0,1,0,71,24,0,
            1,0,1,0,0,0,72,71,71,0,
            71,0,0,0,1,115,5,5,69,0,
            68,0,80,68,117,0,5,80,128,0,
            0,0,1,73,0,0,73,0,0,73,
            0,66,0,67,66,0,0,5,0,68,
            5,5,0,1,0,1,0,0,0,3,
            3,69,0,5,24,80,0,80,0,119,
            0,75,0,68,0,5,0,5,75,5,
            0,5,0,0,75,66,0,0,0,0,
            0,0,0,5,0,66,5,125,73,5,
            0,0,0,0,0,68,5,0,5,5,
            0,0,0,75,0,0,0,0,0,115,
            0,86,88,0,0,0,0,0,5,0,
            82,5,5,0,5,73,0,69,0,73,
            0,5,0,0,1,0,0,5,66,69,
            5,5,66,0,1,125,0,1,75,0,
            0,0,0,73,5,3,5,0,68,80,
            68,0,0,1,82,0,0,0,0,0,
            5,5,5,50,5,0,66,0,0,82,
            0,66,0,0,0,85,0,0,86,88,
            0,86,85,0,88,91,82,0,5,91,
            0,73,5,73,0,5,0,0,0,5,
            0,5,5,5,0,5,139,67,0,0,
            0,0,0,0,0,0,5,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,84,0,0,0,0,0,69,0,0,
            82,0,0,66,0,0,0,82,0,82,
            0,0,82,0,0,0,84,0,0,85,
            0,88,86,0,0,0,0,0,0,0,
            119,0,0,0,0,0,0,69,0,0,
            0,0,0,0,0,73,0,0,0,0,
            0,0,0,0,84,82,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,114,0,
            0,0,142,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,129,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0
        };
    };
    public final static char termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            13563,715,14088,715,715,13563,715,715,715,715,
            715,715,715,715,715,715,715,715,715,715,
            715,715,715,715,715,715,715,715,715,715,
            715,715,715,715,715,715,715,715,715,715,
            715,715,715,715,715,715,715,715,715,715,
            715,715,715,715,538,715,715,715,715,715,
            715,715,715,13563,13206,14088,13563,13563,588,3024,
            13563,14111,13599,3023,14343,715,13613,13614,13615,13616,
            13617,13608,13606,13609,13607,13605,1241,13610,13612,13611,
            13563,1088,1229,13563,13136,14088,715,13563,13563,14088,
            13597,13563,14295,13599,14344,14343,14365,13613,13614,13615,
            13616,13617,13608,13606,13609,13607,13605,1241,13610,13612,
            13611,715,1088,1229,13563,14314,14316,14324,14326,14315,
            14317,14325,14327,14255,1756,13563,7626,14088,13597,13667,
            13189,13599,14344,14343,12932,13613,13614,13615,13616,13617,
            13608,13606,13609,13607,13605,2424,13610,13612,13611,13663,
            2272,2376,13661,13662,13665,13666,13669,13668,972,906,
            3719,13596,12857,13163,1719,5462,2683,14065,2502,2506,
            14066,2144,1262,1253,2423,2086,6346,2373,1057,2935,
            755,755,755,755,755,755,755,755,13563,1978,
            14088,13597,1406,13563,13599,14344,14343,13563,13792,14088,
            811,707,803,811,811,811,13547,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,13563,811,811,13597,143,135,13599,14344,14343,
            13563,2083,14088,1612,13563,1353,14088,13563,7626,14088,
            13597,13667,9298,13599,14344,14343,12932,13613,13614,13615,
            13616,13617,13608,13606,13609,13607,13605,2424,13610,13612,
            13611,13663,2272,2376,13661,13662,13665,13666,13669,13668,
            972,906,3719,13596,12857,13163,1719,5313,2683,14065,
            2502,2506,14066,2144,1262,1253,2423,2086,6346,2207,
            1057,14376,755,755,755,755,755,755,755,755,
            13563,61,14377,14378,13597,40,13563,13599,14344,14343,
            13184,13623,514,13563,7626,14088,13597,13667,136,13599,
            14344,14343,12932,13613,13614,13615,13616,13617,13608,13606,
            13609,13607,13605,2424,13610,13612,13611,13663,2272,2376,
            13661,13662,13665,13666,13669,13668,972,906,3719,13596,
            12857,13163,1719,5462,2683,14065,2502,2506,14066,2144,
            1262,1253,2423,2086,6346,2373,1057,1332,755,755,
            755,755,755,755,755,755,13563,7626,14088,13597,
            13667,136,13599,14344,14343,12932,13613,13614,13615,13616,
            13617,13608,13606,13609,13607,13605,2424,13610,13612,13611,
            13663,2272,2376,13661,13662,13665,13666,13669,13668,972,
            906,3719,13596,12857,13163,1719,5462,2683,14065,2502,
            2506,14066,2144,1262,1253,2423,2086,6346,2373,1057,
            135,755,755,755,755,755,755,755,755,13563,
            7626,14088,13597,13667,634,13599,14344,14343,12932,13613,
            13614,13615,13616,13617,13608,13606,13609,13607,13605,2424,
            13610,13612,13611,13663,2272,2376,13661,13662,13665,13666,
            13669,13668,972,906,3719,13596,12857,13163,1719,5462,
            2683,14065,2502,2506,14066,2144,1262,1253,2423,2086,
            6346,2373,1057,804,755,755,755,755,755,755,
            755,755,13563,1815,14088,1612,1406,13563,7626,14088,
            13597,13667,136,13599,14344,14343,12932,13613,13614,13615,
            13616,13617,13608,13606,13609,13607,13605,2424,13610,13612,
            13611,13663,2272,2376,13661,13662,13665,13666,13669,13668,
            972,906,3719,13596,12857,13163,1719,5462,2683,14065,
            2502,2506,14066,2144,1262,1253,2423,2086,6346,2373,
            1057,13209,755,755,755,755,755,755,755,755,
            13563,7626,14088,13597,13667,136,13599,14344,14343,12932,
            13613,13614,13615,13616,13617,13608,13606,13609,13607,13605,
            2424,13610,13612,13611,13663,2272,2376,13661,13662,13665,
            13666,13669,13668,972,906,3719,13596,12857,13163,1719,
            5462,2683,14065,2502,2506,14066,2144,1262,1253,2423,
            2086,6346,2373,1057,13563,755,755,755,755,755,
            755,755,755,13563,7626,14088,13597,13667,136,13599,
            14344,14343,12932,13613,13614,13615,13616,13617,13608,13606,
            13609,13607,13605,2424,13610,13612,13611,13663,2272,2376,
            13661,13662,13665,13666,13669,13668,972,906,3719,13596,
            12857,13163,1719,5462,2683,14065,2502,2506,14066,2144,
            1262,1253,2423,2086,6346,2373,1057,1947,755,755,
            755,755,755,755,755,755,13563,7626,14088,13597,
            13667,136,13599,14344,14343,12932,13613,13614,13615,13616,
            13617,13608,13606,13609,13607,13605,2424,13610,13612,13611,
            13663,2272,2376,13661,13662,13665,13666,13669,13668,972,
            906,3719,13596,12857,13163,1719,5462,2683,14065,2502,
            2506,14066,2144,1262,1253,2423,2086,6346,2373,1057,
            642,755,755,755,755,755,755,755,755,13563,
            7626,14088,13597,13667,13685,13599,14344,14343,12932,13613,
            13614,13615,13616,13617,13608,13606,13609,13607,13605,2424,
            13610,13612,13611,13663,2272,2376,13661,13662,13665,13666,
            13669,13668,972,906,3719,13596,12857,13163,1719,5462,
            2683,14065,2502,2506,14066,2144,1262,1253,2423,2086,
            6346,2373,1057,1807,755,755,755,755,755,755,
            755,755,13563,7626,14088,13597,13667,136,13599,14344,
            14343,12932,13613,13614,13615,13616,13617,13608,13606,13609,
            13607,13605,2424,13610,13612,13611,13663,2272,2376,13661,
            13662,13665,13666,13669,13668,972,906,3719,13596,12857,
            13163,1719,5462,2683,14065,2502,2506,14066,2144,1262,
            1253,2423,2086,6346,2373,1057,700,755,755,755,
            755,755,755,755,755,13563,7626,14088,13597,13667,
            136,13599,14344,14343,12932,13613,13614,13615,13616,13617,
            13608,13606,13609,13607,13605,2424,13610,13612,13611,13663,
            2272,2376,13661,13662,13665,13666,13669,13668,972,906,
            3719,13596,12857,13163,1719,5462,2683,14065,2502,2506,
            14066,2144,1262,1253,2423,2086,6346,2373,1057,13563,
            755,755,755,755,755,755,755,755,13563,7626,
            14088,13597,13667,136,13599,14344,14343,12932,13613,13614,
            13615,13616,13617,13608,13606,13609,13607,13605,2424,13610,
            13612,13611,13663,2272,2376,13661,13662,13665,13666,13669,
            13668,972,906,3719,13596,12857,13163,1719,5462,2683,
            14065,2502,2506,14066,2144,1262,1253,2423,2086,6346,
            2373,1057,13563,755,755,755,755,755,755,755,
            755,13563,7626,14088,13597,13667,136,13599,14344,14343,
            12932,13613,13614,13615,13616,13617,13608,13606,13609,13607,
            13605,2424,13610,13612,13611,13663,2272,2376,13661,13662,
            13665,13666,13669,13668,972,906,3719,13596,12857,13163,
            1719,5462,2683,14065,2502,2506,14066,2144,1262,1253,
            2423,2086,6346,2373,1057,797,755,755,755,755,
            755,755,755,755,13563,7626,14088,13597,13667,13563,
            13599,14344,14343,12932,13613,13614,13615,13616,13617,13608,
            13606,13609,13607,13605,2424,13610,13612,13611,13663,2272,
            2376,13661,13662,13665,13666,13669,13668,972,906,3719,
            13596,12857,13163,1719,5462,2683,14065,2502,2506,14066,
            2144,1262,1253,2423,2086,6346,2373,1057,13563,755,
            755,755,755,755,755,755,755,13563,1348,14088,
            2214,1406,13563,7626,14088,13597,13667,136,13599,14344,
            14343,12932,13613,13614,13615,13616,13617,13608,13606,13609,
            13607,13605,2424,13610,13612,13611,13663,2272,2376,13661,
            13662,13665,13666,13669,13668,972,906,3719,13596,12857,
            13163,1719,5462,2683,14065,2502,2506,14066,2144,1262,
            1253,2423,2086,6346,2373,1057,11429,755,755,755,
            755,755,755,755,755,13563,7626,14088,13597,13667,
            136,13599,14344,14343,12932,13613,13614,13615,13616,13617,
            13608,13606,13609,13607,13605,2424,13610,13612,13611,13663,
            2272,2376,13661,13662,13665,13666,13669,13668,972,906,
            3719,13596,12857,13163,1719,5462,2683,14065,2502,2506,
            14066,2144,1262,1253,2423,2086,6346,2373,1057,13563,
            755,755,755,755,755,755,755,755,13563,7626,
            14088,13597,13667,136,13599,14344,14343,12932,13613,13614,
            13615,13616,13617,13608,13606,13609,13607,13605,2424,13610,
            13612,13611,13663,2272,2376,13661,13662,13665,13666,13669,
            13668,972,906,3719,13596,12857,13163,1719,5462,2683,
            14065,2502,2506,14066,2144,1262,1253,2423,2086,6346,
            2373,1057,13563,755,755,755,755,755,755,755,
            755,13563,311,2229,311,311,13563,311,311,311,
            311,311,311,311,311,311,311,311,311,311,
            311,311,311,311,311,311,311,311,311,311,
            311,311,311,311,311,311,311,311,311,311,
            311,311,311,311,311,311,311,311,311,311,
            311,311,311,311,311,298,311,311,311,311,
            311,311,311,311,13563,11322,14088,14386,311,13563,
            7890,14088,13597,13667,711,13599,14344,14343,12932,13613,
            13614,13615,13616,13617,13608,13606,13609,13607,13605,2424,
            13610,13612,13611,13663,2272,2376,13661,13662,13665,13666,
            13669,13668,972,906,3719,13596,12857,13163,1719,5462,
            2683,14065,2502,2506,14066,2144,1262,1253,2423,2086,
            6346,2373,1057,3747,755,755,755,755,755,755,
            755,755,13563,7626,14088,13597,13667,7362,13599,14344,
            14343,12932,13613,13614,13615,13616,13617,13608,13606,13609,
            13607,13605,2424,13610,13612,13611,13663,2272,2376,13661,
            13662,13665,13666,13669,13668,972,906,3719,13596,12857,
            13163,1719,5462,2683,14065,2502,2506,14066,2144,1262,
            1253,2423,2086,6346,2373,1057,13185,755,755,755,
            755,755,755,755,755,13563,7626,14088,13597,13667,
            13563,13599,14344,14343,12932,13613,13614,13615,13616,13617,
            13608,13606,13609,13607,13605,2424,13610,13612,13611,13663,
            2272,2376,13661,13662,13665,13666,13669,13668,972,906,
            3719,13596,12857,13163,1719,5462,2683,14065,2502,2506,
            14066,2144,1262,1253,2423,2086,6346,2373,1057,13563,
            755,755,755,755,755,755,755,755,13563,7626,
            14088,13597,13667,13563,13599,14344,14343,12932,13613,13614,
            13615,13616,13617,13608,13606,13609,13607,13605,2424,13610,
            13612,13611,13663,2272,2376,13661,13662,13665,13666,13669,
            13668,972,906,3719,13596,12857,13163,1719,5462,2683,
            14065,2502,2506,14066,2144,1262,1253,2423,2086,6346,
            2373,1057,13563,755,755,755,755,755,755,755,
            755,13563,7626,14088,13597,13667,13563,13599,14344,14343,
            12932,13613,13614,13615,13616,13617,13608,13606,13609,13607,
            13605,2424,13610,13612,13611,13663,2272,2376,13661,13662,
            13665,13666,13669,13668,972,906,3719,13596,12857,13163,
            1719,5462,2683,14065,2502,2506,14066,2144,1262,1253,
            2423,2086,6346,2373,1057,13563,755,755,755,755,
            755,755,755,755,13563,7626,14088,13597,13667,13563,
            13599,14344,14343,12932,13613,13614,13615,13616,13617,13608,
            13606,13609,13607,13605,2424,13610,13612,13611,13663,2272,
            2376,13661,13662,13665,13666,13669,13668,972,906,3719,
            13596,12857,13163,1719,5462,2683,14065,2502,2506,14066,
            2144,1262,1253,2423,2086,6346,2373,1057,13563,755,
            755,755,755,755,755,755,755,13563,7626,14088,
            13597,13667,13563,13599,14344,14343,12932,13613,13614,13615,
            13616,13617,13608,13606,13609,13607,13605,2424,13610,13612,
            13611,13663,2272,2376,13661,13662,13665,13666,13669,13668,
            972,906,3719,13596,12857,13163,1719,5462,2683,14065,
            2502,2506,14066,2144,1262,1253,2423,2086,6346,2373,
            1057,13563,755,755,755,755,755,755,755,755,
            13563,7626,14088,13597,13667,13563,13599,14344,14343,12932,
            13613,13614,13615,13616,13617,13608,13606,13609,13607,13605,
            2424,13610,13612,13611,13663,2272,2376,13661,13662,13665,
            13666,13669,13668,972,906,3719,13596,12857,13163,1719,
            5462,2683,14065,2502,2506,14066,2144,1262,1253,2423,
            2086,6346,2373,1057,13563,755,755,755,755,755,
            755,755,755,13563,7626,14088,13597,13667,13563,13599,
            14344,14343,12932,13613,13614,13615,13616,13617,13608,13606,
            13609,13607,13605,2424,13610,13612,13611,13663,2272,2376,
            13661,13662,13665,13666,13669,13668,972,906,3719,13596,
            12857,13163,1719,5462,2683,14065,2502,2506,14066,2144,
            1262,1253,2423,2086,6346,2373,1057,13563,755,755,
            755,755,755,755,755,755,13563,9826,14088,13597,
            13667,13563,13599,14344,14343,12932,13613,13614,13615,13616,
            13617,13608,13606,13609,13607,13605,2424,13610,13612,13611,
            13663,2272,2376,13661,13662,13665,13666,13669,13668,972,
            906,3719,13596,12857,13163,1719,5462,2683,14065,2502,
            2506,14066,2144,1262,1253,2423,2086,6346,2373,1057,
            13563,755,755,755,755,755,755,755,755,13563,
            7626,14088,13597,13667,13563,13599,14344,14343,12932,13613,
            13614,13615,13616,13617,13608,13606,13609,13607,13605,2424,
            13610,13612,13611,13663,2272,2376,13661,13662,13665,13666,
            13669,13668,972,906,3719,13596,12857,13163,1719,5462,
            2683,14065,2502,2506,14066,2144,1262,1253,2423,2086,
            6346,2373,1057,13563,755,755,755,755,755,755,
            755,755,13563,7626,14088,13597,13667,13563,13599,14344,
            14343,12932,13613,13614,13615,13616,13617,13608,13606,13609,
            13607,13605,2424,13610,13612,13611,13663,2272,2376,13661,
            13662,13665,13666,13669,13668,972,906,3719,13596,12857,
            13163,1719,5462,2683,14065,2502,2506,14066,2144,1262,
            1253,2423,2086,6346,2373,1057,13563,755,755,755,
            755,755,755,755,755,13563,7626,14088,13597,13667,
            13563,13599,14344,14343,12932,13613,13614,13615,13616,13617,
            13608,13606,13609,13607,13605,2424,13610,13612,13611,13663,
            2272,2376,13661,13662,13665,13666,13669,13668,972,906,
            3719,13596,12857,13163,1719,5462,2683,14065,2502,2506,
            14066,2144,1262,1253,2423,2086,6346,2373,1057,13563,
            755,755,755,755,755,755,755,755,13563,7626,
            14088,13597,13667,13563,13599,14344,14343,12932,13613,13614,
            13615,13616,13617,13608,13606,13609,13607,13605,2424,13610,
            13612,13611,13663,2272,2376,13661,13662,13665,13666,13669,
            13668,972,906,3719,13596,12857,13163,1719,5462,2683,
            14065,2502,2506,14066,2144,1262,1253,2423,2086,6346,
            2373,1057,13563,755,755,755,755,755,755,755,
            755,13563,10706,14088,13597,13667,13563,13599,14344,14343,
            12932,13613,13614,13615,13616,13617,13608,13606,13609,13607,
            13605,2424,13610,13612,13611,13663,2272,2376,13661,13662,
            13665,13666,13669,13668,972,906,3719,13596,12857,13163,
            1719,5462,2683,14065,2502,2506,14066,2144,1262,1253,
            2423,2086,6346,2373,1057,13563,755,755,755,755,
            755,755,755,755,260,7626,513,13597,13667,13563,
            13599,14344,14343,12932,13613,13614,13615,13616,13617,13608,
            13606,13609,13607,13605,2424,13610,13612,13611,13663,2272,
            2376,13661,13662,13665,13666,13669,13668,972,906,3719,
            13596,12857,13163,1719,5462,2683,14065,2502,2506,14066,
            2144,1262,1253,2423,2086,6346,2373,1057,13563,755,
            755,755,755,755,755,755,755,220,9210,13563,
            13597,18710,14075,13599,14344,14343,13563,13613,13614,13615,
            13616,13617,13608,13606,13609,13607,13605,2424,13610,13612,
            13611,13663,2272,2376,13661,13662,13665,13666,13669,13668,
            972,906,3719,13596,12566,13163,1719,5718,2683,14065,
            2502,2506,14066,2144,1262,1253,2423,2086,6346,2373,
            1057,13563,755,755,755,755,755,755,755,755,
            2378,11421,220,9210,1406,13597,18710,688,13599,14344,
            14343,13563,13613,13614,13615,13616,13617,13608,13606,13609,
            13607,13605,2424,13610,13612,13611,13663,2272,2376,13661,
            13662,13665,13666,13669,13668,972,906,3719,13596,12566,
            13163,1719,5718,2683,14065,2502,2506,14066,2144,1262,
            1253,2423,2086,6346,2373,1057,13563,755,755,755,
            755,755,755,755,755,13563,1514,220,9210,1406,
            13597,18710,13563,13599,14344,14343,7802,13613,13614,13615,
            13616,13617,13608,13606,13609,13607,13605,2424,13610,13612,
            13611,13663,2272,2376,13661,13662,13665,13666,13669,13668,
            972,906,3719,13596,12566,13163,1719,6253,2683,14065,
            2502,2506,14066,2144,1262,1253,2423,2086,6346,2373,
            1057,160,755,755,755,755,755,755,755,755,
            166,14084,755,7626,1406,13597,13667,13563,13599,14344,
            14343,12932,13613,13614,13615,13616,13617,13608,13606,13609,
            13607,13605,2424,13610,13612,13611,13663,2272,2376,13661,
            13662,13665,13666,13669,13668,972,906,3719,13596,12857,
            13163,1719,5313,2683,14065,2502,2506,14066,2144,1262,
            1253,2423,2086,6346,2207,1057,239,13563,13563,14088,
            13667,13597,13830,13563,13599,14344,14343,468,13622,170,
            13597,13563,1535,13599,14344,14343,164,719,13563,463,
            13663,170,13663,13661,13662,13665,13666,13669,13668,13563,
            170,14088,811,13563,13563,811,811,811,719,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,172,811,811,13563,13663,755,7626,
            13563,13597,13667,13192,13599,14344,14343,12932,13613,13614,
            13615,13616,13617,13608,13606,13609,13607,13605,2424,13610,
            13612,13611,13663,2272,2376,13661,13662,13665,13666,13669,
            13668,972,906,3719,13596,12857,13163,1719,5313,2683,
            14065,2502,2506,14066,2144,1262,1253,2423,2086,6346,
            2207,1057,13563,14359,13563,1793,14233,14232,13667,14357,
            14358,13141,2663,14376,1812,3337,14248,1406,9034,178,
            178,178,178,512,14377,14378,192,13563,13663,14088,
            198,13661,13662,13665,13666,13669,13668,816,443,755,
            7626,13563,13597,13667,512,13599,14344,14343,12932,13613,
            13614,13615,13616,13617,13608,13606,13609,13607,13605,2424,
            13610,13612,13611,13663,2272,2376,13661,13662,13665,13666,
            13669,13668,972,906,3719,13596,12857,13163,1719,5462,
            2683,14065,2502,2506,14066,2144,1262,1253,2423,2086,
            6346,2373,1057,14234,1406,13563,7538,14359,198,1793,
            14233,14232,13563,14357,14358,13141,13563,9474,8594,755,
            7626,11981,13597,13667,81,13599,14344,14343,12932,13613,
            13614,13615,13616,13617,13608,13606,13609,13607,13605,2424,
            13610,13612,13611,13663,2272,2376,13661,13662,13665,13666,
            13669,13668,972,906,3719,13596,12857,13163,1719,5462,
            2683,14065,2502,2506,14066,2144,1262,1253,2423,2086,
            6346,2373,1057,2660,13563,6894,14088,3133,14119,2286,
            13658,755,7626,2840,13597,13667,1406,13599,14344,14343,
            12932,13613,13614,13615,13616,13617,13608,13606,13609,13607,
            13605,2424,13610,13612,13611,13663,2272,2376,13661,13662,
            13665,13666,13669,13668,972,906,3719,13596,12857,13163,
            1719,5462,2683,14065,2502,2506,14066,2144,1262,1253,
            2423,2086,6346,2373,1057,755,7626,13563,3235,13667,
            1612,13599,14344,14343,12932,13613,13614,13615,13616,13617,
            13608,13606,13609,13607,13605,2424,13610,13612,13611,13663,
            2272,2376,13661,13662,13665,13666,13669,13668,972,906,
            3719,13596,12857,13163,1719,5462,2683,14065,2502,2506,
            14066,2144,1262,1253,2423,2086,6346,2373,1057,755,
            9210,13563,13597,13667,3232,13599,14344,14343,13563,13613,
            13614,13615,13616,13617,13608,13606,13609,13607,13605,2424,
            13610,13612,13611,13663,2272,2376,13661,13662,13665,13666,
            13669,13668,972,906,3719,13596,12566,13163,1719,5313,
            2683,14065,2502,2506,14066,2144,1262,1253,2423,2086,
            6346,2373,1057,13563,13563,14088,14088,755,9210,14320,
            13597,13667,13563,13599,14344,14343,1406,13613,13614,13615,
            13616,13617,13608,13606,13609,13607,13605,2424,13610,13612,
            13611,13663,2272,2376,13661,13662,13665,13666,13669,13668,
            972,906,3719,13596,12566,13163,1719,6253,2683,14065,
            2502,2506,14066,2144,1262,1253,2423,2086,6346,2373,
            1057,13563,13563,1616,3231,755,9210,13563,13597,13667,
            1406,13599,14344,14343,1406,13613,13614,13615,13616,13617,
            13608,13606,13609,13607,13605,2424,13610,13612,13611,13663,
            2272,2376,13661,13662,13665,13666,13669,13668,972,906,
            3719,13596,12566,13163,1719,5718,2683,14065,2502,2506,
            14066,2144,1262,1253,2423,2086,6346,2373,1057,746,
            13563,748,19203,13563,748,14088,14391,755,7626,10935,
            13597,13667,1406,13599,14344,14343,12932,13613,13614,13615,
            13616,13617,13608,13606,13609,13607,13605,2424,13610,13612,
            13611,13663,2272,2376,13661,13662,13665,13666,13669,13668,
            972,906,3719,13596,12857,13163,1719,5462,2683,14065,
            2502,2506,14066,2144,1262,1253,2423,755,9210,13563,
            13597,13667,13563,13599,14344,14343,14096,13613,13614,13615,
            13616,13617,13608,13606,13609,13607,13605,2424,13610,13612,
            13611,13663,2272,2376,13661,13662,13665,13666,13669,13668,
            972,906,3719,13596,12566,13163,1719,5462,2683,14065,
            2502,2506,14066,2144,1262,1253,2423,13563,615,14088,
            811,13563,13563,811,811,811,13563,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,7714,811,811,13563,11314,14088,811,13563,1961,
            14088,13563,13206,14088,811,811,811,811,811,811,
            811,811,811,811,811,811,811,811,13563,811,
            811,13563,13563,14088,13563,755,14088,13563,13597,13577,
            14389,13599,14344,14343,13576,724,13563,13613,13614,13615,
            13616,13617,13608,13606,13609,13607,13605,1241,13610,13612,
            13611,13664,1088,1229,13563,13180,13563,1775,1038,927,
            3719,14376,13566,508,13563,141,14088,568,568,199,
            13563,13070,14377,14378,191,13783,756,756,756,756,
            756,756,756,756,434,13563,1850,811,14376,180,
            568,616,11881,568,13573,11773,13575,13578,190,14377,
            14378,13572,13569,13571,13570,11635,13574,13563,13664,14088,
            13564,13567,13563,13568,2239,207,13565,11564,2101,215,
            14390,5401,14223,13841,13842,8242,5643,1494,215,215,
            215,13228,10002,9914,171,215,191,199,90,215,
            13563,179,179,179,179,13563,171,90,90,90,
            165,159,3041,153,90,171,147,2371,90,792,
            190,792,792,792,1820,792,792,792,1524,215,
            13843,792,13236,2515,957,978,13563,2008,215,215,
            215,13563,513,5806,13597,13563,1616,13599,14344,14343,
            531,13613,13614,13615,13616,13617,13608,13606,13609,13607,
            13605,1241,13610,13612,13611,13156,1088,1229,1788,13563,
            8594,1506,2835,11981,8154,13599,14344,14343,11789,13613,
            13614,13615,13616,13617,13608,13606,13609,13607,13605,1241,
            13610,13612,13611,728,1088,1229,13597,13563,13563,13599,
            14344,14343,14236,13613,13614,13615,13616,13617,13608,13606,
            13609,13607,13605,1241,13610,13612,13611,256,1088,1229,
            3625,13563,1850,13599,14344,14343,13563,13613,13614,13615,
            13616,13617,13608,13606,13609,13607,13605,1241,13610,13612,
            13611,345,1088,1229,13563,405,14088,14389,35,13563,
            397,13563,13206,13080,13613,13614,13615,13616,13617,13608,
            13606,13609,13607,13605,1241,13610,13612,13611,13563,1088,
            1229,14389,13600,12304,12242,12180,12118,13563,13613,13614,
            13615,13616,13617,13608,13606,13609,13607,13605,1241,13610,
            13612,13611,1600,1088,1229,215,13563,13563,14088,14088,
            13563,13563,14088,14088,215,215,215,13563,9650,13563,
            377,215,397,405,13563,215,14088,385,385,385,
            385,13005,377,13563,3499,309,371,365,13563,359,
            13563,13597,353,14380,13599,14344,14343,14390,13613,13614,
            13615,13616,13617,13608,13606,13609,13607,13605,13591,13610,
            13612,13611,755,153,167,13597,13563,199,13599,14344,
            14343,14390,191,702,702,13167,13563,1544,14088,13597,
            154,13563,13599,14344,14343,14224,2236,13563,8946,144,
            3631,372,13563,13206,14088,1038,927,3719,159,513,
            3198,3199,199,13563,2371,14088,792,191,792,792,
            792,1820,792,792,792,1524,702,215,5971,702,
            513,957,978,13563,2008,14088,215,215,215,702,
            702,702,171,11635,191,199,13563,13563,14088,179,
            179,179,179,13563,171,11564,13180,359,165,159,
            493,405,215,171,5643,13563,397,14088,789,789,
            376,215,215,215,1870,13885,158,171,3750,191,
            199,276,376,208,179,179,179,179,13563,171,
            146,13563,13563,165,1395,786,312,312,171,600,
            9122,1175,13563,14039,14040,14041,14042,14043,14044,13857,
            13858,215,14241,1406,1550,1065,13563,13563,14088,579,
            215,215,215,165,1320,14057,377,199,397,405,
            13563,1577,191,385,385,385,385,214,377,6173,
            2372,8066,371,365,199,2933,214,214,214,13563,
            13841,13842,365,214,14115,2289,405,214,2371,896,
            792,397,792,792,792,1820,792,792,792,1524,
            13180,12304,12242,12180,12118,957,978,215,2008,651,
            371,13563,536,13563,405,7070,215,215,215,397,
            629,13563,171,174,191,199,609,13843,215,179,
            179,179,179,13563,171,14088,215,215,215,215,
            171,13563,3906,171,199,215,215,215,194,191,
            13663,377,13080,397,405,13563,14144,14145,385,385,
            385,385,573,377,215,13563,6638,371,377,13563,
            13563,14088,405,215,215,215,574,397,1406,377,
            1382,397,405,34,143,135,385,385,385,385,
            13563,377,14088,13597,215,620,13599,14344,14343,12304,
            12242,12180,12118,215,215,215,179,696,14011,191,
            199,191,199,199,62,191,179,179,179,179,
            13005,891,215,173,1524,385,13563,13563,14088,405,
            378,215,215,215,397,578,578,1799,1211,397,
            405,13563,7978,90,385,385,385,385,13563,431,
            65,1398,2708,13563,2130,14088,11202,11989,578,14213,
            215,578,430,215,40,1398,65,13664,2130,215,
            215,215,215,215,215,13563,4015,191,199,215,
            429,199,1825,428,14061,14204,248,6982,215,215,
            215,13563,577,577,1799,427,397,405,425,12304,
            12242,12180,12118,226,629,559,384,384,384,384,
            424,184,226,226,226,577,225,13563,577,226,
            5401,909,437,226,183,225,225,225,238,14268,
            14267,14266,225,5401,224,436,225,236,14200,14203,
            311,14202,14201,224,224,224,236,236,236,235,
            224,13563,78,236,224,891,435,236,235,235,
            235,78,78,78,77,235,891,193,78,235,
            433,13080,78,77,77,77,94,610,432,512,
            77,13563,5806,14088,77,94,94,94,13563,93,
            148,423,94,2065,1398,5806,94,2130,93,93,
            93,13664,6726,421,182,93,419,13563,1524,93,
            91,143,135,5401,161,455,6894,14351,418,91,
            91,91,1211,15742,89,13563,91,9122,135,4233,
            91,422,88,89,89,89,13563,13563,14088,13005,
            89,88,88,88,89,227,397,14219,88,220,
            405,1198,88,13563,227,227,227,219,606,2237,
            217,227,493,13563,340,227,219,219,219,217,
            217,217,216,219,335,5806,217,219,152,968,
            217,216,216,216,11773,220,143,135,216,413,
            13563,40,216,65,220,220,220,380,4342,6726,
            215,220,379,13667,2382,220,405,13563,41,215,
            215,215,13667,13667,13667,13563,1550,14088,405,13667,
            13826,322,561,13667,13563,3136,1320,14057,13563,13563,
            14088,14088,6550,13830,14329,3232,6434,335,891,12015,
            11912,11809,11706,215,13563,336,14088,342,13548,255,
            13563,342,215,215,215,13563,181,2012,13551,11773,
            215,3750,13563,14193,14088,5401,40,3132,65,215,
            215,215,13563,12015,11912,11809,11706,13563,12015,11912,
            11809,11706,373,2227,13563,4664,13563,4773,800,13206,
            1122,3997,56,13563,3750,398,2364,1863,386,404,
            13563,13664,13563,13563,329,13554,12760,396,329,12366,
            644,1398,11881,746,2130,748,19203,13563,400,14088,
            1264,13557,12760,13563,3750,14088,13563,5806,330,13560,
            11881,13687,330,2432,13892,13563,390,3750,2432,13893,
            13688,11457,3750,14354,399,12366,389,388,12760,387,
            13563,11457,825,11350,13667,12366,12366,13563,12366,13563,
            13563,1812,262,11350,1556,266,1606,404,891,396,
            13563,12466,891,781,12663,10618,34,13661,13563,3797,
            13563,4124,13563,3720,246,13563,13563,13563,13563,14092,
            12663,137,1803,496,7186,13563,19204,135,13563,13196,
            13563,1204,13563,7186,499,2571,13563,12466,13664,483,
            12716,482,3355,13563,86,82,12663,12466,12466,13563,
            12466,13563,13563,13563,8682,2365,838,2932,2509,13563,
            2227,13563,3721,2364,10090,34,2261,912,2491,281,
            250,13563,11537,11087,149,155,731,798,13563,733,
            611,14222,13563,12994,14158,13563,13563,13795,13563,7186,
            1559,13691,13563,4431,134,4555,13563,13563,13563,3476,
            13859,8418,13563,14305,13664,1033,13563,40,13563,3242,
            13563,13796,13563,5555,13563,14304,13563,14064,13793,3738,
            13563,13812,13563,13563,13643,8770,13563,471,13563,135,
            65,13563,13563,13692,13563,8858,2814,3237,11981,2000,
            72,13563,140,13563,13563,13209,13686,13563,14048,14047,
            366,354,360,2568,13563,13563,13563,13563,350,8506,
            13563,6173,3136,13563,743,13563,13563,13563,4882,13563,
            14058,2400,2930,13563,3129,14310,13563,8154,34,11789,
            13563,14170,13563,133,4971,13563,13563,13689,14221,9386,
            13690,14301,14160,13563,5095,3237,13563,5204,2688,13563,
            13563,13563,13563,11773,14300,13860,3131,13563,1730,41,
            5867,13563,13563,10178,9562,13563,749,13563,13563,13563,
            3765,14328,13680,2086,13677,13563,14086,13563,66,9738,
            13563,14225,335,355,367,370,361,13563,364,358,
            652,11123,11238,13563,11005,10882,7450,13563,980,352,
            13563,12650,13693,12430,13563,14303,13563,13563,13563,14302,
            13563,2154,13681,13679,13563,13678,1743,1544,627,655,
            335,13563,746,496,13563,13563,2293,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13880,13563,13563,13563,13563,13563,9386,13563,13563,
            10266,13563,13563,14089,13563,13563,13563,10354,13563,10442,
            13563,13563,10530,13563,13563,13563,13551,13563,13563,11238,
            13563,11005,11123,13563,13563,13563,13563,13563,13563,13563,
            6084,13563,13563,13563,13563,13563,13563,10794,13563,13563,
            13563,13563,13563,13563,13563,3458,13563,13563,13563,13563,
            13563,13563,13563,13563,13551,3450,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,14206,13563,
            13563,13563,1505,13563,13563,13563,13563,13563,13563,13563,
            13563,13563,13563,13563,13563,13563,13563,13563,14217
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            394,88,394,390,61,1052,387,389,679,389,
            739,538,738,77,604,77,90,934,931,389,
            406,389,1054,533,680,680,680,680,131,207,
            1034,388,1031,425,1061,392,259,392,680,770,
            376,392,951,417,77,584,539,77,587,527,
            590,535,539,77,590,77,390,531,77,61,
            61,837,61,63,701,1031,488,427,1031,841,
            61,762,488,680,93,574,937,146,148,770,
            636,1032,1032,606,643,643,876,60,77,77,
            311,312,61,680,1031,1032,680,1032,99,951,
            154,158,156,165,162,148,167,166,682,684,
            686,690,955,955,77,693,355,696,706,168,
            179,732,934,934,390,574,876,951,61,673,
            1032,61,673,584,588,587,931,582,590,539,
            680,529,590,390,704,236,841,841,673,762,
            841,951,392,420,1031,714,728,1062,781,680,
            80,232,232,415,680,63,641,876,876,329,
            105,480,950,77,950,743,951,1031,673,745,
            745,769,769,679,679,680,80,678,951,327,
            146,606,841,955,955,955,955,955,955,955,
            150,638,751,751,417,955,955,955,955,955,
            955,955,955,949,1062,80,390,703,61,238,
            854,61,1032,99,252,252,582,393,390,407,
            679,82,393,1052,61,61,77,1031,80,61,
            841,762,951,761,761,80,80,876,915,781,
            146,951,680,770,146,77,77,680,680,147,
            679,935,679,679,488,704,234,488,754,235,
            235,488,875,841,1011,781,781,538,184,781,
            841,672,676,876,680,841,390,649,845,490,
            680,782,150,167,150,165,150,158,158,158,
            150,154,154,77,951,876,77,61,951,150,
            156,156,156,156,150,162,150,166,381,204,
            951,740,488,241,77,180,61,703,238,723,
            758,765,77,77,384,77,582,772,841,558,
            876,841,220,841,781,951,374,680,63,147,
            769,769,80,77,781,80,77,951,951,1002,
            951,951,77,523,1,841,841,761,204,673,
            61,841,1032,951,61,181,874,841,951,1032,
            951,951,821,841,673,704,704,390,392,241,
            858,238,951,488,99,390,1032,1052,580,578,
            580,384,951,360,876,841,872,781,146,781,
            77,781,77,781,841,670,841,775,841,374,
            778,777,762,646,570,841,725,841,374,647,
            935,524,951,522,523,499,499,499,499,499,
            499,499,499,499,499,614,499,499,499,951,
            499,499,499,505,509,507,515,513,499,517,
            516,682,684,687,690,27,693,355,696,706,
            175,176,876,915,372,843,951,675,390,862,
            841,841,841,841,848,761,951,673,77,390,
            392,841,77,539,423,841,147,841,680,841,
            680,841,1032,951,60,951,77,951,77,876,
            876,61,841,80,876,77,77,951,77,525,
            21,743,22,176,680,841,27,27,27,27,
            27,27,501,27,27,27,27,27,27,27,
            27,951,935,204,876,951,951,740,951,875,
            1032,1032,1032,61,61,382,781,781,781,1032,
            841,374,841,374,762,374,762,647,865,1032,
            374,571,21,178,22,951,499,501,517,501,
            515,501,509,509,501,505,505,501,507,507,
            507,507,501,513,501,516,841,390,761,698,
            539,841,841,841,951,951,951,951,951,178,
            841,1,1032,699,1008,841,841,841,22,523,
            700,872,870,876,176,176,22,701,321,1008,
            1008,951,176,22,176,951,77,841,708,1,
            523,22,523
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static char asr[] = {0,
            71,72,76,77,69,78,79,81,63,64,
            54,70,74,65,90,119,85,86,88,91,
            9,67,51,52,53,50,55,56,57,58,
            59,60,61,62,41,37,1,48,49,44,
            47,38,43,46,42,45,35,33,34,39,
            40,31,32,4,29,30,24,28,27,36,
            26,25,20,19,16,18,15,17,21,23,
            22,10,11,12,13,14,8,7,6,3,
            0,67,66,146,89,92,0,126,0,143,
            100,0,1,3,8,7,6,0,24,3,
            8,7,6,0,55,56,57,58,59,60,
            61,62,33,34,35,131,132,133,134,135,
            136,137,138,6,3,8,7,39,38,0,
            67,73,116,127,130,109,142,112,92,89,
            122,123,124,150,24,80,1,70,74,63,
            64,54,65,4,72,71,9,76,77,78,
            79,69,81,90,85,86,88,5,114,82,
            68,115,119,94,91,83,87,84,96,66,
            2,75,0,6,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,25,26,
            7,8,3,2,5,0,1,67,63,54,
            130,109,142,112,122,123,124,150,80,5,
            114,82,115,119,83,84,94,87,69,70,
            116,66,96,2,75,68,0,75,118,104,
            6,95,7,8,148,149,151,152,3,2,
            0,6,7,8,3,107,108,0,75,41,
            9,37,1,48,49,44,47,38,43,46,
            42,45,35,33,34,39,40,10,11,12,
            13,14,20,31,32,4,29,30,24,28,
            27,19,16,18,15,17,21,23,22,26,
            25,36,3,8,7,6,51,52,53,50,
            2,57,61,58,62,55,59,56,60,0,
            6,7,8,3,129,0,125,0,55,56,
            57,58,59,60,61,62,33,34,35,6,
            3,8,7,85,91,37,86,88,69,81,
            71,9,4,72,76,77,78,79,0,75,
            114,68,66,115,119,83,84,94,96,87,
            139,5,2,82,0,1,5,75,73,80,
            69,2,68,122,123,124,109,112,67,66,
            0,75,66,141,108,110,111,100,144,93,
            147,113,104,126,2,107,101,102,95,99,
            98,103,97,0,70,116,73,69,0,75,
            96,0,50,0,2,140,96,55,56,57,
            58,59,60,61,62,121,52,40,50,53,
            51,9,37,6,3,8,7,36,25,26,
            20,19,16,18,15,17,21,23,22,10,
            11,12,13,14,39,33,34,35,45,42,
            46,43,38,47,44,49,48,1,41,27,
            28,24,29,30,4,32,31,75,0,5,
            114,82,68,115,90,119,94,125,70,74,
            63,64,54,65,4,72,71,9,76,77,
            78,79,69,81,85,86,88,75,66,91,
            96,2,87,83,84,0,92,89,67,1,
            66,2,54,0,94,105,106,2,25,26,
            10,11,12,13,14,20,19,16,18,15,
            17,21,23,22,3,93,0,75,114,66,
            115,119,83,84,94,96,87,2,109,5,
            82,68,0,2,3,1,0,1,80,2,
            68,66,92,67,89,0,24,145,0,75,
            95,97,98,99,110,111,101,102,93,103,
            113,104,2,100,0,5,114,82,68,115,
            90,119,94,71,9,4,72,76,77,69,
            78,79,81,75,66,83,84,85,86,88,
            91,96,87,2,24,70,74,65,64,54,
            63,0,1,67,0,66,82,68,71,9,
            4,72,76,77,78,79,81,1,63,64,
            80,54,74,65,90,85,86,88,91,5,
            69,70,73,0,66,75,83,120,2,1,
            0,91,0,86,0,90,69,81,0,71,
            9,0,4,72,0,85,0,63,150,142,
            75,2,66,69,0,88,0,69,75,66,
            2,63,0,69,1,5,67,109,122,123,
            124,130,2,112,66,68,0,5,68,80,
            130,109,112,122,123,124,73,69,67,2,
            66,0,119,0,67,80,130,2,73,0,
            94,68,0,75,68,115,0,66,112,24,
            2,5,68,0,68,66,112,2,1,80,
            0,24,66,0,5,73,68,82,66,0,
            2,55,56,57,58,59,60,61,62,41,
            9,37,1,48,49,44,47,38,43,46,
            42,45,35,33,34,39,40,31,32,4,
            29,30,24,28,27,36,51,52,53,50,
            19,16,18,15,17,21,23,22,10,11,
            12,13,14,20,26,25,3,8,7,6,
            5,0,69,70,5,66,0,5,68,80,
            2,73,0,67,2,68,0,2,127,68,
            0,2,117,0,82,68,66,69,0,128,
            115,114,0,117,67,55,56,57,58,59,
            60,61,62,41,9,37,1,48,49,44,
            47,38,43,46,42,45,35,33,34,39,
            40,31,32,4,29,30,24,28,27,36,
            51,52,53,50,19,16,18,15,17,21,
            23,22,10,11,12,13,14,20,26,25,
            6,8,7,3,2,0,5,114,82,68,
            66,115,119,83,84,94,87,2,96,75,
            51,52,53,50,55,56,57,58,59,60,
            61,62,41,9,37,6,3,8,7,36,
            25,26,20,19,16,18,15,17,21,23,
            22,10,11,12,13,14,40,39,33,34,
            35,45,42,46,43,38,47,44,49,48,
            1,28,24,29,30,32,31,27,4,0,
            19,16,18,15,17,21,23,22,6,3,
            8,7,10,11,12,13,14,20,26,25,
            2,67,0,25,26,10,11,12,13,14,
            20,19,16,18,15,17,21,23,22,3,
            93,24,0,2,3,8,7,6,108,0,
            5,6,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,25,26,7,8,
            3,2,94,105,106,0
        };
    };
    public final static char asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static char nasb[] = {0,
            224,322,470,322,364,437,27,322,178,237,
            236,107,236,321,322,321,322,124,500,322,
            56,322,481,322,322,322,322,322,322,322,
            108,99,236,114,493,14,195,14,179,322,
            322,14,318,322,321,11,108,321,437,121,
            170,497,108,321,170,321,322,199,321,364,
            364,96,364,321,9,236,322,318,236,322,
            364,322,322,322,321,151,318,146,322,322,
            65,322,322,322,322,322,239,103,321,321,
            199,21,364,322,484,237,322,237,320,318,
            322,322,322,322,322,322,322,322,322,322,
            322,322,464,464,206,322,322,322,322,322,
            13,92,199,199,322,181,239,318,364,322,
            322,364,322,11,322,322,198,155,81,108,
            179,165,81,322,322,322,322,322,322,322,
            322,318,14,101,236,322,322,496,318,322,
            152,322,322,94,322,321,322,195,195,73,
            37,47,318,298,318,322,318,236,322,322,
            322,322,322,199,199,322,90,70,263,63,
            131,322,322,212,257,251,251,251,245,245,
            322,65,322,322,322,464,464,411,411,411,
            411,270,218,318,493,153,322,322,364,53,
            199,364,322,320,59,59,7,14,322,56,
            178,155,14,437,364,364,128,236,322,364,
            322,322,318,199,199,153,153,195,197,318,
            146,140,146,322,146,321,321,322,322,322,
            199,199,322,322,322,322,199,322,322,322,
            322,322,226,322,364,318,318,107,50,318,
            322,322,34,195,322,322,322,322,322,119,
            322,318,322,322,322,322,322,322,322,322,
            322,322,322,16,318,195,1,364,318,322,
            322,322,322,322,322,322,322,322,322,199,
            318,199,322,161,321,13,364,322,53,67,
            322,322,321,321,32,321,7,322,322,126,
            195,322,94,322,318,318,322,322,321,322,
            322,322,491,321,193,142,461,318,318,4,
            318,318,201,19,302,322,322,199,199,322,
            364,322,237,318,364,199,232,322,318,168,
            318,318,364,322,322,322,322,322,14,487,
            199,190,318,322,320,322,237,437,199,159,
            199,29,318,79,195,322,322,318,146,318,
            321,318,321,318,322,322,322,322,322,322,
            322,322,322,146,144,322,322,322,322,146,
            163,204,318,24,176,322,322,322,322,322,
            322,322,322,322,322,322,322,322,322,318,
            322,322,322,322,322,322,322,322,322,322,
            322,322,322,322,322,439,322,322,322,322,
            322,322,239,133,184,322,318,14,322,199,
            322,322,322,322,322,199,318,322,321,322,
            14,322,321,108,112,322,322,322,322,322,
            322,322,485,318,103,318,16,318,321,318,
            318,364,322,322,195,321,201,318,321,322,
            318,322,302,148,322,322,276,323,367,367,
            417,417,322,439,439,389,389,389,389,345,
            301,318,199,322,195,318,318,199,318,232,
            168,168,237,364,364,199,318,318,318,237,
            322,322,322,322,322,322,322,146,322,237,
            322,322,318,117,302,318,322,322,322,322,
            322,322,322,322,322,322,322,322,322,322,
            322,322,322,322,322,322,322,322,199,210,
            108,322,322,322,318,318,318,318,318,117,
            322,302,237,186,409,322,322,322,302,175,
            157,322,322,239,322,136,302,188,61,172,
            172,318,322,302,117,318,321,322,210,302,
            175,302,137
        };
    };
    public final static char nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            2,145,0,8,202,0,152,0,315,0,
            226,0,55,118,0,2,136,0,260,0,
            334,335,0,207,55,0,317,0,322,320,
            0,319,0,263,211,0,16,272,273,253,
            2,252,271,19,233,0,247,8,0,234,
            235,0,228,182,0,231,237,0,221,0,
            314,0,250,0,214,0,304,55,0,262,
            55,0,16,2,241,19,233,0,270,0,
            186,187,178,190,193,197,144,224,0,209,
            0,338,0,206,0,243,2,0,318,0,
            328,0,2,3,232,0,55,3,135,134,
            0,62,0,326,55,0,170,0,204,0,
            297,55,0,305,0,266,0,2,119,0,
            248,0,236,234,0,146,149,142,0,278,
            0,254,0,255,0,132,0,146,142,0,
            55,205,140,0,220,0,309,0,301,0,
            307,0,257,0,293,55,0,166,0,219,
            0,9,10,0,149,169,0,55,139,0,
            140,55,0,333,0,308,0,310,0,182,
            181,0,119,136,16,8,3,2,55,0,
            2,160,0,258,0,336,2,245,0,229,
            0,3,8,16,2,82,0,16,3,8,
            2,79,0,280,0,2,3,8,16,256,
            0,2,3,8,16,55,88,0,16,3,
            8,2,148,0,3,8,16,2,58,0,
            3,8,16,2,70,0,3,8,16,2,
            76,0,65,2,16,3,8,167,0,16,
            3,8,2,73,0,24,35,38,39,16,
            3,9,12,8,13,14,15,22,23,4,
            6,7,40,41,2,122,0,2,244,0,
            117,24,35,38,39,9,12,13,14,15,
            22,23,40,41,4,6,7,16,3,8,
            2,0,24,35,38,39,16,3,9,12,
            8,13,14,15,22,23,4,6,7,40,
            41,2,114,0,24,35,38,39,9,12,
            8,13,14,15,22,23,40,41,4,6,
            7,16,111,2,3,0,24,35,38,39,
            16,3,9,12,8,13,14,15,22,23,
            4,6,7,40,41,2,106,0,24,35,
            38,39,12,8,13,14,15,22,23,40,
            41,4,6,7,3,16,2,102,9,0,
            16,3,8,2,61,0,24,35,38,39,
            16,3,9,12,13,14,15,22,23,4,
            6,7,40,41,2,99,8,0,24,35,
            38,39,2,16,3,9,12,8,13,14,
            15,22,23,4,6,7,40,41,93,0,
            2,276,0,2,3,8,16,54,0,289,
            178,292,186,187,190,193,197,144,281,0,
            2,283,0,55,208,0,2,312,55,0,
            261,0,238,155,0,198,155,55,0,2,
            299,0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static char terminalIndex[] = {0,
            11,164,163,3,12,37,134,136,2,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,40,73,74,38,39,55,56,
            57,58,115,116,117,43,51,76,99,44,
            53,75,86,89,90,94,146,155,159,91,
            87,88,92,23,118,119,120,121,122,123,
            124,125,15,17,27,22,13,19,7,25,
            1,4,20,26,14,5,6,8,9,21,
            10,18,46,47,48,49,147,50,131,34,
            52,130,135,54,95,97,104,105,106,111,
            132,133,142,158,98,107,100,102,108,109,
            110,128,150,16,24,28,29,30,45,77,
            114,138,139,140,149,162,31,32,33,35,
            78,79,80,81,82,83,84,85,93,96,
            101,112,113,126,127,129,137,141,145,153,
            156,157,41,42,103,143,144,148,151,152,
            154,160,161
        };
    };
    public final static char terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static char nonterminalIndex[] = {0,
            168,169,166,167,171,173,174,188,186,190,
            0,187,189,191,192,0,0,0,345,0,
            0,182,183,194,0,0,0,0,195,0,
            0,0,0,198,199,225,0,226,228,229,
            230,0,0,0,0,0,0,0,0,0,
            0,0,0,224,234,220,221,222,217,218,
            219,293,0,0,243,0,0,214,215,216,
            211,212,213,208,209,210,205,206,207,202,
            203,204,178,196,200,0,201,235,0,0,
            172,0,285,0,0,0,281,282,283,278,
            279,280,197,275,276,277,322,0,272,273,
            274,269,270,271,266,267,268,0,176,263,
            264,265,0,260,0,0,261,0,262,0,
            181,0,328,350,351,179,256,0,312,241,
            255,259,301,307,177,0,223,252,258,306,
            313,315,0,0,0,0,0,0,170,180,
            185,0,238,239,0,244,245,249,257,0,
            284,0,0,0,0,0,0,0,321,0,
            324,0,0,0,0,329,330,0,0,333,
            0,0,334,0,0,335,336,349,0,184,
            231,232,0,237,240,242,254,286,288,289,
            291,292,300,0,0,0,302,304,0,311,
            0,316,0,317,320,0,0,323,0,331,
            332,340,341,0,0,342,347,348,0,0,
            165,0,175,193,227,0,233,0,0,236,
            0,246,247,248,0,250,251,0,0,253,
            287,290,0,0,0,0,0,0,0,0,
            294,295,296,297,298,299,0,0,0,0,
            303,0,305,0,0,0,0,0,308,0,
            0,309,310,0,0,0,0,0,314,0,
            0,0,318,0,319,0,0,0,0,0,
            325,326,327,0,0,0,0,0,0,337,
            0,338,339,0,0,0,0,0,0,0,
            0,0,0,343,344,346,0,0,0,0,
            0,0,0,0
        };
    };
    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            576,612,622,510,544,552,598,632,586,15,
            24,48,55,237,237,334,530,537,237,84,
            107,246,246,246,429,519,570,163,246,246,
            246,365,380,246,560,606,246,33,33,38,
            43,62,67,102,525,137,321,353,72,72,
            122,126,159,159,409,409,413,413,425,443,
            447,640,644,648,652,115,130,145,152,152,
            230,255,358,255,255,255,435,255,255,255,
            371,386,255,255,97,78,417,422,78,6,
            6,78,315,347,451,78,315,315,95,1,
            172,172,180,180,188,188,188,188,202,202,
            210,215,220,225,390,390,390,390,404,454,
            454,462,462,470,470,470,470,1,1,490,
            495,500,505
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            31,31,31,31,31,31,31,31,594,22,
            31,31,31,244,268,244,31,31,282,76,
            113,244,268,244,31,31,31,169,252,270,
            304,362,362,282,566,594,286,22,31,31,
            31,31,31,31,31,142,326,134,22,76,
            31,31,22,100,22,31,22,31,100,100,
            31,100,100,31,31,119,134,149,81,156,
            234,312,362,264,278,264,439,259,273,307,
            375,375,298,291,100,31,420,31,31,9,
            12,81,318,350,12,90,329,341,76,3,
            174,177,182,185,190,193,196,199,204,207,
            212,217,222,227,392,395,398,401,406,456,
            459,464,467,472,475,478,481,484,487,492,
            497,502,507
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            28,27,27,30,30,30,28,27,28,18,
            18,233,233,138,138,38,30,30,123,211,
            28,138,138,123,90,30,30,28,138,138,
            123,44,44,123,30,28,123,17,17,52,
            52,233,233,48,30,67,38,252,264,264,
            271,271,208,208,64,64,165,165,41,40,
            89,23,22,7,6,276,47,62,211,211,
            142,123,44,138,138,123,90,138,138,123,
            44,44,123,123,88,94,43,249,36,37,
            37,211,38,207,37,211,38,38,212,73,
            99,99,102,102,106,106,106,106,111,111,
            114,117,122,128,65,65,65,65,205,58,
            58,61,61,70,70,70,70,73,73,76,
            79,82,86
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static char scopeLa[] = {
            5,5,5,5,5,5,5,5,82,2,
            5,5,5,84,83,84,5,5,83,66,
            114,84,83,84,5,5,5,5,87,87,
            87,5,5,83,68,82,87,2,5,5,
            5,5,5,5,5,5,83,5,2,66,
            5,5,2,75,2,5,2,5,75,75,
            5,75,75,5,5,82,5,5,5,5,
            5,5,5,5,5,5,68,5,5,5,
            66,66,5,5,75,5,125,5,5,94,
            94,5,119,119,94,5,119,119,66,90,
            72,4,9,71,79,78,77,76,81,69,
            85,86,88,91,74,74,70,70,68,72,
            4,9,71,79,78,77,76,81,69,85,
            86,88,91
        };
    };
    public final static char scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static char scopeStateSet[] = {
            339,339,339,339,339,339,339,339,339,52,
            52,43,43,263,263,339,339,339,168,40,
            339,263,263,168,463,339,339,339,263,263,
            168,339,339,168,339,339,168,52,52,339,
            339,43,43,339,339,86,339,44,41,41,
            44,44,46,46,86,86,459,459,339,339,
            463,339,339,306,306,36,339,178,40,40,
            1,168,339,263,263,168,463,263,263,168,
            339,339,168,168,271,8,339,38,339,339,
            339,40,339,33,339,40,339,339,303,376,
            11,11,13,13,17,17,17,17,19,19,
            20,21,22,261,86,86,86,86,49,367,
            367,369,369,373,373,373,373,376,376,377,
            378,379,380
        };
    };
    public final static char scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            235,0,90,233,0,499,41,0,94,218,
            0,94,246,0,398,68,296,1,498,179,
            0,218,0,399,68,296,1,498,179,0,
            5,0,398,1,497,179,0,271,1,168,
            34,0,271,1,168,33,0,271,1,164,
            80,164,34,0,271,1,164,80,164,33,
            0,271,1,164,34,0,271,1,164,33,
            0,246,117,83,0,66,0,246,1,0,
            5,218,0,246,117,5,246,1,0,5,
            117,246,66,0,246,0,442,67,0,75,
            0,271,1,306,46,0,246,441,63,377,
            192,0,114,0,323,66,376,0,82,246,
            0,439,1,436,0,438,1,435,0,372,
            1,43,0,5,251,0,246,1,431,53,
            0,5,433,0,271,1,50,0,5,429,
            0,246,1,120,0,5,375,0,426,425,
            67,0,424,1,38,64,192,0,5,371,
            0,261,0,72,256,0,4,256,0,264,
            0,9,262,0,71,262,0,268,0,79,
            265,0,78,265,0,77,265,0,76,265,
            0,273,0,81,269,0,69,269,0,276,
            0,85,274,0,279,0,86,277,0,284,
            0,88,280,0,292,0,91,285,0,246,
            1,87,0,5,300,0,332,300,5,246,
            1,40,0,84,0,300,5,246,1,40,
            0,332,84,0,246,1,40,0,5,300,
            332,84,0,5,300,84,0,312,0,332,
            312,0,5,300,332,312,0,5,300,312,
            0,83,304,333,0,332,83,304,333,0,
            5,300,332,83,304,333,0,5,300,83,
            304,333,0,332,309,0,5,300,332,309,
            0,5,304,0,246,40,0,119,419,0,
            331,119,246,40,0,83,420,0,119,331,
            83,420,0,421,422,331,119,246,40,0,
            119,331,422,421,84,0,246,87,0,119,
            331,0,418,417,1,416,0,246,1,44,
            0,5,329,0,246,66,228,1,44,0,
            228,1,44,0,66,246,5,329,0,246,
            66,330,1,44,0,330,1,44,0,192,
            0,74,218,0,74,246,0,70,218,0,
            70,246,0,303,0,68,303,0,303,1,
            52,0,368,1,52,0,251,49,0,413,
            0,366,1,0,409,67,25,0,254,68,
            254,1,25,0,254,1,25,0,68,254,
            5,0,362,67,26,0,254,1,26,0,
            408,41,0,220,0,72,217,0,4,217,
            0,223,0,9,221,0,71,221,0,232,
            0,79,224,0,78,224,0,77,224,0,
            76,224,0,81,233,0,69,233,0,238,
            0,85,236,0,241,0,86,239,0,244,
            0,88,242,0,250,0,91,245,0,271,
            1,295,322,80,168,54,192,0,271,1,
            322,80,168,0,271,1,295,164,0,271,
            1,295,164,54,192,0,271,1,295,404,
            54,192,0,266,68,164,1,164,64,192,
            0,266,68,247,1,164,64,192,0,247,
            1,164,64,192,0,68,266,5,0,246,
            1,164,64,192,0,246,82,299,66,294,
            1,164,64,192,0,299,66,294,1,164,
            64,192,0,82,246,5,0,246,82,299,
            1,164,64,192,0,299,1,164,64,192,
            0,246,82,294,68,282,1,164,64,192,
            0,246,82,294,68,164,1,164,64,192,
            0,246,82,294,1,164,64,192,0,407,
            67,20,0,362,67,166,0,405,1,20,
            0,254,1,166,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            971,2667,1946,2370,2131,1225,0,12760,12663,12566,
            12466,12366,12015,11912,11809,11706,11457,11350,11238,11123,
            11005,2432,2293,1264,1122,2154,980,2012,10882,1870,
            838,0,1197,1112,0,12716,0,1832,0,1544,
            1317,0,1550,1320,0,2814,13163,0,2083,2207,
            0,11005,11238,12015,11912,11809,11706,12760,12663,12466,
            12366,11457,11350,11123,10882,12566,3136,6726,12304,12242,
            12180,12118,13080,13005,5806,5401,11635,11564,5643,6173,
            2935,1320,1550,12932,12857,2432,2293,10794,10706,6253,
            2154,10618,10530,10442,10354,10266,10178,6084,5204,5095,
            4971,4882,10090,10002,9914,7450,9826,5971,9738,7362,
            2708,5867,9650,9562,9474,9386,9298,5718,9210,9122,
            4773,4664,4555,4431,7274,9034,8946,8858,8770,8682,
            4342,8594,5555,8506,8418,3355,2571,8330,4233,7186,
            8242,8154,7070,8066,6982,6894,4124,4015,3906,3242,
            3797,6806,7978,6638,7890,3041,2840,6550,6434,3499,
            7802,7714,5462,7626,5313,6346,7538,1264,1122,980,
            2012,1870,838,3631,1630,1406,0,10794,10706,6253,
            10618,10530,10442,10354,10266,10178,6084,5204,5095,4971,
            4882,10090,10002,9914,7450,9826,5971,9738,7362,2708,
            5867,9650,9562,9474,1743,9386,9298,5718,9210,9122,
            4773,4664,4555,4431,7274,9034,8946,8858,8770,8682,
            4342,8594,5555,8506,8418,3355,2571,8330,4233,7186,
            8242,8154,7070,8066,6982,6894,4124,4015,3906,3242,
            3797,6806,7978,3631,6638,7890,3041,2840,6550,6434,
            3499,7802,7714,5462,7626,5313,6346,1630,7538,1406,
            2012,1870,2432,2293,1264,1122,2154,980,838,0,
            2432,2293,1264,1122,2154,3132,980,2012,6084,3131,
            3130,3129,2930,2400,1870,5971,2933,2261,2932,838,
            3242,13228,13210,13192,2423,1262,13189,13185,13184,13153,
            1742,1114,4882,4342,0,13167,12430,12650,11989,2000,
            13060,11537,11981,11889,11881,11789,13136,11087,1494,11202,
            11773,11429,11421,11322,13162,1775,11314,2144,1719,1834,
            1850,1535,1514,13141,13070,13065,1734,1506,2432,2293,
            1264,1122,2154,980,2012,11005,11238,12015,11912,11809,
            11706,12760,12663,12466,12366,11457,11350,11123,10882,1870,
            12566,838,13080,13005,12932,12857,5806,5401,12304,12242,
            12180,12118,11635,11564,5643,6726,6173,3136,2935,10794,
            10706,6253,10618,10530,10442,10354,10266,10178,6084,5204,
            5095,4971,4882,10090,10002,9914,7450,9826,5971,9738,
            7362,2708,5867,9650,9562,9474,9386,9298,5718,9210,
            9122,4773,4664,4555,4431,7274,9034,8946,8858,8770,
            8682,4342,8594,5555,8506,8418,3355,2571,8330,4233,
            7186,8242,8154,7070,8066,6982,6894,4124,4015,3906,
            3242,3797,6806,7978,6638,7890,3041,2840,6550,6434,
            3499,7802,7714,5462,7626,5313,6346,7538,3631,1630,
            1406,0,13167,12430,12650,11989,2000,13060,11537,11981,
            11889,11881,11789,13136,11087,1494,11202,11773,11429,11421,
            11322,13162,1775,11314,2144,1719,1834,1850,1535,1514,
            13141,13070,13065,1734,1506,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,402,443,307,147,104,360,359,93,356,
            353,350,349,100,110,113,111,144,108,455,
            341,452,141,254,25,26,20,166,165,168,
            171,480,109,67,1,251,67,251,296,297,
            298,251,69,270,100,270,100,143,3,313,
            67,97,103,107,67,108,381,313,54,1,
            1,1,1,80,296,112,479,489,140,502,
            318,401,442,50,53,52,51,164,199,168,
            192,25,26,171,20,166,40,39,34,33,
            35,179,46,43,38,47,44,49,48,1,
            219,231,222,237,234,197,243,240,250,241,
            235,223,37,9,41,220,232,238,244,248,
            380,302,80,80,246,52,40,69,73,270,
            389,89,296,270,465,171,54,460,382,318,
            296,313,382,381,270,254,254,405,164,406,
            254,69,75,490,121,254,3,68,1,431,
            1,368,303,3,295,80,377,74,70,54,
            64,67,67,67,67,246,1,373,395,7,
            3,168,168,498,497,306,1,67,1,251,
            168,171,246,91,86,90,81,69,9,71,
            197,192,408,499,164,72,4,79,78,77,
            76,85,88,66,73,1,246,254,73,67,
            326,73,389,145,89,92,383,75,307,341,
            296,456,75,69,68,73,68,96,130,73,
            271,266,1,368,303,68,68,369,73,1,
            322,63,404,168,164,34,33,38,39,164,
            416,437,436,435,409,364,410,362,246,363,
            407,362,119,246,73,1,1,1,1,1,
            372,3,425,1,120,246,330,3,228,413,
            125,1,197,244,197,238,197,232,232,232,
            197,220,220,68,94,94,68,73,69,197,
            223,223,223,223,197,235,197,241,401,303,
            69,254,390,345,118,391,68,254,67,466,
            171,168,384,384,393,146,383,171,254,5,
            68,246,254,271,1,441,3,295,80,295,
            164,164,1,1,1,1,1,1,69,68,
            115,68,68,331,5,271,271,296,398,3,
            397,271,5,70,73,426,83,246,1,5,
            66,66,1,366,164,164,254,246,75,470,
            474,66,69,390,68,467,112,1,385,168,
            385,482,109,5,369,271,246,1,322,1,
            80,1,80,1,424,3,294,164,246,299,
            294,282,247,164,417,439,376,438,294,164,
            83,422,87,423,300,170,169,167,204,203,
            186,185,178,177,176,171,175,172,202,1,
            201,198,187,260,267,263,275,272,197,283,
            278,292,279,273,264,37,261,268,276,284,
            290,287,40,68,254,254,117,251,246,5,
            246,246,246,414,3,326,69,270,68,246,
            75,342,68,485,139,271,295,271,164,271,
            164,271,5,69,5,82,66,82,68,68,
            68,73,418,68,82,68,66,82,68,421,
            83,246,83,332,87,246,91,86,81,69,
            9,71,197,72,4,79,78,77,76,85,
            88,1,398,399,82,70,69,246,117,5,
            5,5,5,73,73,486,1,1,1,373,
            246,299,246,294,266,294,266,164,254,5,
            323,376,119,304,83,1,5,197,284,197,
            276,197,268,268,197,261,261,197,264,264,
            264,264,197,273,197,279,246,246,326,254,
            68,271,271,271,82,82,82,82,82,304,
            246,5,5,392,63,246,246,246,5,300,
            471,476,172,40,84,332,83,472,142,115,
            128,1,84,83,300,69,477,246,270,5,
            300,83,332
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "", //$NON-NLS-1$
            "+", //$NON-NLS-1$
            "-", //$NON-NLS-1$
            "*", //$NON-NLS-1$
            "/", //$NON-NLS-1$
            ">", //$NON-NLS-1$
            "<", //$NON-NLS-1$
            "=", //$NON-NLS-1$
            ">=", //$NON-NLS-1$
            "<=", //$NON-NLS-1$
            "<>", //$NON-NLS-1$
            "(", //$NON-NLS-1$
            ")", //$NON-NLS-1$
            "{", //$NON-NLS-1$
            "}", //$NON-NLS-1$
            "[", //$NON-NLS-1$
            "]", //$NON-NLS-1$
            "->", //$NON-NLS-1$
            "|", //$NON-NLS-1$
            ",", //$NON-NLS-1$
            ":", //$NON-NLS-1$
            "::", //$NON-NLS-1$
            ";", //$NON-NLS-1$
            ".", //$NON-NLS-1$
            "..", //$NON-NLS-1$
            ":=", //$NON-NLS-1$
            "+=", //$NON-NLS-1$
            "!", //$NON-NLS-1$
            "::=", //$NON-NLS-1$
            "?", //$NON-NLS-1$
            "<<", //$NON-NLS-1$
            ">>", //$NON-NLS-1$
            "...", //$NON-NLS-1$
            "~", //$NON-NLS-1$
            "!=", //$NON-NLS-1$
            "@", //$NON-NLS-1$
            "$empty", //$NON-NLS-1$
            "QUOTED_IDENTIFIER", //$NON-NLS-1$
            "INTEGER_LITERAL", //$NON-NLS-1$
            "REAL_LITERAL", //$NON-NLS-1$
            "STRING_LITERAL", //$NON-NLS-1$
            "SINGLE_LINE_COMMENT", //$NON-NLS-1$
            "MULTI_LINE_COMMENT", //$NON-NLS-1$
            "self", //$NON-NLS-1$
            "if", //$NON-NLS-1$
            "then", //$NON-NLS-1$
            "else", //$NON-NLS-1$
            "endif", //$NON-NLS-1$
            "and", //$NON-NLS-1$
            "or", //$NON-NLS-1$
            "xor", //$NON-NLS-1$
            "not", //$NON-NLS-1$
            "implies", //$NON-NLS-1$
            "let", //$NON-NLS-1$
            "in", //$NON-NLS-1$
            "true", //$NON-NLS-1$
            "false", //$NON-NLS-1$
            "null", //$NON-NLS-1$
            "invalid", //$NON-NLS-1$
            "Set", //$NON-NLS-1$
            "Bag", //$NON-NLS-1$
            "Sequence", //$NON-NLS-1$
            "Collection", //$NON-NLS-1$
            "OrderedSet", //$NON-NLS-1$
            "String", //$NON-NLS-1$
            "Integer", //$NON-NLS-1$
            "UnlimitedNatural", //$NON-NLS-1$
            "Real", //$NON-NLS-1$
            "Boolean", //$NON-NLS-1$
            "Tuple", //$NON-NLS-1$
            "OclAny", //$NON-NLS-1$
            "OclVoid", //$NON-NLS-1$
            "OclInvalid", //$NON-NLS-1$
            "Dict", //$NON-NLS-1$
            "List", //$NON-NLS-1$
            "break", //$NON-NLS-1$
            "switch", //$NON-NLS-1$
            "case", //$NON-NLS-1$
            "xselect", //$NON-NLS-1$
            "xcollect", //$NON-NLS-1$
            "selectOne", //$NON-NLS-1$
            "collectOne", //$NON-NLS-1$
            "collectselect", //$NON-NLS-1$
            "collectselectOne", //$NON-NLS-1$
            "forEach", //$NON-NLS-1$
            "forOne", //$NON-NLS-1$
            "compute", //$NON-NLS-1$
            "return", //$NON-NLS-1$
            "var", //$NON-NLS-1$
            "while", //$NON-NLS-1$
            "continue", //$NON-NLS-1$
            "log", //$NON-NLS-1$
            "assert", //$NON-NLS-1$
            "with", //$NON-NLS-1$
            "new", //$NON-NLS-1$
            "static", //$NON-NLS-1$
            "init", //$NON-NLS-1$
            "end", //$NON-NLS-1$
            "out", //$NON-NLS-1$
            "object", //$NON-NLS-1$
            "transformation", //$NON-NLS-1$
            "import", //$NON-NLS-1$
            "library", //$NON-NLS-1$
            "metamodel", //$NON-NLS-1$
            "mapping", //$NON-NLS-1$
            "query", //$NON-NLS-1$
            "helper", //$NON-NLS-1$
            "inout", //$NON-NLS-1$
            "when", //$NON-NLS-1$
            "configuration", //$NON-NLS-1$
            "intermediate", //$NON-NLS-1$
            "property", //$NON-NLS-1$
            "opposites", //$NON-NLS-1$
            "class", //$NON-NLS-1$
            "population", //$NON-NLS-1$
            "map", //$NON-NLS-1$
            "xmap", //$NON-NLS-1$
            "late", //$NON-NLS-1$
            "resolve", //$NON-NLS-1$
            "resolveone", //$NON-NLS-1$
            "resolveIn", //$NON-NLS-1$
            "resolveoneIn", //$NON-NLS-1$
            "invresolve", //$NON-NLS-1$
            "invresolveone", //$NON-NLS-1$
            "invresolveIn", //$NON-NLS-1$
            "invresolveoneIn", //$NON-NLS-1$
            "modeltype", //$NON-NLS-1$
            "uses", //$NON-NLS-1$
            "where", //$NON-NLS-1$
            "refines", //$NON-NLS-1$
            "access", //$NON-NLS-1$
            "extends", //$NON-NLS-1$
            "blackbox", //$NON-NLS-1$
            "abstract", //$NON-NLS-1$
            "result", //$NON-NLS-1$
            "main", //$NON-NLS-1$
            "this", //$NON-NLS-1$
            "rename", //$NON-NLS-1$
            "disjuncts", //$NON-NLS-1$
            "merges", //$NON-NLS-1$
            "inherits", //$NON-NLS-1$
            "composes", //$NON-NLS-1$
            "constructor", //$NON-NLS-1$
            "datatype", //$NON-NLS-1$
            "default", //$NON-NLS-1$
            "derived", //$NON-NLS-1$
            "do", //$NON-NLS-1$
            "elif", //$NON-NLS-1$
            "enum", //$NON-NLS-1$
            "except", //$NON-NLS-1$
            "exception", //$NON-NLS-1$
            "from", //$NON-NLS-1$
            "literal", //$NON-NLS-1$
            "ordered", //$NON-NLS-1$
            "primitive", //$NON-NLS-1$
            "raise", //$NON-NLS-1$
            "readonly", //$NON-NLS-1$
            "references", //$NON-NLS-1$
            "tag", //$NON-NLS-1$
            "try", //$NON-NLS-1$
            "typedef", //$NON-NLS-1$
            "unlimited", //$NON-NLS-1$
            "EOF_TOKEN", //$NON-NLS-1$
            "IDENTIFIER", //$NON-NLS-1$
            "ERROR_TOKEN", //$NON-NLS-1$
            "conceptualOperationNameCS", //$NON-NLS-1$
            "CollectionTypeIdentifierCS", //$NON-NLS-1$
            "primitiveTypeCS", //$NON-NLS-1$
            "simpleNameCS", //$NON-NLS-1$
            "QuotedSimpleNameCS", //$NON-NLS-1$
            "unreservedSimpleNameCS", //$NON-NLS-1$
            "pathNameCS", //$NON-NLS-1$
            "typeCS", //$NON-NLS-1$
            "collectionTypeCS", //$NON-NLS-1$
            "tupleTypeCS", //$NON-NLS-1$
            "tupleTypePartsCS", //$NON-NLS-1$
            "typedUninitializedVariableCS", //$NON-NLS-1$
            "untypedInitializedVariableCS", //$NON-NLS-1$
            "OclExpressionCS", //$NON-NLS-1$
            "typedInitializedVariableCS", //$NON-NLS-1$
            "initializedVariableCS", //$NON-NLS-1$
            "uninitializedVariableCS", //$NON-NLS-1$
            "CollectionLiteralExpCS", //$NON-NLS-1$
            "TupleLiteralExpCS", //$NON-NLS-1$
            "CollectionLiteralPartsCS", //$NON-NLS-1$
            "CollectionLiteralPartCS", //$NON-NLS-1$
            "IntegerLiteralExpCS", //$NON-NLS-1$
            "RealLiteralExpCS", //$NON-NLS-1$
            "StringLiteralExpCS", //$NON-NLS-1$
            "BooleanLiteralExpCS", //$NON-NLS-1$
            "UnlimitedNaturalLiteralExpCS", //$NON-NLS-1$
            "InvalidLiteralExpCS", //$NON-NLS-1$
            "NullLiteralExpCS", //$NON-NLS-1$
            "TupleLiteralPartsCS", //$NON-NLS-1$
            "CallExpCS", //$NON-NLS-1$
            "primaryExpCS", //$NON-NLS-1$
            "notNameExpressionCS", //$NON-NLS-1$
            "argumentsCS", //$NON-NLS-1$
            "SimpleNameExpCS", //$NON-NLS-1$
            "VariableExpCS", //$NON-NLS-1$
            "impliesNotNameNotLetCS", //$NON-NLS-1$
            "impliesNotLetCS", //$NON-NLS-1$
            "xorNotNameNotLetCS", //$NON-NLS-1$
            "xorNotLetCS", //$NON-NLS-1$
            "xorWithLetCS", //$NON-NLS-1$
            "orNotNameNotLetCS", //$NON-NLS-1$
            "orNotLetCS", //$NON-NLS-1$
            "orWithLetCS", //$NON-NLS-1$
            "andNotNameNotLetCS", //$NON-NLS-1$
            "andNotLetCS", //$NON-NLS-1$
            "andWithLetCS", //$NON-NLS-1$
            "equalityNotNameNotLetCS", //$NON-NLS-1$
            "equalityNotLetCS", //$NON-NLS-1$
            "equalityWithLetCS", //$NON-NLS-1$
            "relationalNotNameNotLetCS", //$NON-NLS-1$
            "relationalNotLetCS", //$NON-NLS-1$
            "relationalWithLetCS", //$NON-NLS-1$
            "additiveNotNameNotLetCS", //$NON-NLS-1$
            "additiveNotLetCS", //$NON-NLS-1$
            "additiveWithLetCS", //$NON-NLS-1$
            "multiplicativeNotNameNotLetCS", //$NON-NLS-1$
            "multiplicativeNotLetCS", //$NON-NLS-1$
            "multiplicativeWithLetCS", //$NON-NLS-1$
            "unaryNotLetCS", //$NON-NLS-1$
            "unaryWithLetCS", //$NON-NLS-1$
            "primaryNotNameCS", //$NON-NLS-1$
            "IfExpCS", //$NON-NLS-1$
            "letVariablesCS", //$NON-NLS-1$
            "ImperativeExpCS", //$NON-NLS-1$
            "listLiteralCS", //$NON-NLS-1$
            "dictLiteralCS", //$NON-NLS-1$
            "literalSimpleCS", //$NON-NLS-1$
            "dictLiteralPartCS", //$NON-NLS-1$
            "dictLiteralPartListCS", //$NON-NLS-1$
            "qvtErrorToken", //$NON-NLS-1$
            "expression_block", //$NON-NLS-1$
            "CatchExp_list", //$NON-NLS-1$
            "CatchExp", //$NON-NLS-1$
            "type_list", //$NON-NLS-1$
            "expression_semi_list_element", //$NON-NLS-1$
            "var_init_declarator_list", //$NON-NLS-1$
            "var_init_declarator", //$NON-NLS-1$
            "var_init_op", //$NON-NLS-1$
            "assignStatementCS", //$NON-NLS-1$
            "whileBodyCS", //$NON-NLS-1$
            "declarator1", //$NON-NLS-1$
            "forExpCS", //$NON-NLS-1$
            "forOpCode", //$NON-NLS-1$
            "forExpDeclaratorList", //$NON-NLS-1$
            "ifExpBodyCS", //$NON-NLS-1$
            "ifThenPart", //$NON-NLS-1$
            "ifElsePart", //$NON-NLS-1$
            "ifExpression", //$NON-NLS-1$
            "ifElif_list", //$NON-NLS-1$
            "ifElif_listElem", //$NON-NLS-1$
            "notUMinus_ifExpBodyCS", //$NON-NLS-1$
            "notUMinus_ifExpBodyCS_full", //$NON-NLS-1$
            "ifElif_ext_list", //$NON-NLS-1$
            "mandatory_elsePart", //$NON-NLS-1$
            "ifElif_ext_listElem", //$NON-NLS-1$
            "notUMinus_statement", //$NON-NLS-1$
            "notUMinus_impliesNotNameNotLet" + //$NON-NLS-1$
            "CS", //$NON-NLS-1$
            "notUMinus_impliesNotLetCS", //$NON-NLS-1$
            "notUMinus_xorNotNameNotLetCS", //$NON-NLS-1$
            "notUMinus_xorNotLetCS", //$NON-NLS-1$
            "notUMinus_xorWithLetCS", //$NON-NLS-1$
            "notUMinus_orNotNameNotLetCS", //$NON-NLS-1$
            "notUMinus_orNotLetCS", //$NON-NLS-1$
            "notUMinus_orWithLetCS", //$NON-NLS-1$
            "notUMinus_andNotNameNotLetCS", //$NON-NLS-1$
            "notUMinus_andNotLetCS", //$NON-NLS-1$
            "notUMinus_andWithLetCS", //$NON-NLS-1$
            "notUMinus_equalityNotNameNotLe" + //$NON-NLS-1$
            "tCS", //$NON-NLS-1$
            "notUMinus_equalityNotLetCS", //$NON-NLS-1$
            "notUMinus_equalityWithLetCS", //$NON-NLS-1$
            "notUMinus_relationalNotNameNot" + //$NON-NLS-1$
            "LetCS", //$NON-NLS-1$
            "notUMinus_relationalNotLetCS", //$NON-NLS-1$
            "notUMinus_relationalWithLetCS", //$NON-NLS-1$
            "notUMinus_additiveNotNameNotLe" + //$NON-NLS-1$
            "tCS", //$NON-NLS-1$
            "notUMinus_additiveNotLetCS", //$NON-NLS-1$
            "notUMinus_additiveWithLetCS", //$NON-NLS-1$
            "notUMinus_multiplicativeNotNam" + //$NON-NLS-1$
            "eNotLetCS", //$NON-NLS-1$
            "notUMinus_multiplicativeNotLet" + //$NON-NLS-1$
            "CS", //$NON-NLS-1$
            "notUMinus_multiplicativeWithLe" + //$NON-NLS-1$
            "tCS", //$NON-NLS-1$
            "notUMinus_unaryNotLetCS", //$NON-NLS-1$
            "notUMinus_unaryWithLetCS", //$NON-NLS-1$
            "switchBodyExpCS", //$NON-NLS-1$
            "switchDeclaratorCS", //$NON-NLS-1$
            "declarator", //$NON-NLS-1$
            "objectDeclCS", //$NON-NLS-1$
            "switchAltExpCSList", //$NON-NLS-1$
            "switchAltExpCS", //$NON-NLS-1$
            "expression_statement", //$NON-NLS-1$
            "logExpCS", //$NON-NLS-1$
            "imperativeIterateExpCS", //$NON-NLS-1$
            "imperativeIteratorExpCSToken12", //$NON-NLS-1$
            "imperativeIteratorExpCSToken3", //$NON-NLS-1$
            "imperativeIteratorExpCSToken", //$NON-NLS-1$
            "imperativeIterContents12", //$NON-NLS-1$
            "imperativeIterContents3", //$NON-NLS-1$
            "variableDeclarationListCS", //$NON-NLS-1$
            "typespec", //$NON-NLS-1$
            "expression_semi_list", //$NON-NLS-1$
            "unit_element", //$NON-NLS-1$
            "unit", //$NON-NLS-1$
            "importDeclaration", //$NON-NLS-1$
            "qualifiedNameCS", //$NON-NLS-1$
            "_tag", //$NON-NLS-1$
            "transformation_h", //$NON-NLS-1$
            "library_h", //$NON-NLS-1$
            "transformation_signature", //$NON-NLS-1$
            "module_usageList", //$NON-NLS-1$
            "simple_signature", //$NON-NLS-1$
            "moduleref", //$NON-NLS-1$
            "libraryDeclaration", //$NON-NLS-1$
            "module_usage", //$NON-NLS-1$
            "moduleref_list", //$NON-NLS-1$
            "module_element", //$NON-NLS-1$
            "packageref_list", //$NON-NLS-1$
            "modeltypeDeclaration", //$NON-NLS-1$
            "packageref", //$NON-NLS-1$
            "uri", //$NON-NLS-1$
            "qvtIdentifierCS", //$NON-NLS-1$
            "classifierFeatureList", //$NON-NLS-1$
            "classifierFeatureCS", //$NON-NLS-1$
            "identifier_list", //$NON-NLS-1$
            "feature_key", //$NON-NLS-1$
            "multiplicity_range", //$NON-NLS-1$
            "scoped_identifier", //$NON-NLS-1$
            "helper_header", //$NON-NLS-1$
            "helper_info", //$NON-NLS-1$
            "complete_signature", //$NON-NLS-1$
            "helper_kind", //$NON-NLS-1$
            "constructor_header", //$NON-NLS-1$
            "entry_header", //$NON-NLS-1$
            "mapping_full_header", //$NON-NLS-1$
            "mapping_header", //$NON-NLS-1$
            "mapping_extra", //$NON-NLS-1$
            "mapping_extension_key", //$NON-NLS-1$
            "scoped_identifier_list", //$NON-NLS-1$
            "objectIdentifierCS", //$NON-NLS-1$
            "featureMappingCallExpCS", //$NON-NLS-1$
            "resolveOpArgsExpCS", //$NON-NLS-1$
            "resolveOp", //$NON-NLS-1$
            "resolveInOp", //$NON-NLS-1$
            "resolveResolveInExpCS", //$NON-NLS-1$
            "letExpSubCS3", //$NON-NLS-1$
            "qualifier", //$NON-NLS-1$
            "param_list", //$NON-NLS-1$
            "param", //$NON-NLS-1$
            "typeCS2", //$NON-NLS-1$
            "scoped_identifier2" //$NON-NLS-1$
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
