/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.ChooserAdapter;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IDestinationChooser;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.Messages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.ResourceSourceChooser;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.controls.IPathUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.controls.SelectFileControl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class ResourceDestinationChooser
extends ChooserAdapter
implements IDestinationChooser {
    public static final int DEFAUL_AUTO_EXPAND_LEVEL = 2;
    private SelectFileControl myControl;
    private IStructuredSelection myInitialSelection;
    private String myFileName;
    private String myDefaultFileName;
    private IPath myPath;

    public String getTitle() {
        return Messages.ResourceDestinationChooser_0;
    }

    public Control createControl(Composite parent) {
        this.myControl = new SelectFileControl(parent, this.myFileName, this.myDefaultFileName, false, null);
        this.myControl.addSelectionListener(new SelectFileControl.ISelectionListener(){

            public void selectionChanged(IPath path) {
                ResourceDestinationChooser.this.myPath = ResourceDestinationChooser.this.myControl.getSelectedPath();
                ResourceDestinationChooser.this.fireChangedEvent();
            }
        });
        if (this.myInitialSelection != null) {
            this.myControl.setSelection((ISelection)this.myInitialSelection);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.m2m.qvt.oml.resource_destination_chooser");
        return this.myControl;
    }

    public void setInitialSelection(String uriString) {
        URI uri;
        URI uRI = uri = uriString.trim().isEmpty() ? null : URI.createURI((String)uriString);
        if (uri == null) {
            return;
        }
        IFile file = WorkspaceUtils.getWorkspaceFile((URI)uri);
        if (file == null) {
            return;
        }
        this.myInitialSelection = file.exists() ? ResourceSourceChooser.createSelectionForUri(uri, file) : new StructuredSelection((Object)file.getParent());
        this.myFileName = file.getName();
    }

    public void initNewName(String baseName, String extension) {
        this.myDefaultFileName = baseName;
        if (extension.length() > 0) {
            this.myDefaultFileName = String.valueOf(this.myDefaultFileName) + "." + extension;
        }
    }

    public IPath getPath() {
        return this.myPath;
    }

    public String getUriString() {
        URI uri = IPathUtils.getUri(this.getPath());
        return uri == null ? null : uri.toString();
    }
}

