/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.builder;

import com.google.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtext.builder.preferences.BuilderConfigurationBlock;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.ui.builder.XbaseBuilderPreferenceAccess;

public class XbaseBuilderConfigurationBlock
extends BuilderConfigurationBlock {
    @Inject
    private XbaseBuilderPreferenceAccess preferenceAccess;
    private Combo versionCombo;
    private Button useComplianceButton;

    protected void createGeneralSectionItems(Composite composite) {
        super.createGeneralSectionItems(composite);
        this.useComplianceButton = this.addCheckBox(composite, "Use source compatibility level from Java settings", "useJavaCompilerCompliance", BOOLEAN_VALUES, 0);
        int valueCount = JavaVersion.values().length;
        String[] values = new String[valueCount];
        String[] valueLabels = new String[valueCount];
        int i = 0;
        while (i < valueCount) {
            JavaVersion v = JavaVersion.values()[i];
            values[i] = v.toString();
            valueLabels[i] = v.getLabel();
            ++i;
        }
        this.versionCombo = this.addComboBox(composite, "Source compatibility level of generated code:", "targetJavaVersion", 0, values, valueLabels);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XbaseBuilderConfigurationBlock.this.updateVersionCombo();
            }
        };
        selectionListener.widgetSelected(null);
        this.useComplianceButton.addSelectionListener((SelectionListener)selectionListener);
        this.addCheckBox(composite, "Generate @SuppressWarnings annotations", "generateSuppressWarnings", BOOLEAN_VALUES, 0);
        this.addCheckBox(composite, "Annotate synthetic members with @XbaseGenerated", "useXbaseGenerated", BOOLEAN_VALUES, 0);
        final Button generateGeneratedButton = this.addCheckBox(composite, "Generate @Generated annotations", "generateGeneratedAnnotation", BOOLEAN_VALUES, 0);
        final Button includeDateButton = this.addCheckBox(composite, "Include current time information", "includeDateInGenerated", BOOLEAN_VALUES, 32);
        includeDateButton.setEnabled(generateGeneratedButton.getSelection());
        final Text commentText = this.addTextField(composite, "Comment:", "generatedAnnotationComment", 32, 0);
        commentText.setEnabled(generateGeneratedButton.getSelection());
        generateGeneratedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                includeDateButton.setEnabled(generateGeneratedButton.getSelection());
                commentText.setEnabled(generateGeneratedButton.getSelection());
            }
        });
    }

    protected void updateCombo(Combo curr) {
        if (curr == this.versionCombo) {
            this.updateVersionCombo();
        } else {
            super.updateCombo(curr);
        }
    }

    private void updateVersionCombo() {
        JavaVersion selectedVersion;
        String javaSourceOption;
        JavaVersion javaVersion;
        boolean useCompliance = this.useComplianceButton.getSelection();
        this.versionCombo.setEnabled(!useCompliance);
        if (useCompliance && (javaVersion = this.preferenceAccess.fromCompilerSourceLevel(javaSourceOption = this.javaValue("org.eclipse.jdt.core.compiler.source"))) != (selectedVersion = JavaVersion.values()[this.versionCombo.getSelectionIndex()])) {
            this.versionCombo.select(javaVersion.ordinal());
        }
    }

    protected String javaValue(String javaPreference) {
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        if (javaProject != null && javaProject.exists() && javaProject.getProject().isAccessible()) {
            return javaProject.getOption(javaPreference, true);
        }
        return JavaCore.getOption((String)javaPreference);
    }
}

