/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import java.util.Collection;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.ConflictingDefaultOperation;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideTester;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public abstract class AbstractResolvedFeatures {
    private final LightweightTypeReference type;
    private final OverrideTester overrideTester;

    protected AbstractResolvedFeatures(LightweightTypeReference type, OverrideTester overrideTester) {
        this.type = type;
        this.overrideTester = overrideTester;
    }

    protected boolean isOverridden(JvmOperation operation, Collection<AbstractResolvedOperation> processedOperations) {
        for (AbstractResolvedOperation processed : processedOperations) {
            if (!this.overrideTester.isSubsignature(processed, operation, false).isOverridingOrImplementing()) continue;
            return true;
        }
        return false;
    }

    protected BottomResolvedOperation createResolvedOperation(JvmOperation operation) {
        return new BottomResolvedOperation(operation, this.type, this.overrideTester);
    }

    protected ConflictingDefaultOperation createConflictingOperation(JvmOperation operation, IResolvedOperation ... conflictingOperations) {
        return new ConflictingDefaultOperation(operation, this.type, this.overrideTester, conflictingOperations);
    }

    protected BottomResolvedOperation createResolvedOperation(JvmOperation operation, LightweightTypeReference context) {
        return new BottomResolvedOperation(operation, context, this.overrideTester);
    }

    public LightweightTypeReference getType() {
        return this.type;
    }

    protected JvmType getRawType() {
        return this.type.getType();
    }
}

