/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.inject.Inject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.resource.IResourceUIServiceProvider;
import org.eclipse.xtext.ui.resource.IResourceUIServiceProviderExtension;

public class UriValidator {
    @Inject
    private IResourceServiceProvider.Registry registry = IResourceServiceProvider.Registry.INSTANCE;

    public boolean isValid(URI uri, IStorage storage) {
        if (uri == null) {
            return false;
        }
        IResourceServiceProvider resourceServiceProvider = this.registry.getResourceServiceProvider(uri);
        if (resourceServiceProvider != null) {
            if (resourceServiceProvider instanceof IResourceUIServiceProvider) {
                return ((IResourceUIServiceProvider)resourceServiceProvider).canHandle(uri, storage);
            }
            return resourceServiceProvider.canHandle(uri);
        }
        return false;
    }

    public boolean canBuild(URI uri, IStorage storage) {
        if (uri == null) {
            return false;
        }
        IResourceServiceProvider resourceServiceProvider = this.registry.getResourceServiceProvider(uri);
        if (resourceServiceProvider != null) {
            if (resourceServiceProvider instanceof IResourceUIServiceProviderExtension) {
                return ((IResourceUIServiceProviderExtension)resourceServiceProvider).canBuild(uri, storage);
            }
            if (resourceServiceProvider instanceof IResourceUIServiceProvider) {
                return ((IResourceUIServiceProvider)resourceServiceProvider).canHandle(uri, storage);
            }
            return resourceServiceProvider.canHandle(uri);
        }
        return false;
    }

    public boolean isPossiblyManaged(IStorage storage) {
        IPath fullPath = storage.getFullPath();
        if (fullPath == null) {
            return true;
        }
        if (!this.registry.getContentTypeToFactoryMap().isEmpty()) {
            return true;
        }
        return this.registry.getExtensionToFactoryMap().containsKey(fullPath.getFileExtension());
    }
}

