/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.config;

import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.data.validate.ValidationFailedException;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingErrorHandling
extends AbstractEditErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingErrorHandling.class);

    public LoggingErrorHandling() {
        super(null);
    }

    public LoggingErrorHandling(IEditErrorHandler underlyingErrorHandler) {
        super(underlyingErrorHandler);
    }

    @Override
    public void displayError(ICellEditor cellEditor, Exception e) {
        super.displayError(cellEditor, e);
        if (!(e instanceof ConversionFailedException) && !(e instanceof ValidationFailedException)) {
            LOG.warn(Messages.getString("LoggingErrorHandling.logPrefix"), (Throwable)e);
        } else {
            LOG.warn(Messages.getString("LoggingErrorHandling.logPrefix") + ": " + e.getLocalizedMessage());
        }
    }
}

