/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.ordered;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.factory.Stacks;
import org.eclipse.collections.api.multimap.ordered.OrderedIterableMultimap;
import org.eclipse.collections.api.ordered.primitive.OrderedBooleanIterable;
import org.eclipse.collections.api.ordered.primitive.OrderedByteIterable;
import org.eclipse.collections.api.ordered.primitive.OrderedCharIterable;
import org.eclipse.collections.api.ordered.primitive.OrderedDoubleIterable;
import org.eclipse.collections.api.ordered.primitive.OrderedFloatIterable;
import org.eclipse.collections.api.ordered.primitive.OrderedIntIterable;
import org.eclipse.collections.api.ordered.primitive.OrderedLongIterable;
import org.eclipse.collections.api.ordered.primitive.OrderedShortIterable;
import org.eclipse.collections.api.partition.ordered.PartitionOrderedIterable;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.tuple.Pair;

public interface OrderedIterable<T>
extends RichIterable<T> {
    default public int indexOf(Object object) {
        return this.detectIndex(each -> Objects.equals(each, object));
    }

    @Override
    public T getFirst();

    default public Optional<T> getFirstOptional() {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getFirst());
    }

    @Override
    public T getLast();

    default public Optional<T> getLastOptional() {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getLast());
    }

    @Override
    public OrderedIterable<T> tap(Procedure<? super T> var1);

    public OrderedIterable<T> takeWhile(Predicate<? super T> var1);

    public OrderedIterable<T> dropWhile(Predicate<? super T> var1);

    public PartitionOrderedIterable<T> partitionWhile(Predicate<? super T> var1);

    public OrderedIterable<T> distinct();

    public <S> boolean corresponds(OrderedIterable<S> var1, Predicate2<? super T, ? super S> var2);

    public void forEach(int var1, int var2, Procedure<? super T> var3);

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> var1);

    public void forEachWithIndex(int var1, int var2, ObjectIntProcedure<? super T> var3);

    default public MutableStack<T> toStack() {
        return Stacks.mutable.withAll(this);
    }

    @Override
    public T min();

    @Override
    public T max();

    @Override
    public OrderedIterable<T> select(Predicate<? super T> var1);

    @Override
    public <P> OrderedIterable<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public OrderedIterable<T> reject(Predicate<? super T> var1);

    @Override
    public <P> OrderedIterable<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public PartitionOrderedIterable<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionOrderedIterable<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> OrderedIterable<S> selectInstancesOf(Class<S> var1);

    @Override
    public <V> OrderedIterable<V> collect(Function<? super T, ? extends V> var1);

    default public <V> OrderedIterable<V> collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((T each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.valueOf(each, n);
        });
    }

    default public <V, R extends Collection<V>> R collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
        int[] index = new int[]{0};
        return this.collect(each -> {
            int n = index[0];
            index[0] = n + 1;
            return function.valueOf(each, n);
        }, target);
    }

    default public <R extends Collection<T>> R selectWithIndex(ObjectIntPredicate<? super T> predicate, R target) {
        int[] index = new int[]{0};
        return this.select(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        }, target);
    }

    default public <R extends Collection<T>> R rejectWithIndex(ObjectIntPredicate<? super T> predicate, R target) {
        int[] index = new int[]{0};
        return this.reject(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        }, target);
    }

    @Override
    public <P, V> OrderedIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public <V> OrderedIterable<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    @Override
    public <V> OrderedIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <P, V> OrderedIterable<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    @Override
    public OrderedBooleanIterable collectBoolean(BooleanFunction<? super T> var1);

    @Override
    public OrderedByteIterable collectByte(ByteFunction<? super T> var1);

    @Override
    public OrderedCharIterable collectChar(CharFunction<? super T> var1);

    @Override
    public OrderedDoubleIterable collectDouble(DoubleFunction<? super T> var1);

    @Override
    public OrderedFloatIterable collectFloat(FloatFunction<? super T> var1);

    @Override
    public OrderedIntIterable collectInt(IntFunction<? super T> var1);

    @Override
    public OrderedLongIterable collectLong(LongFunction<? super T> var1);

    @Override
    public OrderedShortIterable collectShort(ShortFunction<? super T> var1);

    public int detectIndex(Predicate<? super T> var1);

    @Override
    public <V> OrderedIterableMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    public <V> OrderedIterableMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    public <S> OrderedIterable<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> var1, R var2);

    @Override
    public OrderedIterable<Pair<T, Integer>> zipWithIndex();

    @Override
    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R var1);
}

