/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.config;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.style.ConfigAttribute;
import org.eclipse.nebula.widgets.nattable.style.DefaultDisplayModeOrdering;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.IDisplayModeOrdering;

public class ConfigRegistry
implements IConfigRegistry {
    Map<ConfigAttribute<?>, EnumMap<DisplayMode, Map<String, ?>>> registry = new HashMap();
    IDisplayModeOrdering displayModeOrdering = new DefaultDisplayModeOrdering();

    @Override
    public <T> T getConfigAttribute(ConfigAttribute<T> configAttribute, String targetDisplayMode, String ... configLabels) {
        return this.getConfigAttribute(configAttribute, targetDisplayMode, Arrays.asList(configLabels));
    }

    @Override
    public <T> T getConfigAttribute(ConfigAttribute<T> configAttribute, String targetDisplayMode, List<String> configLabels) {
        return this.getConfigAttribute(configAttribute, DisplayMode.valueOf(targetDisplayMode), configLabels);
    }

    @Override
    public <T> T getConfigAttribute(ConfigAttribute<T> configAttribute, DisplayMode targetDisplayMode, String ... configLabels) {
        return this.getConfigAttribute(configAttribute, targetDisplayMode, Arrays.asList(configLabels));
    }

    @Override
    public <T> T getConfigAttribute(ConfigAttribute<T> configAttribute, DisplayMode targetDisplayMode, List<String> configLabels) {
        T attributeValue = null;
        EnumMap<DisplayMode, Map<String, ?>> displayModeConfigAttributeMap = this.registry.get(configAttribute);
        if (displayModeConfigAttributeMap != null) {
            for (DisplayMode displayMode : this.displayModeOrdering.getDisplayModeOrdering(targetDisplayMode)) {
                Map<String, ?> configAttributeMap = displayModeConfigAttributeMap.get((Object)displayMode);
                if (configAttributeMap == null) continue;
                for (String configLabel : configLabels) {
                    attributeValue = (T)configAttributeMap.get(configLabel);
                    if (attributeValue == null) continue;
                    return attributeValue;
                }
                attributeValue = (T)configAttributeMap.get(null);
                if (attributeValue == null) continue;
                return attributeValue;
            }
        }
        return attributeValue;
    }

    @Override
    public <T> T getSpecificConfigAttribute(ConfigAttribute<T> configAttribute, String displayMode, String configLabel) {
        return this.getSpecificConfigAttribute(configAttribute, DisplayMode.valueOf(displayMode), configLabel);
    }

    @Override
    public <T> T getSpecificConfigAttribute(ConfigAttribute<T> configAttribute, DisplayMode displayMode, String configLabel) {
        Map<String, ?> configAttributeMap;
        T attributeValue = null;
        EnumMap<DisplayMode, Map<String, ?>> displayModeConfigAttributeMap = this.registry.get(configAttribute);
        if (displayModeConfigAttributeMap != null && (configAttributeMap = displayModeConfigAttributeMap.get((Object)displayMode)) != null && (attributeValue = (T)configAttributeMap.get(configLabel)) != null) {
            return attributeValue;
        }
        return attributeValue;
    }

    @Override
    public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue) {
        this.registerConfigAttribute(configAttribute, attributeValue, DisplayMode.NORMAL, null);
    }

    @Override
    public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue, String displayMode) {
        this.registerConfigAttribute(configAttribute, attributeValue, DisplayMode.valueOf(displayMode), null);
    }

    @Override
    public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue, DisplayMode targetDisplayMode) {
        this.registerConfigAttribute(configAttribute, attributeValue, targetDisplayMode, null);
    }

    @Override
    public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue, String displayMode, String configLabel) {
        this.registerConfigAttribute(configAttribute, attributeValue, DisplayMode.valueOf(displayMode), configLabel);
    }

    @Override
    public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue, DisplayMode targetDisplayMode, String configLabel) {
        EnumMap displayModeConfigAttributeMap = this.registry.computeIfAbsent(configAttribute, cf -> new EnumMap(DisplayMode.class));
        Map configAttributeMap = displayModeConfigAttributeMap.computeIfAbsent(targetDisplayMode, dm -> new HashMap());
        configAttributeMap.put(configLabel, attributeValue);
    }

    @Override
    public <T> void unregisterConfigAttribute(ConfigAttribute<T> configAttributeType) {
        this.unregisterConfigAttribute(configAttributeType, DisplayMode.NORMAL, null);
    }

    @Override
    public <T> void unregisterConfigAttribute(ConfigAttribute<T> configAttributeType, String displayMode) {
        this.unregisterConfigAttribute(configAttributeType, DisplayMode.valueOf(displayMode), null);
    }

    @Override
    public <T> void unregisterConfigAttribute(ConfigAttribute<T> configAttributeType, DisplayMode displayMode) {
        this.unregisterConfigAttribute(configAttributeType, displayMode, null);
    }

    @Override
    public <T> void unregisterConfigAttribute(ConfigAttribute<T> configAttributeType, String displayMode, String configLabel) {
        this.unregisterConfigAttribute(configAttributeType, DisplayMode.valueOf(displayMode), configLabel);
    }

    @Override
    public <T> void unregisterConfigAttribute(ConfigAttribute<T> configAttributeType, DisplayMode displayMode, String configLabel) {
        Map<String, ?> configAttributeMap;
        EnumMap<DisplayMode, Map<String, ?>> displayModeConfigAttributeMap = this.registry.get(configAttributeType);
        if (displayModeConfigAttributeMap != null && (configAttributeMap = displayModeConfigAttributeMap.get((Object)displayMode)) != null) {
            configAttributeMap.remove(configLabel);
        }
    }

    @Override
    public IDisplayModeOrdering getDisplayModeOrdering() {
        return this.displayModeOrdering;
    }

    public void setDisplayModeOrdering(IDisplayModeOrdering displayModeOrdering) {
        this.displayModeOrdering = displayModeOrdering;
    }
}

