/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.decorators.DecorationBuilder;
import org.eclipse.ui.internal.decorators.DecorationReference;
import org.eclipse.ui.internal.decorators.DecorationResult;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class DecorationScheduler {
    private static final ILabelProviderListener[] EMPTY_LISTENER_LIST = new ILabelProviderListener[0];
    private final Map<IDecorationContext, Map<Object, DecorationResult>> resultCache = new ConcurrentHashMap<IDecorationContext, Map<Object, DecorationResult>>();
    private final Set<Object> pendingUpdate = new LinkedHashSet<Object>();
    private final LinkedHashMap<Object, DecorationReference> awaitingDecoration = new LinkedHashMap();
    private boolean shutdown = false;
    private final DecoratorManager decoratorManager;
    private final Job decorationJob;
    private final JobChangeListener jobFinishListener = new JobChangeListener();
    private UIJob updateJob;
    private Collection<ILabelProviderListener> removedListeners = Collections.synchronizedSet(new HashSet());
    private Job clearJob;
    private static final int NEEDS_INIT = -1;
    private static final int UPDATE_DELAY = 100;
    private boolean isUpdateJobRunning = false;

    DecorationScheduler(DecoratorManager manager) {
        this.decoratorManager = manager;
        this.decorationJob = this.createDecorationJob();
    }

    public String decorateWithText(String text, Object element, Object adaptedElement, IDecorationContext context) {
        DecorationResult decoration = this.getResult(element, adaptedElement, context);
        if (decoration == null) {
            return text;
        }
        return decoration.decorateWithText(text);
    }

    synchronized void queueForDecoration(Object element, Object adaptedElement, boolean forceUpdate, String undecoratedText, IDecorationContext context) {
        Assert.isNotNull((Object)context);
        DecorationReference reference = this.awaitingDecoration.get(element);
        if (reference != null) {
            if (forceUpdate) {
                reference.setForceUpdate(forceUpdate);
            }
            reference.addContext(context);
        } else {
            reference = new DecorationReference(element, adaptedElement, context);
            reference.setForceUpdate(forceUpdate);
            reference.setUndecoratedText(undecoratedText);
            this.awaitingDecoration.put(element, reference);
            if (this.shutdown) {
                return;
            }
            this.schedule();
        }
    }

    void schedule() {
        this.decorationJob.schedule();
    }

    public Image decorateWithOverlays(Image image, Object element, Object adaptedElement, IDecorationContext context, ResourceManager manager) {
        DecorationResult decoration = this.getResult(element, adaptedElement, context);
        if (decoration == null) {
            return image;
        }
        return decoration.decorateWithOverlays(image, manager);
    }

    private DecorationResult getResult(Object element, Object adaptedElement, IDecorationContext context) {
        if (element == null) {
            return null;
        }
        DecorationResult decoration = this.internalGetResult(element, context);
        if (decoration == null) {
            this.queueForDecoration(element, adaptedElement, false, null, context);
            return null;
        }
        return decoration;
    }

    private DecorationResult internalGetResult(Object element, IDecorationContext context) {
        Map<Object, DecorationResult> results = this.resultCache.get(context);
        if (results != null) {
            return results.get(element);
        }
        return null;
    }

    protected void internalPutResult(Object element, IDecorationContext context, DecorationResult result) {
        Map results = this.resultCache.computeIfAbsent(context, ctx -> new ConcurrentHashMap());
        results.put(element, result);
    }

    synchronized void scheduleUpdateJob() {
        if (this.shutdown) {
            return;
        }
        if (this.updateJob == null) {
            this.updateJob = this.getUpdateJob();
        }
        this.updateJob.schedule(100L);
    }

    synchronized void shutdown() {
        this.shutdown = true;
    }

    synchronized DecorationReference removeNextReference() {
        Iterator<Map.Entry<Object, DecorationReference>> iterator = this.awaitingDecoration.entrySet().iterator();
        if (this.shutdown || !iterator.hasNext()) {
            return null;
        }
        Map.Entry<Object, DecorationReference> entry = iterator.next();
        iterator.remove();
        DecorationReference reference = entry.getValue();
        return reference;
    }

    private Job createDecorationJob() {
        Job decorationJob = new Job(WorkbenchMessages.DecorationScheduler_CalculationJobName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public IStatus run(IProgressMonitor monitor) {
                var2_2 = DecorationScheduler.this;
                synchronized (var2_2) {
                    if (DecorationScheduler.this.shutdown) {
                        return Status.CANCEL_STATUS;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (true) ** GOTO lbl17
                }
                do {
                    try {
                        DecorationScheduler.this.jobFinishListener.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        this.schedule();
                        return Status.CANCEL_STATUS;
                    }
lbl17:
                    // 2 sources

                } while (DecorationScheduler.this.updatesPending());
                subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)WorkbenchMessages.DecorationScheduler_CalculatingTask, (int)(DecorationScheduler.this.awaitingDecoration.size() + 1));
                queued = false;
                while ((reference = DecorationScheduler.this.removeNextReference()) != null) {
                    subMonitor.split(1);
                    queued = true;
                    element = reference.getElement();
                    force = reference.shouldForceUpdate();
                    contexts = reference.getContexts();
                    for (IDecorationContext context : contexts) {
                        queued |= this.queue(element, force, context);
                    }
                    subMonitor.setWorkRemaining(DecorationScheduler.this.awaitingDecoration.size() + 1);
                }
                if (queued) {
                    DecorationScheduler.this.scheduleUpdateJob();
                }
                return Status.OK_STATUS;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean queue(Object element, boolean force, IDecorationContext context) {
                DecorationBuilder cacheResult = new DecorationBuilder(context);
                DecorationScheduler.this.decoratorManager.getLightweightManager().getDecorations(element, cacheResult);
                if (cacheResult.hasValue() || force) {
                    DecorationScheduler.this.internalPutResult(element, context, cacheResult.createResult());
                    Set<Object> set = DecorationScheduler.this.pendingUpdate;
                    synchronized (set) {
                        DecorationScheduler.this.pendingUpdate.add(element);
                    }
                    return true;
                }
                return false;
            }

            public boolean belongsTo(Object family) {
                return DecoratorManager.FAMILY_DECORATE == family;
            }

            public boolean shouldRun() {
                return PlatformUI.isWorkbenchRunning();
            }
        };
        decorationJob.setSystem(true);
        decorationJob.setPriority(50);
        return decorationJob;
    }

    protected boolean updatesPending() {
        if (this.updateJob != null && this.updateJob.getState() != 0) {
            return true;
        }
        return this.clearJob != null && this.clearJob.getState() != 0;
    }

    void clearResults() {
        if (this.clearJob == null) {
            this.clearJob = this.getClearJob();
        }
        this.clearJob.schedule();
    }

    private Job getClearJob() {
        Job clear = new Job(WorkbenchMessages.DecorationScheduler_ClearResultsJob){

            protected IStatus run(IProgressMonitor monitor) {
                DecorationScheduler.this.resultCache.clear();
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                return PlatformUI.isWorkbenchRunning();
            }
        };
        clear.setSystem(true);
        clear.addJobChangeListener((IJobChangeListener)this.jobFinishListener);
        return clear;
    }

    private WorkbenchJob getUpdateJob() {
        WorkbenchJob job = new WorkbenchJob(WorkbenchMessages.DecorationScheduler_UpdateJobName){
            int currentIndex;
            LabelProviderChangedEvent labelProviderChangedEvent;
            ILabelProviderListener[] listeners;
            {
                this.currentIndex = -1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                DecorationScheduler.this.isUpdateJobRunning = true;
                try {
                    DecorationScheduler decorationScheduler = DecorationScheduler.this;
                    synchronized (decorationScheduler) {
                        if (DecorationScheduler.this.shutdown) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    }
                    if (this.currentIndex == -1) {
                        if (DecorationScheduler.this.hasPendingUpdates()) {
                            this.resetState();
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        this.setUpUpdates();
                    }
                    if (this.listeners.length == 0) {
                        this.resetState();
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    monitor.beginTask(WorkbenchMessages.DecorationScheduler_UpdatingTask, -1);
                    long startTime = System.currentTimeMillis();
                    while (this.currentIndex < this.listeners.length) {
                        ILabelProviderListener listener = this.listeners[this.currentIndex];
                        ++this.currentIndex;
                        if (!DecorationScheduler.this.removedListeners.contains(listener)) {
                            DecorationScheduler.this.decoratorManager.fireListener(this.labelProviderChangedEvent, listener);
                        }
                        if (System.currentTimeMillis() - startTime >= 50L) break;
                    }
                    monitor.done();
                    if (this.currentIndex >= this.listeners.length) {
                        this.resetState();
                        if (!DecorationScheduler.this.hasPendingUpdates()) {
                            DecorationScheduler.this.scheduleUpdateJob();
                        }
                        this.labelProviderChangedEvent = null;
                        this.listeners = EMPTY_LISTENER_LIST;
                    } else {
                        this.schedule(100L);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    DecorationScheduler.this.isUpdateJobRunning = false;
                }
            }

            private void resetState() {
                this.currentIndex = -1;
                DecorationScheduler.this.removedListeners.clear();
                if (DecorationScheduler.this.awaitingDecoration.isEmpty()) {
                    DecorationScheduler.this.resultCache.clear();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void setUpUpdates() {
                DecorationScheduler.this.removedListeners.clear();
                this.currentIndex = 0;
                Set<Object> set = DecorationScheduler.this.pendingUpdate;
                synchronized (set) {
                    Object[] elements = DecorationScheduler.this.pendingUpdate.toArray(new Object[DecorationScheduler.this.pendingUpdate.size()]);
                    DecorationScheduler.this.pendingUpdate.clear();
                    this.labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)DecorationScheduler.this.decoratorManager, elements);
                }
                this.listeners = DecorationScheduler.this.decoratorManager.getListeners();
            }

            public boolean belongsTo(Object family) {
                return DecoratorManager.FAMILY_DECORATE == family;
            }

            @Override
            public boolean shouldRun() {
                return PlatformUI.isWorkbenchRunning();
            }
        };
        job.setSystem(true);
        job.addJobChangeListener((IJobChangeListener)this.jobFinishListener);
        return job;
    }

    public boolean isDecorationReady(Object element, IDecorationContext context) {
        if (this.isUpdateJobRunning) {
            return this.internalGetResult(element, context) != null;
        }
        return false;
    }

    public Color getBackgroundColor(Object element, Object adaptedElement) {
        DecorationResult decoration = this.getResult(element, adaptedElement, DecorationContext.DEFAULT_CONTEXT);
        if (decoration == null) {
            return null;
        }
        return decoration.getBackgroundColor();
    }

    public Font getFont(Object element, Object adaptedElement) {
        DecorationResult decoration = this.getResult(element, adaptedElement, DecorationContext.DEFAULT_CONTEXT);
        if (decoration == null) {
            return null;
        }
        return decoration.getFont();
    }

    public Color getForegroundColor(Object element, Object adaptedElement) {
        DecorationResult decoration = this.getResult(element, adaptedElement, DecorationContext.DEFAULT_CONTEXT);
        if (decoration == null) {
            return null;
        }
        return decoration.getForegroundColor();
    }

    void listenerRemoved(ILabelProviderListener listener) {
        if (this.updatesPending()) {
            this.removedListeners.add(listener);
        }
        if (!this.updatesPending()) {
            this.removedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasPendingUpdates() {
        Set<Object> set = this.pendingUpdate;
        synchronized (set) {
            return this.pendingUpdate.isEmpty();
        }
    }

    private final class JobChangeListener
    extends JobChangeAdapter {
        private JobChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            JobChangeListener jobChangeListener = this;
            synchronized (jobChangeListener) {
                if (!DecorationScheduler.this.updatesPending()) {
                    ((Object)((Object)this)).notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sleep(long timeoutMillis) throws InterruptedException {
            JobChangeListener jobChangeListener = this;
            synchronized (jobChangeListener) {
                if (DecorationScheduler.this.updatesPending()) {
                    ((Object)((Object)this)).wait(timeoutMillis);
                }
            }
        }
    }
}

