/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;

public class NoOpResponseParser
extends ResponseParser {
    private String writerType = "xml";

    public NoOpResponseParser() {
    }

    public NoOpResponseParser(String writerType) {
        this.writerType = writerType;
    }

    @Override
    public String getWriterType() {
        return this.writerType;
    }

    public void setWriterType(String writerType) {
        this.writerType = writerType;
    }

    @Override
    public NamedList<Object> processResponse(Reader reader) {
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((Reader)reader, (Writer)writer);
            String output = writer.toString();
            NamedList<Object> list = new NamedList<Object>();
            list.add("response", output);
            return list;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", (Throwable)e);
        }
    }

    @Override
    public NamedList<Object> processResponse(InputStream body, String encoding) {
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)body, (Writer)writer, (String)encoding);
            String output = writer.toString();
            NamedList<Object> list = new NamedList<Object>();
            list.add("response", output);
            return list;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", (Throwable)e);
        }
    }
}

