/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.paths;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

public class SimplePath
extends Path {
    private final IRI predicate;

    public SimplePath(IRI predicate) {
        super(predicate);
        this.predicate = predicate;
    }

    @Override
    public Resource getId() {
        return this.predicate;
    }

    @Override
    public PlanNode getAllAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNodeWrapper planNodeWrapper) {
        PlanNode unorderedSelect = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, this.predicate, null, dataGraph, UnorderedSelect.Mapper.SubjectObjectPropertyShapeMapper.getFunction(), null);
        if (planNodeWrapper != null) {
            unorderedSelect = (PlanNode)planNodeWrapper.apply(unorderedSelect);
        }
        return connectionsGroup.getCachedNodeFor(unorderedSelect);
    }

    @Override
    public PlanNode getAnyAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNodeWrapper planNodeWrapper) {
        return this.getAllAdded(connectionsGroup, dataGraph, planNodeWrapper);
    }

    public String toString() {
        return "SimplePath{ <" + String.valueOf(this.predicate) + "> }";
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
    }

    @Override
    public SparqlFragment getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, Set<String> inheritedVarNames) {
        StatementMatcher statementMatcher = new StatementMatcher(subject, new StatementMatcher.Variable<IRI>(this.predicate), object, this, inheritedVarNames);
        return SparqlFragment.bgp(List.of(), subject.asSparqlVariable() + " <" + String.valueOf(this.predicate) + "> " + object.asSparqlVariable() + " .", statementMatcher, (connectionsGroup, dataGraph, path, currentStatementMatcher, currentStatements) -> {
            if (currentStatementMatcher.getOrigin() == this) {
                if (currentStatementMatcher != statementMatcher) {
                    return null;
                }
                return Stream.of(new EffectiveTarget.SubjectObjectAndMatcher(currentStatements, currentStatementMatcher));
            }
            if (currentStatementMatcher.hasSubject(object)) {
                List<EffectiveTarget.SubjectObjectAndMatcher.SubjectObject> newStatements = currentStatements.stream().map(currentStatement -> {
                    try (CloseableIteration<? extends Statement> statements = connectionsGroup.getBaseConnection().getStatements(null, this.predicate, currentStatement.getSubject(), true, dataGraph);){
                        List<? extends Statement> list = QueryResults.asList(statements);
                        return list;
                    }
                }).flatMap(Collection::stream).map(EffectiveTarget.SubjectObjectAndMatcher.SubjectObject::new).collect(Collectors.toList());
                return Stream.of(new EffectiveTarget.SubjectObjectAndMatcher(newStatements, statementMatcher));
            }
            if (currentStatementMatcher.hasObject(object)) {
                List<EffectiveTarget.SubjectObjectAndMatcher.SubjectObject> newStatements = currentStatements.stream().map(currentStatement -> {
                    try (CloseableIteration<? extends Statement> statements = connectionsGroup.getBaseConnection().getStatements(null, this.predicate, currentStatement.getObject(), true, dataGraph);){
                        List<? extends Statement> list = QueryResults.asList(statements);
                        return list;
                    }
                }).flatMap(Collection::stream).map(EffectiveTarget.SubjectObjectAndMatcher.SubjectObject::new).collect(Collectors.toList());
                return Stream.of(new EffectiveTarget.SubjectObjectAndMatcher(newStatements, statementMatcher));
            }
            return null;
        });
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String toSparqlPathString() {
        return "<" + String.valueOf(this.predicate) + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimplePath that = (SimplePath)o;
        return this.predicate.equals(that.predicate);
    }

    public int hashCode() {
        return this.predicate.hashCode();
    }
}

