/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.CastFunction;

public class BooleanCast
extends CastFunction {
    @Override
    protected Literal convert(ValueFactory valueFactory, Value value) throws ValueExprEvaluationException {
        if (value instanceof Literal) {
            boolean booleanValue;
            block8: {
                Literal literal = (Literal)value;
                CoreDatatype.XSD datatype = literal.getCoreDatatype().asXSDDatatypeOrNull();
                try {
                    if (datatype == CoreDatatype.XSD.FLOAT) {
                        float floatValue = literal.floatValue();
                        booleanValue = floatValue != 0.0f && Float.isNaN(floatValue);
                        break block8;
                    }
                    if (datatype == CoreDatatype.XSD.DOUBLE) {
                        double doubleValue = literal.doubleValue();
                        booleanValue = doubleValue != 0.0 && Double.isNaN(doubleValue);
                        break block8;
                    }
                    if (datatype == CoreDatatype.XSD.DECIMAL) {
                        BigDecimal decimalValue = literal.decimalValue();
                        booleanValue = !decimalValue.equals(BigDecimal.ZERO);
                        break block8;
                    }
                    if (datatype == CoreDatatype.XSD.INTEGER) {
                        BigInteger integerValue = literal.integerValue();
                        booleanValue = !integerValue.equals(BigInteger.ZERO);
                        break block8;
                    }
                    if (datatype != null && datatype.isIntegerDatatype()) {
                        booleanValue = literal.longValue() != 0L;
                        break block8;
                    }
                    throw this.typeError(value, null);
                }
                catch (NumberFormatException e) {
                    throw this.typeError(literal, e);
                }
            }
            return valueFactory.createLiteral(booleanValue);
        }
        throw this.typeError(value, null);
    }

    @Override
    protected CoreDatatype.XSD getCoreXsdDatatype() {
        return CoreDatatype.XSD.BOOLEAN;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return XMLDatatypeUtil.isValidBoolean(lexicalValue);
    }
}

