/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import java.util.Objects;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;

public class QueryEvaluationUtil {
    public static final ValueExprEvaluationException INDETERMINATE_DATE_TIME_EXCEPTION = new ValueExprEvaluationException("Indeterminate result for date/time comparison");
    public static final ValueExprEvaluationException STRING_WITH_OTHER_SUPPORTED_TYPE_EXCEPTION = new ValueExprEvaluationException("Unable to compare strings with other supported types");
    public static final ValueExprEvaluationException NUMERIC_WITH_OTHER_SUPPORTED_TYPE_EXCEPTION = new ValueExprEvaluationException("Unable to compare numeric types with other supported types");
    public static final ValueExprEvaluationException DATE_WITH_OTHER_SUPPORTED_TYPE_EXCEPTION = new ValueExprEvaluationException("Unable to compare date types with other supported types");
    public static final ValueExprEvaluationException UNSUPPOERTED_TYPES_EXCEPTION = new ValueExprEvaluationException("Unable to compare literals with unsupported types");
    public static final ValueExprEvaluationException NOT_COMPATIBLE_AND_ORDERED_EXCEPTION = new ValueExprEvaluationException("Only literals with compatible, ordered datatypes can be compared using <, <=, > and >= operators");

    public static boolean getEffectiveBooleanValue(Value value) throws ValueExprEvaluationException {
        if (value == BooleanLiteral.TRUE) {
            return true;
        }
        if (value == BooleanLiteral.FALSE) {
            return false;
        }
        if (value.isLiteral()) {
            Literal literal = (Literal)value;
            String label = literal.getLabel();
            CoreDatatype.XSD datatype = literal.getCoreDatatype().asXSDDatatypeOrNull();
            if (datatype == CoreDatatype.XSD.STRING) {
                return !label.isEmpty();
            }
            if (datatype == CoreDatatype.XSD.BOOLEAN) {
                return "true".equals(label) || "1".equals(label);
            }
            if (datatype == CoreDatatype.XSD.DECIMAL) {
                try {
                    String normDec = XMLDatatypeUtil.normalizeDecimal(label);
                    return !normDec.equals("0.0");
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if (datatype != null && datatype.isIntegerDatatype()) {
                try {
                    String normInt = XMLDatatypeUtil.normalize(label, datatype);
                    return !normInt.equals("0");
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if (datatype != null && datatype.isFloatingPointDatatype()) {
                try {
                    String normFP = XMLDatatypeUtil.normalize(label, datatype);
                    return !normFP.equals("0.0E0") && !normFP.equals("NaN");
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
        }
        throw new ValueExprEvaluationException();
    }

    public static boolean compare(Value leftVal, Value rightVal, Compare.CompareOp operator) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compare(leftVal, rightVal, operator, true);
    }

    public static boolean compare(Value leftVal, Value rightVal, Compare.CompareOp operator, boolean strict) throws ValueExprEvaluationException {
        if (leftVal == rightVal) {
            switch (operator) {
                case EQ: {
                    return true;
                }
                case NE: {
                    return false;
                }
            }
        }
        if (leftVal != null && leftVal.isLiteral() && rightVal != null && rightVal.isLiteral()) {
            return QueryEvaluationUtil.compareLiterals((Literal)leftVal, (Literal)rightVal, operator, strict);
        }
        switch (operator) {
            case EQ: {
                return Objects.equals(leftVal, rightVal);
            }
            case NE: {
                return !Objects.equals(leftVal, rightVal);
            }
        }
        throw new ValueExprEvaluationException("Only literals with compatible, ordered datatypes can be compared using <, <=, > and >= operators");
    }

    public static boolean compareLiterals(Literal leftLit, Literal rightLit, Compare.CompareOp operator) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareLiterals(leftLit, rightLit, operator, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean compareLiterals(Literal leftLit, Literal rightLit, Compare.CompareOp operator, boolean strict) throws ValueExprEvaluationException {
        CoreDatatype.XSD commonDatatype;
        if (leftLit == rightLit) {
            switch (operator) {
                case EQ: {
                    return true;
                }
                case NE: {
                    return false;
                }
            }
        }
        CoreDatatype.XSD leftCoreDatatype = leftLit.getCoreDatatype().asXSDDatatypeOrNull();
        CoreDatatype.XSD rightCoreDatatype = rightLit.getCoreDatatype().asXSDDatatypeOrNull();
        boolean leftLangLit = Literals.isLanguageLiteral(leftLit);
        boolean rightLangLit = Literals.isLanguageLiteral(rightLit);
        if (QueryEvaluationUtil.isSimpleLiteral(leftLangLit, leftCoreDatatype) && QueryEvaluationUtil.isSimpleLiteral(rightLangLit, rightCoreDatatype)) {
            return QueryEvaluationUtil.compareWithOperator(operator, leftLit.getLabel().compareTo(rightLit.getLabel()));
        }
        if (leftLangLit || rightLangLit || (commonDatatype = QueryEvaluationUtil.getCommonDatatype(strict, leftCoreDatatype, rightCoreDatatype)) == null) return QueryEvaluationUtil.otherCases(leftLit, rightLit, operator, leftCoreDatatype, rightCoreDatatype, leftLangLit, rightLangLit, strict);
        try {
            if (commonDatatype == CoreDatatype.XSD.DOUBLE) {
                return QueryEvaluationUtil.compareWithOperator(operator, Double.compare(leftLit.doubleValue(), rightLit.doubleValue()));
            }
            if (commonDatatype == CoreDatatype.XSD.FLOAT) {
                return QueryEvaluationUtil.compareWithOperator(operator, Float.compare(leftLit.floatValue(), rightLit.floatValue()));
            }
            if (commonDatatype == CoreDatatype.XSD.DECIMAL) {
                return QueryEvaluationUtil.compareWithOperator(operator, leftLit.decimalValue().compareTo(rightLit.decimalValue()));
            }
            if (commonDatatype.isIntegerDatatype()) {
                return QueryEvaluationUtil.compareWithOperator(operator, leftLit.integerValue().compareTo(rightLit.integerValue()));
            }
            if (commonDatatype == CoreDatatype.XSD.BOOLEAN) {
                return QueryEvaluationUtil.compareWithOperator(operator, Boolean.compare(leftLit.booleanValue(), rightLit.booleanValue()));
            }
            if (commonDatatype.isCalendarDatatype()) {
                XMLGregorianCalendar right;
                XMLGregorianCalendar left = leftLit.calendarValue();
                int compare = left.compare(right = rightLit.calendarValue());
                if (compare != 2) return QueryEvaluationUtil.compareWithOperator(operator, compare);
                if (leftCoreDatatype != CoreDatatype.XSD.DATETIME || rightCoreDatatype != CoreDatatype.XSD.DATETIME) return QueryEvaluationUtil.otherCases(leftLit, rightLit, operator, leftCoreDatatype, rightCoreDatatype, leftLangLit, rightLangLit, strict);
                throw INDETERMINATE_DATE_TIME_EXCEPTION;
            } else {
                if (!strict && commonDatatype.isDurationDatatype()) {
                    Duration right;
                    Duration left = XMLDatatypeUtil.parseDuration(leftLit.getLabel());
                    int compare = left.compare(right = XMLDatatypeUtil.parseDuration(rightLit.getLabel()));
                    if (compare == 2) return QueryEvaluationUtil.otherCases(leftLit, rightLit, operator, leftCoreDatatype, rightCoreDatatype, leftLangLit, rightLangLit, strict);
                    return QueryEvaluationUtil.compareWithOperator(operator, compare);
                }
                if (commonDatatype != CoreDatatype.XSD.STRING) return QueryEvaluationUtil.otherCases(leftLit, rightLit, operator, leftCoreDatatype, rightCoreDatatype, leftLangLit, rightLangLit, strict);
                return QueryEvaluationUtil.compareWithOperator(operator, leftLit.getLabel().compareTo(rightLit.getLabel()));
            }
        }
        catch (IllegalArgumentException e) {
            if (!leftLit.equals(rightLit)) throw new ValueExprEvaluationException(e);
            switch (operator) {
                case EQ: {
                    return true;
                }
                case NE: {
                    return false;
                }
            }
            throw new ValueExprEvaluationException(e);
        }
    }

    private static boolean otherCases(Literal leftLit, Literal rightLit, Compare.CompareOp operator, CoreDatatype.XSD leftCoreDatatype, CoreDatatype.XSD rightCoreDatatype, boolean leftLangLit, boolean rightLangLit, boolean strict) {
        boolean literalsEqual = leftLit.equals(rightLit);
        if (!literalsEqual) {
            if (!leftLangLit && !rightLangLit && QueryEvaluationUtil.isSupportedDatatype(leftCoreDatatype) && QueryEvaluationUtil.isSupportedDatatype(rightCoreDatatype)) {
                if (!XMLDatatypeUtil.isValidValue(leftLit.getLabel(), leftCoreDatatype)) {
                    throw new ValueExprEvaluationException("not a valid datatype value: " + String.valueOf(leftLit));
                }
                if (!XMLDatatypeUtil.isValidValue(rightLit.getLabel(), rightCoreDatatype)) {
                    throw new ValueExprEvaluationException("not a valid datatype value: " + String.valueOf(rightLit));
                }
                QueryEvaluationUtil.validateDatatypeCompatibility(strict, leftCoreDatatype, rightCoreDatatype);
            } else if (!leftLangLit && !rightLangLit) {
                throw UNSUPPOERTED_TYPES_EXCEPTION;
            }
        }
        switch (operator) {
            case EQ: {
                return literalsEqual;
            }
            case NE: {
                return !literalsEqual;
            }
            case LT: 
            case LE: 
            case GE: 
            case GT: {
                throw NOT_COMPATIBLE_AND_ORDERED_EXCEPTION;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + String.valueOf((Object)operator));
    }

    private static void validateDatatypeCompatibility(boolean strict, CoreDatatype.XSD leftCoreDatatype, CoreDatatype.XSD rightCoreDatatype) throws ValueExprEvaluationException {
        boolean rightDate;
        boolean rightNumeric;
        boolean rightString;
        if (!strict) {
            return;
        }
        boolean leftString = leftCoreDatatype == CoreDatatype.XSD.STRING;
        boolean bl = rightString = rightCoreDatatype == CoreDatatype.XSD.STRING;
        if (leftString != rightString) {
            throw STRING_WITH_OTHER_SUPPORTED_TYPE_EXCEPTION;
        }
        boolean leftNumeric = leftCoreDatatype.isNumericDatatype();
        if (leftNumeric != (rightNumeric = rightCoreDatatype.isNumericDatatype())) {
            throw NUMERIC_WITH_OTHER_SUPPORTED_TYPE_EXCEPTION;
        }
        boolean leftDate = leftCoreDatatype.isCalendarDatatype();
        if (leftDate != (rightDate = rightCoreDatatype.isCalendarDatatype())) {
            throw DATE_WITH_OTHER_SUPPORTED_TYPE_EXCEPTION;
        }
    }

    private static CoreDatatype.XSD getCommonDatatype(boolean strict, CoreDatatype.XSD leftCoreDatatype, CoreDatatype.XSD rightCoreDatatype) {
        if (leftCoreDatatype != null && rightCoreDatatype != null) {
            if (leftCoreDatatype == rightCoreDatatype) {
                return leftCoreDatatype;
            }
            if (leftCoreDatatype.isNumericDatatype() && rightCoreDatatype.isNumericDatatype()) {
                if (leftCoreDatatype == CoreDatatype.XSD.DOUBLE || rightCoreDatatype == CoreDatatype.XSD.DOUBLE) {
                    return CoreDatatype.XSD.DOUBLE;
                }
                if (leftCoreDatatype == CoreDatatype.XSD.FLOAT || rightCoreDatatype == CoreDatatype.XSD.FLOAT) {
                    return CoreDatatype.XSD.FLOAT;
                }
                if (leftCoreDatatype == CoreDatatype.XSD.DECIMAL || rightCoreDatatype == CoreDatatype.XSD.DECIMAL) {
                    return CoreDatatype.XSD.DECIMAL;
                }
                return CoreDatatype.XSD.INTEGER;
            }
            if (!strict && leftCoreDatatype.isCalendarDatatype() && rightCoreDatatype.isCalendarDatatype()) {
                return CoreDatatype.XSD.DATETIME;
            }
            if (!strict && leftCoreDatatype.isDurationDatatype() && rightCoreDatatype.isDurationDatatype()) {
                return CoreDatatype.XSD.DURATION;
            }
        }
        return null;
    }

    private static boolean compareWithOperator(Compare.CompareOp operator, int i) {
        switch (operator) {
            case LT: {
                return i < 0;
            }
            case LE: {
                return i <= 0;
            }
            case EQ: {
                return i == 0;
            }
            case NE: {
                return i != 0;
            }
            case GE: {
                return i >= 0;
            }
            case GT: {
                return i > 0;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + String.valueOf((Object)operator));
    }

    public static boolean isPlainLiteral(Value v) {
        if (v.isLiteral()) {
            return QueryEvaluationUtil.isPlainLiteral((Literal)v);
        }
        return false;
    }

    public static boolean isPlainLiteral(Literal l) {
        assert (l.getLanguage().isEmpty() || l.getCoreDatatype() == CoreDatatype.RDF.LANGSTRING);
        return l.getCoreDatatype() == CoreDatatype.XSD.STRING || l.getCoreDatatype() == CoreDatatype.RDF.LANGSTRING;
    }

    public static boolean isSimpleLiteral(Value v) {
        if (v.isLiteral()) {
            return QueryEvaluationUtil.isSimpleLiteral((Literal)v);
        }
        return false;
    }

    public static boolean isSimpleLiteral(Literal l) {
        return l.getCoreDatatype() == CoreDatatype.XSD.STRING && !Literals.isLanguageLiteral(l);
    }

    public static boolean isSimpleLiteral(boolean isLang, CoreDatatype datatype) {
        return !isLang && datatype == CoreDatatype.XSD.STRING;
    }

    public static boolean isStringLiteral(Value v) {
        if (v.isLiteral()) {
            return QueryEvaluationUtil.isStringLiteral((Literal)v);
        }
        return false;
    }

    public static boolean compatibleArguments(Literal arg1, Literal arg2) {
        return QueryEvaluationUtil.isSimpleLiteral(arg1) && QueryEvaluationUtil.isSimpleLiteral(arg2) || Literals.isLanguageLiteral(arg1) && Literals.isLanguageLiteral(arg2) && arg1.getLanguage().equals(arg2.getLanguage()) || Literals.isLanguageLiteral(arg1) && QueryEvaluationUtil.isSimpleLiteral(arg2);
    }

    public static boolean isStringLiteral(Literal l) {
        return l.getCoreDatatype() == CoreDatatype.XSD.STRING || Literals.isLanguageLiteral(l);
    }

    private static boolean isSupportedDatatype(CoreDatatype.XSD datatype) {
        return datatype != null && (datatype == CoreDatatype.XSD.STRING || datatype.isNumericDatatype() || datatype.isCalendarDatatype());
    }
}

