/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.collectors.VarNameCollector;

public class ConjunctiveConstraintSplitterOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new ConstraintVisitor(tupleExpr));
    }

    private static class ConstraintVisitor
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        protected final TupleExpr tupleExpr;

        public ConstraintVisitor(TupleExpr tupleExpr) {
            super(false);
            this.tupleExpr = tupleExpr;
        }

        public void meet(Filter filter) {
            super.meet(filter);
            ArrayList<ValueExpr> conjunctiveConstraints = new ArrayList<ValueExpr>(16);
            this.getConjunctiveConstraints(filter.getCondition(), conjunctiveConstraints);
            TupleExpr filterArg = filter.getArg();
            for (int i = conjunctiveConstraints.size() - 1; i >= 1; --i) {
                Filter newFilter = new Filter(filterArg, ((ValueExpr)conjunctiveConstraints.get(i)).clone());
                filterArg = newFilter;
            }
            filter.setCondition(((ValueExpr)conjunctiveConstraints.get(0)).clone());
            filter.setArg(filterArg);
        }

        public void meet(LeftJoin node) {
            super.meet(node);
            if (node.getCondition() != null) {
                ArrayList<ValueExpr> conjunctiveConstraints = new ArrayList<ValueExpr>();
                this.getConjunctiveConstraints(node.getCondition(), conjunctiveConstraints);
                TupleExpr arg = node.getRightArg();
                ValueExpr condition = null;
                for (ValueExpr constraint : conjunctiveConstraints) {
                    if (this.isWithinBindingScope(constraint, arg)) {
                        arg = new Filter(arg, constraint.clone());
                        continue;
                    }
                    if (condition == null) {
                        condition = constraint;
                        continue;
                    }
                    condition = new And(condition, constraint.clone());
                }
                node.setCondition(condition);
                node.setRightArg(arg);
            }
        }

        protected void getConjunctiveConstraints(ValueExpr valueExpr, List<ValueExpr> conjunctiveConstraints) {
            if (valueExpr instanceof And) {
                And and = (And)valueExpr;
                this.getConjunctiveConstraints(and.getLeftArg(), conjunctiveConstraints);
                this.getConjunctiveConstraints(and.getRightArg(), conjunctiveConstraints);
            } else {
                conjunctiveConstraints.add(valueExpr);
            }
        }

        private boolean isWithinBindingScope(ValueExpr condition, TupleExpr node) {
            return node.getBindingNames().containsAll(VarNameCollector.process((QueryModelNode)condition));
        }
    }
}

