/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrValues;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class MergeAdjacentValuesTransform
extends BaseTransform {
    private MergeAdjacentValuesTransform() {
    }

    public static IrBGP apply(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        int i = 0;
        while (i < in.size()) {
            IrValues v2;
            IrValues v1;
            IrValues merged;
            IrNode n = in.get(i);
            if (n instanceof IrValues && i + 1 < in.size() && in.get(i + 1) instanceof IrValues && (merged = MergeAdjacentValuesTransform.tryMerge(v1 = (IrValues)n, v2 = (IrValues)in.get(i + 1))) != null) {
                out.add(merged);
                i += 2;
                continue;
            }
            out.add(BaseTransform.rewriteContainers(n, child -> MergeAdjacentValuesTransform.apply(child)));
            ++i;
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    private static IrValues tryMerge(IrValues v1, IrValues v2) {
        List<String> a = v1.getVarNames();
        List<String> b = v2.getVarNames();
        if (a.isEmpty() && b.isEmpty()) {
            return MergeAdjacentValuesTransform.crossProduct(v1, v2);
        }
        if (a.equals(b)) {
            return MergeAdjacentValuesTransform.intersectRows(v1, v2);
        }
        LinkedHashSet<String> sa = new LinkedHashSet<String>(a);
        LinkedHashSet<String> sb = new LinkedHashSet<String>(b);
        LinkedHashSet<String> inter = new LinkedHashSet<String>(sa);
        inter.retainAll(sb);
        if (inter.isEmpty()) {
            return MergeAdjacentValuesTransform.crossProduct(v1, v2);
        }
        return null;
    }

    private static IrValues crossProduct(IrValues v1, IrValues v2) {
        IrValues out = new IrValues(false);
        out.getVarNames().addAll(v1.getVarNames());
        out.getVarNames().addAll(v2.getVarNames());
        List<List<String>> r1 = v1.getRows();
        List<List<String>> r2 = v2.getRows();
        if (r1.isEmpty() || r2.isEmpty()) {
            return out;
        }
        for (List<String> row1 : r1) {
            for (List<String> row2 : r2) {
                ArrayList<String> joined = new ArrayList<String>(row1.size() + row2.size());
                joined.addAll(row1);
                joined.addAll(row2);
                out.getRows().add(joined);
            }
        }
        return out;
    }

    private static IrValues intersectRows(IrValues v1, IrValues v2) {
        IrValues out = new IrValues(false);
        out.getVarNames().addAll(v1.getVarNames());
        Map<List<String>, Integer> c1 = MergeAdjacentValuesTransform.multisetCounts(v1.getRows());
        Map<List<String>, Integer> c2 = MergeAdjacentValuesTransform.multisetCounts(v2.getRows());
        if (c1.isEmpty() || c2.isEmpty()) {
            return out;
        }
        for (List<String> r : v1.getRows()) {
            Integer m2;
            Integer m1 = c1.get(r);
            if (m1 == null || m1 == 0 || (m2 = c2.get(r)) == null || m2 == 0) continue;
            int mult = m1 * m2;
            for (int k = 0; k < mult; ++k) {
                out.getRows().add(new ArrayList<String>(r));
            }
            c1.put(r, 0);
        }
        return out;
    }

    private static Map<List<String>, Integer> multisetCounts(List<List<String>> rows) {
        LinkedHashMap<List<String>, Integer> m = new LinkedHashMap<List<String>, Integer>();
        for (List<String> r : rows) {
            ArrayList<String> key = new ArrayList<String>(r);
            m.put(key, m.getOrDefault(key, 0) + 1);
        }
        return m;
    }
}

