/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutState;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutViewerRefresh;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.lifecycle.LifecycleException;

public final class CDOCheckoutStateManager {
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private final Map<CDOCheckout, CDOCheckoutState> states = new HashMap<CDOCheckout, CDOCheckoutState>();
    private final CDOCheckoutContentProvider mainContentProvider;
    private CDOCheckoutViewerRefresh viewerRefresh;

    public CDOCheckoutStateManager(CDOCheckoutContentProvider mainContentProvider) {
        this.mainContentProvider = mainContentProvider;
    }

    public CDOCheckoutContentProvider getMainContentProvider() {
        return this.mainContentProvider;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public CDOCheckoutViewerRefresh getViewerRefresh() {
        return this.viewerRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOCheckoutState[] getStates() {
        Map<CDOCheckout, CDOCheckoutState> map = this.states;
        synchronized (map) {
            return this.states.values().toArray(new CDOCheckoutState[this.states.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOCheckoutState getState(Object object) {
        try {
            CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)object);
            if (checkout != null) {
                Map<CDOCheckout, CDOCheckoutState> map = this.states;
                synchronized (map) {
                    CDOCheckoutState state = this.states.get(checkout);
                    if (state == null) {
                        state = new CDOCheckoutState(this, checkout);
                        this.states.put(checkout, state);
                    }
                    return state;
                }
            }
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
        return null;
    }

    public void inputChanged(TreeViewer newTreeViewer, Object oldInput, Object newInput) {
        this.viewerRefresh = new CDOCheckoutViewerRefresh((Viewer)newTreeViewer);
        CDOCheckoutState[] cDOCheckoutStateArray = this.getStates();
        int n = cDOCheckoutStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOCheckoutState state = cDOCheckoutStateArray[n2];
            state.inputChanged(newTreeViewer, oldInput, newInput);
            ++n2;
        }
    }

    public Object adapt(Object target, Object type) {
        CDOCheckoutState state = this.getState(target);
        if (state != null) {
            return state.getAdapterFactory().adapt(target, type);
        }
        return null;
    }

    public ComposedAdapterFactory getAdapterFactory(Object object) {
        CDOCheckoutState state = this.getState(object);
        if (state != null) {
            return state.getAdapterFactory();
        }
        return null;
    }

    public CDOCheckoutState.ContentProvider getContentProvider(Object object) {
        CDOCheckoutState state = this.getState(object);
        if (state != null) {
            return state.getContentProvider();
        }
        return null;
    }

    public CDOCheckoutState.LabelProvider getLabelProvider(Object object) {
        CDOCheckoutState state = this.getState(object);
        if (state != null) {
            return state.getLabelProvider();
        }
        return null;
    }

    public void dispose() {
        this.resourceManager.dispose();
    }
}

