/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.actions;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActionProvider<T>
extends CommonActionProvider {
    private final Class<T> selectionType;
    private final String id;
    private final String title;
    private final String appendToGroup;
    private ICommonActionExtensionSite config;
    private ICommonViewerWorkbenchSite viewSite;

    public AbstractActionProvider(Class<T> selectionType, String id, String title, String appendToGroup) {
        this.selectionType = selectionType;
        this.id = id;
        this.title = title;
        this.appendToGroup = appendToGroup;
    }

    public final ICommonActionExtensionSite getConfig() {
        return this.config;
    }

    public final ICommonViewerWorkbenchSite getViewSite() {
        return this.viewSite;
    }

    public final StructuredViewer getViewer() {
        return this.config.getStructuredViewer();
    }

    public final IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getContext().getSelection();
    }

    protected T getSelectedElement(IStructuredSelection selection) {
        Object element;
        if (selection.size() == 1 && this.selectionType.isInstance(element = selection.getFirstElement())) {
            return this.selectionType.cast(element);
        }
        return null;
    }

    public final void init(ICommonActionExtensionSite config) {
        this.config = config;
        ICommonViewerSite viewSite = config.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            this.viewSite = (ICommonViewerWorkbenchSite)viewSite;
            this.init(this.viewSite);
        }
    }

    protected void init(ICommonViewerWorkbenchSite viewSite) {
    }

    public final void fillContextMenu(IMenuManager menu) {
        if (this.viewSite == null) {
            return;
        }
        IStructuredSelection selection = this.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        T selectedElement = this.getSelectedElement(selection);
        if (selectedElement == null) {
            return;
        }
        MenuManager subMenu = new MenuManager(this.title, this.id);
        subMenu.add((IContributionItem)new GroupMarker("group.top"));
        if (this.fillSubMenu(this.viewSite, (IMenuManager)subMenu, selectedElement)) {
            subMenu.add((IContributionItem)new GroupMarker("additions"));
            menu.appendToGroup(this.appendToGroup, (IContributionItem)subMenu);
        }
    }

    protected abstract boolean fillSubMenu(ICommonViewerWorkbenchSite var1, IMenuManager var2, T var3);
}

