/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.util;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOObjectHandler;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOView;

public class CDOLazyContentAdapter
extends EContentAdapter {
    private CDOObjectHandler handler = new CleanObjectHandler();
    private Set<WeakReference<CDOObject>> adaptedObjects = new HashSet<WeakReference<CDOObject>>();
    private WeakReference<CDOObject> adaptedRoot;

    protected void setTarget(EObject target) {
        if (CDOLazyContentAdapter.isConnectedObject((Notifier)target)) {
            if (this.adaptedRoot == null) {
                this.adaptedRoot = new WeakReference<CDOObject>(CDOUtil.getCDOObject(target));
            }
            this.basicSetTarget((Notifier)target);
            if (target instanceof Resource) {
                this.addCleanObjectHandler(target);
            }
        } else {
            super.setTarget(target);
        }
    }

    protected void unsetTarget(EObject target) {
        if (CDOLazyContentAdapter.isConnectedObject((Notifier)target)) {
            this.basicUnsetTarget((Notifier)target);
            if (target instanceof Resource) {
                InternalCDOView view = CDOLazyContentAdapter.getCDOView(target);
                if (view != null) {
                    for (WeakReference<CDOObject> weakReference : this.adaptedObjects) {
                        CDOObject object = (CDOObject)weakReference.get();
                        if (object == null) continue;
                        this.removeAdapter((Notifier)object);
                    }
                }
                target.eAdapters().remove((Object)this);
                this.removeCleanObjectHandler(target);
            }
        } else {
            super.unsetTarget(target);
        }
    }

    private void addCleanObjectHandler(EObject target) {
        InternalCDOView view = CDOLazyContentAdapter.getCDOView(target);
        if (view != null) {
            CDOObjectHandler[] handlers;
            CDOObjectHandler[] cDOObjectHandlerArray = handlers = view.getObjectHandlers();
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                CDOObjectHandler cDOObjectHandler = cDOObjectHandlerArray[n2];
                if (cDOObjectHandler.equals(this.handler)) {
                    return;
                }
                ++n2;
            }
            view.addObjectHandler(this.handler);
            for (CDOObject cDOObject : view.getObjectsList()) {
                if (!this.isContained(cDOObject)) continue;
                this.addAdapter((Notifier)cDOObject);
            }
        }
    }

    private void removeCleanObjectHandler(EObject target) {
        InternalCDOView view = CDOLazyContentAdapter.getCDOView(target);
        if (view != null) {
            CDOObjectHandler[] handlers;
            CDOObjectHandler[] cDOObjectHandlerArray = handlers = view.getObjectHandlers();
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                CDOObjectHandler handler = cDOObjectHandlerArray[n2];
                if (handler.equals(this.handler)) {
                    view.removeObjectHandler(handler);
                    break;
                }
                ++n2;
            }
        }
    }

    protected void addAdapter(Notifier notifier) {
        if (CDOLazyContentAdapter.isConnectedObject(notifier) && !this.isAlreadyAdapted(notifier)) {
            this.adaptedObjects.add(new WeakReference<CDOObject>(CDOUtil.getCDOObject((EObject)notifier)));
        }
        super.addAdapter(notifier);
    }

    private boolean isAlreadyAdapted(Notifier notifier) {
        return notifier.eAdapters().contains((Object)this);
    }

    private static InternalCDOView getCDOView(EObject target) {
        CDOObject object = CDOUtil.getCDOObject(target);
        if (object != null) {
            return (InternalCDOView)object.cdoView();
        }
        return null;
    }

    private static boolean isConnectedObject(Notifier target) {
        CDOObject object;
        if (target instanceof EObject && (object = CDOUtil.getCDOObject((EObject)target)) != null) {
            return !FSMUtil.isTransient(object);
        }
        return false;
    }

    private boolean isContained(CDOObject object) {
        if (this.adaptedRoot == null) {
            return false;
        }
        CDOObject root = (CDOObject)this.adaptedRoot.get();
        if (object == null) {
            return false;
        }
        if (root instanceof Resource) {
            return root == (object instanceof Resource ? object : object.cdoResource());
        }
        return EcoreUtil.isAncestor((EObject)root, (EObject)object);
    }

    private final class CleanObjectHandler
    implements CDOObjectHandler {
        private CleanObjectHandler() {
        }

        public void objectStateChanged(CDOView view, CDOObject object, CDOState oldState, CDOState newState) {
            if ((newState == CDOState.CLEAN || newState == CDOState.NEW) && CDOLazyContentAdapter.isConnectedObject((Notifier)object) && !CDOLazyContentAdapter.this.isAlreadyAdapted((Notifier)object) && CDOLazyContentAdapter.this.isContained(object)) {
                CDOLazyContentAdapter.this.addAdapter((Notifier)object);
            }
        }
    }
}

