/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.HashMap;
import java.util.List;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.rules.CContainerValidator;

public class TargetsValidator
extends CContainerValidator {
    public static IFilter<INode> PARENTS = Filters.ACTIVITIES;

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.checkChild(ND_JOIN_CONDITION, 0, 1);
        this.checkChild(ND_TARGET, 1, Integer.MAX_VALUE);
    }

    @ARule(sa=69, desc="<target> elements must have distinct linkNames", author="michal.chmielewski@oracle.com", date="02/16/2007", errors="BPELC_DUPLICATE_NAME")
    public void rule_CheckUniqueTargetName_10() {
        HashMap<String, INode> map = new HashMap<String, INode>();
        List<INode> children = mSelector.selectNodes(this.mNode, ND_TARGET);
        for (INode next : children) {
            String name = next.getAttribute(AT_LINK_NAME);
            INode present = (INode)map.get(next.getAttribute(AT_LINK_NAME));
            if (present == null) {
                map.put(name, next);
                continue;
            }
            IProblem problem = this.createError(next);
            problem.setAttribute("context.name", AT_LINK_NAME);
            problem.fill("BPELC_DUPLICATE_NAME", this.toString(this.mNode.nodeName()), this.toString(next.nodeName()), name);
        }
        map.clear();
    }
}

