/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.providers;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.bpmn2.modeler.ui.property.providers.PartTreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.TreeNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;

public class MessageTypeTreeNode
extends TreeNode {
    boolean displayParticles;

    public MessageTypeTreeNode(Input msg, boolean isCondensed) {
        this((EObject)msg, isCondensed, true);
    }

    public MessageTypeTreeNode(Output msg, boolean isCondensed) {
        this((EObject)msg, isCondensed, true);
    }

    public MessageTypeTreeNode(Message messageType, boolean isCondensed) {
        this(messageType, isCondensed, true);
    }

    public MessageTypeTreeNode(Message messageType, boolean isCondensed, boolean displayParticles) {
        this((EObject)messageType, isCondensed, displayParticles);
    }

    private MessageTypeTreeNode(EObject obj, boolean isCondensed, boolean displayParticles) {
        super(obj, isCondensed);
        this.displayParticles = displayParticles;
    }

    @Override
    public Object[] getChildren() {
        Message msg = this.getMessage();
        if (msg == null) {
            return EMPTY_ARRAY;
        }
        if (msg.getParts() == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<PartTreeNode> list = new ArrayList<PartTreeNode>();
        Iterator it = msg.getParts().values().iterator();
        while (it.hasNext()) {
            list.add(new PartTreeNode((Part)it.next(), this.isCondensed, this.displayParticles));
        }
        return list.toArray();
    }

    @Override
    public boolean hasChildren() {
        Message msg = this.getMessage();
        if (msg == null) {
            return false;
        }
        return msg.getParts() != null && !msg.getParts().isEmpty();
    }

    Message getMessage() {
        if (this.modelObject instanceof Message) {
            return (Message)this.modelObject;
        }
        if (this.modelObject instanceof Input) {
            return ((Input)this.modelObject).getEMessage();
        }
        if (this.modelObject instanceof Output) {
            return ((Output)this.modelObject).getEMessage();
        }
        return null;
    }
}

