/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BeanPropertyListenerSupport {
    private static final boolean DEBUG = true;

    public static void hookListener(Object bean, String propertyName, PropertyChangeListener listener) {
        Assert.isNotNull((Object)bean, (String)"Bean cannot be null");
        Assert.isNotNull((Object)listener, (String)"Listener cannot be null");
        Assert.isNotNull((Object)propertyName, (String)"Property name cannot be null");
        BeanPropertyListenerSupport.processListener(bean, propertyName, listener, "addPropertyChangeListener", "Could not attach listener to ");
    }

    public static void unhookListener(Object bean, String propertyName, PropertyChangeListener listener) {
        Assert.isNotNull((Object)bean, (String)"Bean cannot be null");
        Assert.isNotNull((Object)listener, (String)"Listener cannot be null");
        Assert.isNotNull((Object)propertyName, (String)"Property name cannot be null");
        BeanPropertyListenerSupport.processListener(bean, propertyName, listener, "removePropertyChangeListener", "Cound not remove listener from ");
    }

    private static boolean processListener(Object bean, String propertyName, PropertyChangeListener listener, String methodName, String message) {
        Method method = null;
        Object[] parameters = null;
        try {
            try {
                method = bean.getClass().getMethod(methodName, String.class, PropertyChangeListener.class);
                parameters = new Object[]{propertyName, listener};
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = bean.getClass().getMethod(methodName, PropertyChangeListener.class);
                parameters = new Object[]{listener};
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException e) {
            BeanPropertyListenerSupport.log(2, String.valueOf(message) + bean, e);
        }
        if (method != null) {
            BeanPropertyHelper.setAccessible(method);
            try {
                method.invoke(bean, parameters);
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                BeanPropertyListenerSupport.log(2, String.valueOf(message) + bean, e);
            }
        }
        return false;
    }

    private static void log(int severity, String message, Throwable throwable) {
        Policy.getLog().log((IStatus)new Status(severity, "org.eclipse.core.databinding", 0, message, throwable));
    }
}

