/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.util.List;
import org.eclipse.emf.codegen.jet.JETGenerator;
import org.eclipse.emf.codegen.jet.JETJavaGenerator;
import org.eclipse.emf.codegen.jet.JETJavaItem;
import org.eclipse.emf.codegen.jet.JETLiteralItem;
import org.eclipse.emf.codegen.jet.JETMark;

public class JETCharDataGenerator
implements JETGenerator,
JETGenerator.BuilderSensitive,
JETJavaGenerator {
    protected static final String FUNCTION_CALL_BEGIN_APPEND = ".append(";
    protected static final String FUNCTION_CALL_BEGIN = "stringBuffer.append(";
    protected static final String FUNCTION_CALL_END = ");";
    protected static final String NEW_LINE_BEGIN = "NL + ";
    protected static final String NEW_LINE_MIDDLE = "\" + NL + \"";
    protected static final String NEW_LINE_END = " + NL";
    protected char[] characters;
    protected String builderName;
    protected JETLiteralItem literalItem;

    public JETCharDataGenerator(char[] characters) {
        this.characters = characters;
    }

    public String generate() {
        StringBuilder builder = new StringBuilder(this.characters.length + 16);
        if (this.builderName == null) {
            builder.append(FUNCTION_CALL_BEGIN);
        } else {
            builder.append(this.builderName);
            builder.append(FUNCTION_CALL_BEGIN_APPEND);
        }
        builder.append(this.generateValue());
        builder.append(FUNCTION_CALL_END);
        return builder.toString();
    }

    protected String generateValue() {
        return this.generateCharData();
    }

    public void setBuilderName(String builderName) {
        this.builderName = builderName;
    }

    public JETLiteralItem getLiteralItem() {
        return this.literalItem;
    }

    public void setLiteralItem(JETLiteralItem literalItem) {
        this.literalItem = literalItem;
    }

    public JETJavaItem getJavaItem() {
        return this.literalItem;
    }

    public int getRelativeJavaOffset() {
        return this.builderName == null ? FUNCTION_CALL_BEGIN.length() : this.builderName.length() + FUNCTION_CALL_BEGIN_APPEND.length();
    }

    private JETLiteralItem getLastItem() {
        if (this.literalItem == null) {
            return null;
        }
        List<JETLiteralItem> explode = this.literalItem.explode();
        return explode.get(explode.size() - 1);
    }

    public JETMark getStart() {
        JETLiteralItem lastItem = this.getLastItem();
        return lastItem == null ? null : lastItem.getStart();
    }

    public JETMark getStop() {
        JETLiteralItem lastItem = this.getLastItem();
        return lastItem == null ? null : lastItem.getStop();
    }

    public int getJavaLength() {
        return this.generateValue().length();
    }

    protected boolean isConsumeWhitespace() {
        return false;
    }

    protected int generateNewLineFeedBegin(StringBuilder builder, int offset) {
        int i = 0;
        int lineEndLength = 0;
        int lineOffset = -1;
        while (i <= offset) {
            char ch = this.characters[i];
            switch (ch) {
                case '\r': {
                    break;
                }
                case '\n': {
                    if (lineOffset != -1) {
                        builder.append(this.generateNewLine(lineOffset, lineEndLength));
                        builder.append(" + ");
                        lineEndLength = 0;
                    }
                    ++lineEndLength;
                    lineOffset = i;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (lineOffset != -1 && this.isConsumeWhitespace()) {
                        ++lineEndLength;
                        break;
                    }
                }
                default: {
                    if (lineEndLength > 0) {
                        builder.append(this.generateNewLine(lineOffset, lineEndLength));
                        builder.append(" + ");
                    }
                    return i;
                }
            }
            ++i;
        }
        return i;
    }

    protected int generateNewLineMiddle(StringBuilder builder, int offset, int limit) {
        int lineOffset = offset;
        int lineLength = 1;
        if (this.isConsumeWhitespace()) {
            int i = offset + 1;
            block5: while (i < limit) {
                char ch = this.characters[i];
                switch (ch) {
                    case '\r': {
                        break;
                    }
                    case '\n': {
                        builder.append(this.generateNewLine(lineOffset, lineLength));
                        builder.append(" + ");
                        lineOffset = i;
                        lineLength = 1;
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        if (!this.isConsumeWhitespace()) break block5;
                        ++lineLength;
                        break;
                    }
                    default: {
                        break block5;
                    }
                }
                ++i;
            }
        }
        builder.append(this.generateNewLine(lineOffset, lineLength));
        return lineOffset + lineLength - 1;
    }

    protected int generateNewLineEnd(StringBuilder builder) {
        int offset = this.characters.length - 1;
        int lineEndLength = 0;
        block5: while (offset >= 0) {
            char ch = this.characters[offset];
            switch (ch) {
                case '\r': {
                    break;
                }
                case '\n': {
                    if (builder.length() != 0) {
                        builder.insert(0, " + ");
                    }
                    builder.insert(0, this.generateNewLine(offset, ++lineEndLength));
                    lineEndLength = 0;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (this.isConsumeWhitespace() && offset > 0) {
                        ++lineEndLength;
                        break;
                    }
                }
                default: {
                    offset += lineEndLength + 1;
                    break block5;
                }
            }
            --offset;
        }
        if (offset < 0) {
            if (builder.length() == 0) {
                builder.append("\"\"");
            }
        } else if (builder.length() != 0) {
            builder.insert(0, " + ");
        }
        return offset;
    }

    protected String generateNewLine(int offset, int length) {
        if (length != 1) {
            System.err.println("###");
        }
        return "NL";
    }

    protected String generateLiteral(StringBuilder literalBody) {
        return String.valueOf('\"') + literalBody.toString() + '\"';
    }

    protected String generateCharData() {
        StringBuilder builderTail = new StringBuilder();
        int limit = this.generateNewLineEnd(builderTail);
        if (limit < 0) {
            return builderTail.toString();
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder builderHead = new StringBuilder();
        int i = this.generateNewLineFeedBegin(builderHead, limit);
        builder.append((CharSequence)builderHead);
        StringBuilder literalBuilder = new StringBuilder();
        while (i < limit) {
            char ch = this.characters[i];
            switch (ch) {
                case '\"': {
                    literalBuilder.append("\\\"");
                    break;
                }
                case '\\': {
                    literalBuilder.append("\\\\");
                    break;
                }
                case '\r': {
                    break;
                }
                case '\n': {
                    String literal = this.generateLiteral(literalBuilder);
                    builder.append(literal);
                    builder.append(" + ");
                    i = this.generateNewLineMiddle(builder, i, limit);
                    builder.append(" + ");
                    literalBuilder.setLength(0);
                    break;
                }
                case '\t': {
                    literalBuilder.append("\\t");
                    break;
                }
                default: {
                    literalBuilder.append(ch);
                }
            }
            ++i;
        }
        builder.append(this.generateLiteral(literalBuilder));
        builder.append((CharSequence)builderTail);
        return builder.toString();
    }

    protected JETCharDataGenerator copy() {
        return new JETCharDataGenerator(this.characters);
    }
}

