/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.catalog.DirectionKind;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.infra.discovery.core.internal.catalog.DiscovererRegistry;
import org.eclipse.modisco.infra.discovery.launch.LaunchConfiguration;
import org.eclipse.modisco.infra.discovery.launch.LaunchFactory;
import org.eclipse.modisco.infra.discovery.launch.ParameterValue;
import org.eclipse.modisco.infra.discovery.ui.Activator;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchConfigurationUtils {
    private final DiscovererDescription fDiscovererDesc;
    private final Object[] fSources;
    private final Shell shell;

    public LaunchConfigurationUtils(DiscovererDescription discoverer, Object[] sourceParameter, Shell shell) {
        this.fDiscovererDesc = discoverer;
        this.fSources = sourceParameter;
        this.shell = shell;
    }

    public void saveParameters(Map<DiscovererParameter, Object> parameterValuesMap, boolean openModel) {
        if (this.fSources.length != 1) {
            return;
        }
        Object source = this.fSources[0];
        LaunchConfiguration launchConfiguration = this.getLaunchConfigurationModel(source);
        IResource iResource = LaunchConfigurationUtils.getIResourceFromSource(source);
        if (iResource == null) {
            return;
        }
        launchConfiguration.setDiscoverer(this.fDiscovererDesc);
        launchConfiguration.setSource((Object)iResource);
        launchConfiguration.setOpenModelAfterDiscovery(openModel);
        launchConfiguration.getParameterValues().clear();
        for (Map.Entry<DiscovererParameter, Object> entry : parameterValuesMap.entrySet()) {
            ParameterValue parameterValue = LaunchFactory.eINSTANCE.createParameterValue();
            parameterValue.setParameter(entry.getKey());
            parameterValue.setValue(entry.getValue());
            launchConfiguration.getParameterValues().add((Object)parameterValue);
        }
        try {
            launchConfiguration.eResource().save(Collections.emptyMap());
        }
        catch (IOException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    public LaunchConfiguration getLaunchConfigurationModel(Object source) {
        if (this.fDiscovererDesc == null || this.fDiscovererDesc.getId() == null) {
            return null;
        }
        IResource iresource = LaunchConfigurationUtils.getIResourceFromSource(source);
        IPath stateLocation = Activator.getDefault().getStateLocation();
        IPath launchParametersFile = stateLocation.append("launchParameters");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI resourceURI = URI.createFileURI((String)launchParametersFile.toOSString());
        Resource resource = new File(launchParametersFile.toOSString()).exists() ? resourceSet.getResource(resourceURI, true) : resourceSet.createResource(resourceURI);
        EList registryResources = DiscovererRegistry.INSTANCE.getResourceSet().getResources();
        if (!registryResources.contains((Object)resource)) {
            registryResources.add((Object)resource);
        }
        if (iresource != null) {
            EList contents = resource.getContents();
            for (EObject eObject : contents) {
                if (eObject instanceof LaunchConfiguration) {
                    LaunchConfiguration launchConfiguration = (LaunchConfiguration)eObject;
                    DiscovererDescription discoverer = launchConfiguration.getDiscoverer();
                    if (discoverer == null) continue;
                    String discovererID = discoverer.getId();
                    if (this.fDiscovererDesc.getId() != discovererID || !iresource.equals(launchConfiguration.getSource())) continue;
                    return launchConfiguration;
                }
                MoDiscoLogger.logError((String)("expected " + LaunchConfiguration.class.getSimpleName()), (Plugin)Activator.getDefault());
            }
        }
        LaunchConfiguration launchConfiguration = LaunchFactory.eINSTANCE.createLaunchConfiguration();
        launchConfiguration.setOpenModelAfterDiscovery(true);
        resource.getContents().add((Object)launchConfiguration);
        EList parameters = this.fDiscovererDesc.getParameterDefinitions();
        for (DiscovererParameter parameter : parameters) {
            if (!IDiscoveryManager.INSTANCE.hasInitialValue(parameter, this.fDiscovererDesc)) continue;
            try {
                Object initialValue = IDiscoveryManager.INSTANCE.getInitialValue(parameter, this.fDiscovererDesc, source);
                ParameterValue parameterValue = LaunchFactory.eINSTANCE.createParameterValue();
                parameterValue.setParameter(parameter);
                parameterValue.setValue(initialValue);
                launchConfiguration.getParameterValues().add((Object)parameterValue);
            }
            catch (DiscoveryException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return launchConfiguration;
    }

    public static IResource getIResourceFromSource(Object source) {
        IResource iresource = null;
        iresource = source instanceof IResource ? (IResource)source : (IResource)Platform.getAdapterManager().getAdapter(source, IResource.class);
        if (iresource == null) {
            return null;
        }
        return iresource;
    }

    public static List<DiscovererParameter> getExpectedInputParameters(DiscovererDescription discoverer) {
        ArrayList<DiscovererParameter> inParameters = new ArrayList<DiscovererParameter>();
        EList params = discoverer.getParameterDefinitions();
        for (DiscovererParameter param : params) {
            if (param.getDirection() != DirectionKind.IN && param.getDirection() != DirectionKind.INOUT) continue;
            inParameters.add(param);
        }
        return inParameters;
    }

    public DiscovererDescription getDiscoverer() {
        return this.fDiscovererDesc;
    }
}

