/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.persistence.BasePersistenceModel;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.util.FileUtil;

public class PersistenceZipModel
extends BasePersistenceModel
implements IPersistenceModel {
    public PersistenceZipModel(Resource element) {
        super(element);
    }

    @Override
    protected synchronized void doStoreTo(File file) throws FileNotFoundException, IOException {
        ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        for (Map.Entry fileEntry : this.files.entrySet()) {
            if (!((File)fileEntry.getValue()).exists()) continue;
            ZipEntry entry = new ZipEntry((String)fileEntry.getKey());
            entry.setTime(1L);
            zout.putNextEntry(entry);
            BufferedInputStream in = this.getInput((File)fileEntry.getValue());
            FileUtil.copyNoClose((InputStream)in, (OutputStream)zout);
            zout.closeEntry();
        }
        zout.close();
    }

    @Override
    protected synchronized void doReadIndex(InputStream contents) {
        block12: {
            ZipInputStream zin = new ZipInputStream(contents);
            try {
                try {
                    ZipEntry entry;
                    while ((entry = zin.getNextEntry()) != null) {
                        String name = entry.getName();
                        IPath filePath = this.rootPath.append((IPath)new Path(name));
                        this.putFileItem(name, filePath);
                    }
                }
                catch (IOException e) {
                    RcpttPlugin.log(e);
                    try {
                        zin.close();
                    }
                    catch (IOException iOException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    zin.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zin.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected synchronized void doExtractFile(String fName, InputStream contents) throws IOException {
        ZipEntry entry;
        ZipInputStream zin = new ZipInputStream(contents);
        while ((entry = zin.getNextEntry()) != null) {
            String name = entry.getName();
            if (!name.equals(fName)) continue;
            OutputStream outputStream = this.internalStore(fName);
            FileUtil.copy((InputStream)zin, (OutputStream)outputStream);
            outputStream.close();
            break;
        }
    }

    @Override
    protected synchronized void doExtractAll(InputStream contents) throws IOException {
        ZipEntry entry;
        ZipInputStream zin = new ZipInputStream(contents);
        while ((entry = zin.getNextEntry()) != null) {
            String name = entry.getName();
            File file = (File)this.files.get(name);
            if (file == null || file.exists()) continue;
            OutputStream outputStream = this.internalStore(name);
            FileUtil.copyNoClose((InputStream)zin, (OutputStream)outputStream);
            outputStream.close();
        }
    }

    @Override
    public boolean isSupportMultiItems() {
        return true;
    }

    public void updateAttributes(Resource element) {
    }

    public void updateMetadata(Resource resource) {
    }
}

