/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rse.ui.actions.ISystemWizardAction;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.dialogs.SystemWizardDialog;
import org.eclipse.rse.ui.wizards.ISystemWizard;
import org.eclipse.swt.widgets.Shell;

public abstract class SystemBaseWizardAction
extends SystemBaseDialogAction
implements ISystemWizardAction {
    private IWizard newWizard;
    private String wizardTitle;
    private String pageTitle;
    private ImageDescriptor wizardImage;
    private int minPageWidth = -1;
    private int minPageHeight = -1;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.actions.SystemBaseWizardAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected SystemBaseWizardAction(String text, ImageDescriptor image, Shell parent) {
        super(text, image, parent);
        this.allowOnMultipleSelection(false);
    }

    protected SystemBaseWizardAction(String text, String tooltip, ImageDescriptor image, Shell parent) {
        super(text, tooltip, image, parent);
        this.allowOnMultipleSelection(false);
    }

    protected SystemBaseWizardAction(String text, String tooltip, String description, ImageDescriptor image, Shell parent) {
        super(text, tooltip, description, image, parent);
        this.allowOnMultipleSelection(false);
    }

    public void setWizardTitle(String title) {
        this.wizardTitle = title;
    }

    public void setWizardImage(ImageDescriptor wizardImage) {
        this.wizardImage = wizardImage;
    }

    public void setWizardPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public String getWizardPageTitle() {
        return this.pageTitle;
    }

    public void setMinimumPageSize(int width, int height) {
        this.minPageWidth = width;
        this.minPageHeight = height;
    }

    protected final Dialog createDialog(Shell shell) {
        this.newWizard = this.createWizard();
        if (this.newWizard instanceof Wizard && this.wasNeedsProgressMonitorSet()) {
            ((Wizard)this.newWizard).setNeedsProgressMonitor(this.getNeedsProgressMonitor());
        }
        if (this.newWizard instanceof Wizard) {
            if (this.wizardTitle != null) {
                ((Wizard)this.newWizard).setWindowTitle(this.wizardTitle);
            }
            if (this.wizardImage != null) {
                ((Wizard)this.newWizard).setDefaultPageImageDescriptor(this.wizardImage);
            }
        }
        return this.doCreateWizardDialog(shell, this.newWizard);
    }

    protected WizardDialog doCreateWizardDialog(Shell shell, IWizard wizard) {
        if (!($assertionsDisabled || shell != null && wizard != null)) {
            throw new AssertionError();
        }
        WizardDialog dialog = null;
        if (this.newWizard instanceof ISystemWizard) {
            ISystemWizard swizard = (ISystemWizard)this.newWizard;
            if (this.pageTitle != null) {
                swizard.setWizardPageTitle(this.pageTitle);
            }
            swizard.setViewer(this.getViewer());
            dialog = new SystemWizardDialog(shell, (IWizard)swizard);
            int w = swizard.getMinimumPageWidth();
            int h = swizard.getMinimumPageHeight();
            if (this.minPageWidth > 0) {
                w = this.minPageWidth;
            }
            if (this.minPageHeight > 0) {
                h = this.minPageHeight;
            }
            if (w > 0 && h > 0) {
                dialog.setMinimumPageSize(w, h);
            }
        } else {
            dialog = new WizardDialog(shell, this.newWizard);
        }
        return dialog;
    }

    protected abstract IWizard createWizard();

    protected Object getDialogValue(Dialog dlg) {
        this.postProcessWizard(this.newWizard);
        if (this.newWizard instanceof ISystemWizard) {
            ISystemWizard ourWizard = (ISystemWizard)this.newWizard;
            return ourWizard.getOutputObject();
        }
        return null;
    }

    protected void postProcessWizard(IWizard wizard) {
    }

    public boolean wasCancelled() {
        if (this.newWizard instanceof ISystemWizard) {
            ISystemWizard ourWizard = (ISystemWizard)this.newWizard;
            return ourWizard.wasCancelled();
        }
        return super.wasCancelled();
    }
}

