/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.internal.LoggingUtils;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Filter;

@ConfinedToDsfExecutor(value="getExecutor")
public class DsfSession {
    private static final boolean DEBUG_SESSION = DsfPlugin.DEBUG && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf/debug/session"));
    private static final boolean DEBUG_SESSION_LISTENERS = DEBUG_SESSION && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf/debug/session/listeners"));
    private static final boolean DEBUG_SESSION_DISPATCHES = DEBUG_SESSION && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf/debug/session/dispatches"));
    private static final boolean DEBUG_SESSION_MODELADAPTERS = DEBUG_SESSION && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf/debug/session/modelAdapters"));
    private static int fgSessionIdCounter = 0;
    private static Set<DsfSession> fgActiveSessions = Collections.synchronizedSet(new HashSet());
    private static List<SessionStartedListener> fSessionStartedListeners = Collections.synchronizedList(new ArrayList());
    private static List<SessionEndedListener> fSessionEndedListeners = Collections.synchronizedList(new ArrayList());
    private final String fOwnerId;
    private final String fId;
    private final DsfExecutor fExecutor;
    private int fServiceInstanceCounter;
    private Map<ListenerEntry, Method[]> fListeners = new HashMap<ListenerEntry, Method[]>();
    private Map<Class<?>, Object> fAdapters = Collections.synchronizedMap(new HashMap());

    public static boolean isSessionActive(String sessionId) {
        return DsfSession.getSession(sessionId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public static DsfSession getSession(String sessionId) {
        Set<DsfSession> set = fgActiveSessions;
        synchronized (set) {
            for (DsfSession session : fgActiveSessions) {
                if (!session.getId().equals(sessionId)) continue;
                return session;
            }
        }
        return null;
    }

    @ThreadSafe
    public static DsfSession[] getActiveSessions() {
        return fgActiveSessions.toArray(new DsfSession[fgActiveSessions.size()]);
    }

    @ThreadSafe
    public static void addSessionStartedListener(SessionStartedListener listener) {
        assert (!fSessionStartedListeners.contains(listener));
        fSessionStartedListeners.add(listener);
    }

    @ThreadSafe
    public static void removeSessionStartedListener(SessionStartedListener listener) {
        assert (fSessionStartedListeners.contains(listener));
        fSessionStartedListeners.remove(listener);
    }

    @ThreadSafe
    public static void addSessionEndedListener(SessionEndedListener listener) {
        assert (!fSessionEndedListeners.contains(listener));
        fSessionEndedListeners.add(listener);
    }

    @ThreadSafe
    public static void removeSessionEndedListener(SessionEndedListener listener) {
        assert (fSessionEndedListeners.contains(listener));
        fSessionEndedListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public static DsfSession startSession(DsfExecutor executor, String ownerId) {
        Set<DsfSession> set = fgActiveSessions;
        synchronized (set) {
            final DsfSession newSession = new DsfSession(executor, ownerId, Integer.toString(fgSessionIdCounter++));
            fgActiveSessions.add(newSession);
            executor.submit(new DsfRunnable(){

                @Override
                public void run() {
                    SessionStartedListener[] listeners = fSessionStartedListeners.toArray(new SessionStartedListener[fSessionStartedListeners.size()]);
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].sessionStarted(newSession);
                        ++i;
                    }
                }
            });
            return newSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public static void endSession(final DsfSession session) {
        Set<DsfSession> set = fgActiveSessions;
        synchronized (set) {
            if (!fgActiveSessions.contains(session)) {
                throw new IllegalArgumentException();
            }
            fgActiveSessions.remove(session);
            session.getExecutor().submit(new DsfRunnable(){

                @Override
                public void run() {
                    SessionEndedListener[] listeners = fSessionEndedListeners.toArray(new SessionEndedListener[fSessionEndedListeners.size()]);
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].sessionEnded(session);
                        ++i;
                    }
                }
            });
        }
    }

    @ThreadSafe
    public String getOwnerId() {
        return this.fOwnerId;
    }

    public boolean isActive() {
        return DsfSession.isSessionActive(this.fId);
    }

    @ThreadSafe
    public String getId() {
        return this.fId;
    }

    @ThreadSafe
    public DsfExecutor getExecutor() {
        return this.fExecutor;
    }

    public void addServiceEventListener(Object listener, Filter filter) {
        assert (this.getExecutor().isInExecutorThread());
        ListenerEntry entry = new ListenerEntry(listener, filter);
        if (DEBUG_SESSION_LISTENERS) {
            Formatter formatter = new Formatter();
            String msg = formatter.format("%s %s added as a service listener to %s (id=%s)", DsfPlugin.getDebugTime(), LoggingUtils.toString(listener), LoggingUtils.toString(this), this.getId()).toString();
            formatter.close();
            DsfPlugin.debug(msg);
        }
        this.fListeners.put(entry, this.getEventHandlerMethods(listener));
    }

    public void removeServiceEventListener(Object listener) {
        assert (this.getExecutor().isInExecutorThread());
        ListenerEntry entry = new ListenerEntry(listener, null);
        if (DEBUG_SESSION_LISTENERS) {
            Formatter formatter = new Formatter();
            String msg = formatter.format("%s %s removed as a service listener to %s (id=%s)", DsfPlugin.getDebugTime(), LoggingUtils.toString(listener), LoggingUtils.toString(this), this.getId()).toString();
            formatter.close();
            DsfPlugin.debug(msg);
        }
        this.fListeners.remove(entry);
    }

    public int getAndIncrementServiceStartupCounter() {
        return this.fServiceInstanceCounter++;
    }

    @ThreadSafe
    public void dispatchEvent(final Object event, final Dictionary<?, ?> serviceProperties) {
        assert (event != null);
        if (DEBUG_SESSION_DISPATCHES) {
            Formatter formatter = new Formatter();
            String msg = formatter.format("%s Dispatching event %s to session %s from thread \"%s\" (%d)", DsfPlugin.getDebugTime(), LoggingUtils.toString(event), LoggingUtils.toString(this), Thread.currentThread().getName(), Thread.currentThread().getId()).toString();
            formatter.close();
            DsfPlugin.debug(msg);
        }
        this.getExecutor().submit(new DsfRunnable(){

            @Override
            public void run() {
                DsfSession.this.doDispatchEvent(event, serviceProperties);
            }

            public String toString() {
                return "Event: " + event + ", from service " + serviceProperties;
            }
        });
    }

    @ThreadSafe
    public void registerModelAdapter(Class<?> adapterType, Object adapter) {
        if (DEBUG_SESSION_MODELADAPTERS) {
            Formatter formatter = new Formatter();
            String msg = formatter.format("%s Registering model adapter %s of type %s to session %s (%s)", DsfPlugin.getDebugTime(), LoggingUtils.toString(adapter), adapterType.getName(), LoggingUtils.toString(this), this.getId()).toString();
            formatter.close();
            DsfPlugin.debug(msg);
        }
        this.fAdapters.put(adapterType, adapter);
    }

    @ThreadSafe
    public void unregisterModelAdapter(Class<?> adapterType) {
        if (DEBUG_SESSION_MODELADAPTERS) {
            Formatter formatter = new Formatter();
            String msg = formatter.format("%s Unregistering model adapter of type %s from session %s (%s)", DsfPlugin.getDebugTime(), adapterType.getName(), LoggingUtils.toString(this), this.getId()).toString();
            formatter.close();
            DsfPlugin.debug(msg);
        }
        this.fAdapters.remove(adapterType);
    }

    @ThreadSafe
    public Object getModelAdapter(Class<?> adapterType) {
        return this.fAdapters.get(adapterType);
    }

    @ThreadSafe
    public boolean equals(Object other) {
        return other instanceof DsfSession && this.fId.equals(((DsfSession)other).fId);
    }

    @ThreadSafe
    public int hashCode() {
        return this.fId.hashCode();
    }

    private void doDispatchEvent(Object event, Dictionary<?, ?> _serviceProperties) {
        Dictionary<?, ?> serviceProperties = _serviceProperties;
        TreeMap listeners = new TreeMap(new Comparator<ListenerEntry>(){

            @Override
            public int compare(ListenerEntry o1, ListenerEntry o2) {
                if (o1.fListener == o2.fListener) {
                    return 0;
                }
                if (o1.fListener instanceof IDsfService && !(o2.fListener instanceof IDsfService)) {
                    return -1;
                }
                if (o2.fListener instanceof IDsfService && !(o1.fListener instanceof IDsfService)) {
                    return 1;
                }
                if (o1.fListener instanceof IDsfService && o2.fListener instanceof IDsfService) {
                    return ((IDsfService)o1.fListener).getStartupNumber() - ((IDsfService)o2.fListener).getStartupNumber();
                }
                return 1;
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }
        });
        Class<?> eventClass = event.getClass();
        for (Map.Entry<ListenerEntry, Method[]> entry : this.fListeners.entrySet()) {
            if (entry.getKey().fFilter != null && !entry.getKey().fFilter.match(serviceProperties)) continue;
            Method[] allMethods = entry.getValue();
            ArrayList<Method> matchingMethods = new ArrayList<Method>();
            Method[] methodArray = allMethods;
            int n = allMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                assert (method.getParameterTypes().length > 0) : String.valueOf(eventClass.getName()) + "." + method.getName() + " signature contains zero parameters";
                if (method.getParameterTypes()[0].isAssignableFrom(eventClass)) {
                    matchingMethods.add(method);
                }
                ++n2;
            }
            if (matchingMethods.isEmpty()) continue;
            listeners.put(entry.getKey(), matchingMethods);
        }
        for (Map.Entry<ListenerEntry, Object> entry : listeners.entrySet()) {
            for (Method method : (List)entry.getValue()) {
                try {
                    if (DEBUG_SESSION_DISPATCHES) {
                        DsfPlugin.debug(String.valueOf(DsfPlugin.getDebugTime()) + " Listener " + LoggingUtils.toString(entry.getKey().fListener) + " invoked with event " + LoggingUtils.toString(event));
                    }
                    method.invoke(entry.getKey().fListener, event);
                }
                catch (IllegalAccessException e) {
                    DsfPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.dsf", -1, "Security exception when calling a service event handler method", (Throwable)e));
                    assert (false) : "IServiceEventListener.ServiceHandlerMethod method not accessible, is listener declared public?";
                }
                catch (InvocationTargetException e) {
                    DsfPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.dsf", -1, "Invocation exception when calling a service event handler method", (Throwable)e));
                    assert (false) : "Exception thrown by a IServiceEventListener.ServiceHandlerMethod method";
                }
            }
        }
    }

    private Method[] getEventHandlerMethods(Object listener) {
        ArrayList<Method> retVal = new ArrayList<Method>();
        try {
            Method[] methods;
            Method[] methodArray = methods = listener.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(DsfServiceEventHandler.class)) {
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (paramTypes.length != 1) {
                        throw new IllegalArgumentException("@DsfServiceEventHandler method has incorrect number of parameters");
                    }
                    retVal.add(method);
                }
                ++n2;
            }
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("No permission to access @DsfServiceEventHandler method");
        }
        if (retVal.isEmpty()) {
            throw new IllegalArgumentException("No methods annotated with @DsfServiceEventHandler in listener, is listener declared public?");
        }
        return retVal.toArray(new Method[retVal.size()]);
    }

    @ThreadSafe
    private DsfSession(DsfExecutor executor, String ownerId, String id) {
        this.fId = id;
        this.fOwnerId = ownerId;
        this.fExecutor = executor;
    }

    private static class ListenerEntry {
        Object fListener;
        Filter fFilter;

        ListenerEntry(Object listener, Filter filter) {
            this.fListener = listener;
            this.fFilter = filter;
        }

        public boolean equals(Object other) {
            return other instanceof ListenerEntry && this.fListener.equals(((ListenerEntry)other).fListener);
        }

        public int hashCode() {
            return this.fListener.hashCode();
        }
    }

    public static interface SessionEndedListener {
        public void sessionEnded(DsfSession var1);
    }

    public static interface SessionStartedListener {
        public void sessionStarted(DsfSession var1);
    }
}

