/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;

public abstract class RepositoryClientManager<T, C extends Serializable>
implements IRepositoryListener {
    private final Map<String, T> clientByUrl = new HashMap<String, T>();
    private final Map<String, C> respoitoryConfigurationByUrl = new HashMap<String, C>();
    private final File cacheFile;
    private TaskRepositoryLocationFactory locationFactory;
    private final Class<C> repositoryConfigurationClass;

    public RepositoryClientManager(File cacheFile, Class<C> repositoryConfigurationClass) {
        Assert.isNotNull((Object)cacheFile);
        this.cacheFile = cacheFile;
        this.repositoryConfigurationClass = repositoryConfigurationClass;
        this.readCache();
    }

    public synchronized T getClient(TaskRepository repository) {
        Assert.isNotNull((Object)((Object)repository));
        T client = this.clientByUrl.get(repository.getRepositoryUrl());
        if (client == null) {
            Serializable data = (Serializable)this.respoitoryConfigurationByUrl.get(repository.getRepositoryUrl());
            if (data == null) {
                data = this.createRepositoryConfiguration(repository);
                this.respoitoryConfigurationByUrl.put(repository.getRepositoryUrl(), data);
            }
            client = this.createClient(repository, data);
            this.clientByUrl.put(repository.getRepositoryUrl(), client);
        }
        return client;
    }

    protected C createRepositoryConfiguration(TaskRepository repository) {
        try {
            return (C)((Serializable)this.repositoryConfigurationClass.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract T createClient(TaskRepository var1, C var2);

    public void repositoriesRead() {
    }

    @Override
    public synchronized void repositoryAdded(TaskRepository repository) {
        this.removeClient(repository);
        this.respoitoryConfigurationByUrl.remove(repository.getRepositoryUrl());
    }

    private void removeClient(TaskRepository repository) {
        this.clientByUrl.remove(repository.getRepositoryUrl());
    }

    @Override
    public synchronized void repositoryRemoved(TaskRepository repository) {
        this.removeClient(repository);
        this.respoitoryConfigurationByUrl.remove(repository.getRepositoryUrl());
    }

    @Override
    public synchronized void repositorySettingsChanged(TaskRepository repository) {
        this.removeClient(repository);
    }

    public void readCache() {
        block15: {
            if (this.cacheFile == null || !this.cacheFile.exists()) {
                return;
            }
            ObjectInputStream in = null;
            try {
                try {
                    in = new OsgiAwareObjectInputStream(new FileInputStream(this.cacheFile));
                    int size = in.readInt();
                    int i = 0;
                    while (i < size) {
                        String url = (String)in.readObject();
                        Serializable data = (Serializable)in.readObject();
                        if (url != null && data != null) {
                            this.respoitoryConfigurationByUrl.put(url, data);
                        }
                        ++i;
                    }
                }
                catch (Throwable e) {
                    this.handleError("The respository configuration cache could not be read", e);
                    if (in == null) break block15;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected void handleError(String message, Throwable e) {
        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", message, e));
    }

    public void writeCache() {
        if (this.cacheFile == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));){
                out.writeInt(this.respoitoryConfigurationByUrl.size());
                for (String url : this.respoitoryConfigurationByUrl.keySet()) {
                    out.writeObject(url);
                    out.writeObject(this.respoitoryConfigurationByUrl.get(url));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.handleError("The respository configuration cache could not be written", e);
        }
    }

    public TaskRepositoryLocationFactory getLocationFactory() {
        return this.locationFactory;
    }

    public void setLocationFactory(TaskRepositoryLocationFactory locationFactory) {
        this.locationFactory = locationFactory;
    }

    @Override
    public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
    }

    private class OsgiAwareObjectInputStream
    extends ObjectInputStream {
        public OsgiAwareObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(desc.getName(), true, RepositoryClientManager.this.repositoryConfigurationClass.getClassLoader());
            }
            catch (Exception e) {
                return super.resolveClass(desc);
            }
        }
    }
}

