/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.gef.lookup;

import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.gef.GEFLayerException;
import org.eclipse.reddeer.gef.finder.FigureFinder;
import org.eclipse.reddeer.gef.lookup.ViewerLookup;
import org.hamcrest.Matcher;

public class FigureLookup {
    protected final Logger log = Logger.getLogger(this.getClass());
    private static FigureLookup instance;

    private FigureLookup() {
    }

    public static FigureLookup getInstance() {
        if (instance == null) {
            instance = new FigureLookup();
        }
        return instance;
    }

    public IFigure findFigure(Matcher<?> matcher, int index) {
        return this.findFigure((EditPartViewer)ViewerLookup.getInstance().findGraphicalViewer(), matcher, index);
    }

    public IFigure findFigure(EditPartViewer viewer, Matcher<?> matcher, int index) {
        FigureCanvas canvas = (FigureCanvas)viewer.getControl();
        return this.findFigure(canvas.getContents(), matcher, index);
    }

    public IFigure findFigure(IFigure parent, Matcher<?> matcher, int index) {
        List<IFigure> figures = new FigureFinder().find(parent, matcher);
        if (figures.size() <= index) {
            throw new GEFLayerException("Cannot find figure with matcher " + matcher + " at " + index);
        }
        return figures.get(index);
    }
}

