/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.internal.model;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.internal.core.model.SystemPostableEventNotifier;
import org.eclipse.rse.internal.core.model.SystemRegistry;
import org.eclipse.rse.internal.ui.view.SystemPerspectiveHelpers;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemPreferencesManager;
import org.eclipse.rse.ui.internal.model.SystemScratchpad;
import org.eclipse.rse.ui.model.ISystemRegistryUI;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;
import org.eclipse.ui.part.ResourceTransfer;

public class SystemRegistryUI
implements ISystemRegistryUI {
    private static SystemRegistryUI _instance = null;
    private SystemRegistry registry = null;
    private IRunnableContext currentRunnableContext;
    private Shell currentRunnableContextShell;
    private Vector previousRunnableContexts = new Vector();
    private Vector previousRunnableContextShells = new Vector();
    private SystemScratchpad scratchpad = null;

    protected SystemRegistryUI() {
        this.registry = SystemRegistry.getInstance();
    }

    public static SystemRegistryUI getInstance() {
        if (_instance == null) {
            _instance = new SystemRegistryUI();
        }
        return _instance;
    }

    public void showRSEPerspective() {
        SystemPerspectiveHelpers.openRSEPerspective();
    }

    public void expandHost(IHost conn) {
        SystemView rseView;
        if (SystemPerspectiveHelpers.isRSEPerspectiveActive() && (rseView = SystemPerspectiveHelpers.findRSEView()) != null) {
            rseView.setExpandedState(conn, true);
            rseView.setSelection((ISelection)new StructuredSelection((Object)conn));
        }
    }

    public void expandSubSystem(ISubSystem subsystem) {
        SystemView rseView;
        if (SystemPerspectiveHelpers.isRSEPerspectiveActive() && (rseView = SystemPerspectiveHelpers.findRSEView()) != null) {
            rseView.setExpandedState(subsystem.getHost(), true);
            rseView.setExpandedState(subsystem, true);
            rseView.setSelection((ISelection)new StructuredSelection((Object)subsystem));
        }
    }

    public Shell getShell() {
        IWorkbench workbench = RSEUIPlugin.getDefault().getWorkbench();
        if (workbench != null) {
            Shell shell;
            IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
            if (ww == null) {
                ww = workbench.getWorkbenchWindows()[0];
            }
            if (ww != null && !(shell = ww.getShell()).isDisposed()) {
                return shell;
            }
        }
        return null;
    }

    public void setRunnableContext(Shell shell, IRunnableContext context) {
        this.pushRunnableContext(shell, context);
    }

    public void clearRunnableContext() {
        this.popRunnableContext();
    }

    public IRunnableContext getRunnableContext() {
        if (this.currentRunnableContextShell != null && this.currentRunnableContextShell.isDisposed()) {
            this.clearRunnableContext();
        }
        if (this.currentRunnableContext != null) {
            return this.currentRunnableContext;
        }
        return null;
    }

    private IRunnableContext popRunnableContext() {
        Shell shell = null;
        boolean found = false;
        Vector<Shell> disposedShells = new Vector<Shell>();
        Vector disposedContexts = new Vector();
        int idx = this.previousRunnableContextShells.size() - 1;
        while (!found && idx >= 0) {
            shell = (Shell)this.previousRunnableContextShells.elementAt(idx);
            if (shell == this.currentRunnableContextShell || shell.isDisposed()) {
                disposedShells.add(shell);
                disposedContexts.add(this.previousRunnableContexts.elementAt(idx));
            } else {
                found = true;
                this.currentRunnableContextShell = shell;
                this.currentRunnableContext = (IRunnableContext)this.previousRunnableContexts.elementAt(idx);
            }
            --idx;
        }
        if (!found) {
            this.currentRunnableContextShell = null;
            this.currentRunnableContext = null;
        }
        idx = 0;
        while (idx < disposedShells.size()) {
            this.previousRunnableContextShells.remove(disposedShells.elementAt(idx));
            this.previousRunnableContexts.remove(disposedContexts.elementAt(idx));
            ++idx;
        }
        return this.currentRunnableContext;
    }

    private IRunnableContext pushRunnableContext(Shell shell, IRunnableContext context) {
        this.previousRunnableContexts.addElement(context);
        this.previousRunnableContextShells.addElement(shell);
        this.currentRunnableContextShell = shell;
        this.currentRunnableContext = context;
        return this.currentRunnableContext;
    }

    public Clipboard getSystemClipboard() {
        Display display = null;
        Shell shell = this.getShell();
        display = shell == null ? Display.getDefault() : shell.getDisplay();
        return new Clipboard(display);
    }

    private Object getObjectFor(String str) {
        int profileDelim;
        int connectionDelim = str.indexOf(":");
        if (connectionDelim == -1 && (profileDelim = str.indexOf(".")) != -1) {
            String profileId = str.substring(0, profileDelim);
            String connectionId = str.substring(profileDelim + 1, str.length());
            ISystemProfile profile = this.registry.getSystemProfile(profileId);
            return this.registry.getHost(profile, connectionId);
        }
        int subsystemDelim = str.indexOf(":", connectionDelim + 1);
        String subSystemId = str.substring(0, subsystemDelim);
        String srcKey = str.substring(subsystemDelim + 1, str.length());
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        ISubSystem subSystem = registry.getSubSystem(subSystemId);
        if (subSystem != null) {
            Object result = null;
            try {
                result = subSystem.getObjectWithAbsoluteName(srcKey);
            }
            catch (SystemMessageException e) {
                return e.getSystemMessage();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result != null) {
                return result;
            }
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1106");
            msg.makeSubstitution((Object)srcKey, (Object)subSystem.getHostAliasName());
            return msg;
        }
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1103");
        msg.makeSubstitution((Object)subSystemId);
        return msg;
    }

    public List getSystemClipboardObjects(int srcType) {
        TextTransfer textTransfer;
        Clipboard clipboard = this.getSystemClipboard();
        ArrayList<Object> srcObjects = new ArrayList<Object>();
        Object object = null;
        if (srcType == 0) {
            object = clipboard.getContents((Transfer)PluginTransfer.getInstance());
            if (object instanceof PluginTransferData) {
                PluginTransferData data = (PluginTransferData)object;
                byte[] result = data.getData();
                String str = null;
                try {
                    str = new String(result, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    str = new String(result);
                }
                String[] tokens = str.split("\\|");
                int i = 0;
                while (i < tokens.length) {
                    String srcStr = tokens[i];
                    Object srcObject = this.getObjectFor(srcStr);
                    srcObjects.add(srcObject);
                    ++i;
                }
            }
        } else if (srcType == 1) {
            ResourceTransfer resTransfer = ResourceTransfer.getInstance();
            object = clipboard.getContents((Transfer)resTransfer);
            if (object != null) {
                IResource[] resourceData = (IResource[])object;
                int i = 0;
                while (i < resourceData.length) {
                    srcObjects.add(resourceData[i]);
                    ++i;
                }
            }
        } else if (srcType == 2) {
            FileTransfer fileTransfer = FileTransfer.getInstance();
            object = clipboard.getContents((Transfer)fileTransfer);
            if (object != null) {
                String[] fileData = (String[])object;
                int i = 0;
                while (i < fileData.length) {
                    srcObjects.add(fileData[i]);
                    ++i;
                }
            }
        } else if (srcType == 3 && (object = clipboard.getContents((Transfer)(textTransfer = TextTransfer.getInstance()))) != null) {
            String textData = (String)object;
            srcObjects.add(textData);
        }
        clipboard.dispose();
        return srcObjects;
    }

    public SystemScratchpad getSystemScratchPad() {
        if (this.scratchpad == null) {
            this.scratchpad = new SystemScratchpad();
        }
        return this.scratchpad;
    }

    public boolean getQualifiedHostNames() {
        return SystemPreferencesManager.getQualifyConnectionNames();
    }

    public void setQualifiedHostNames(boolean set) {
        SystemPreferencesManager.setQualifyConnectionNames(set);
        IHost[] conns = this.registry.getHosts();
        if (conns != null) {
            int idx = 0;
            while (idx < conns.length) {
                this.registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)conns[idx], 65, (Object)this.registry));
                ++idx;
            }
        }
        if (SystemPreferencesManager.getShowFilterPools()) {
            this.registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this.registry, 82, (Object)this.registry));
        }
    }

    public void setShowFilterPools(boolean show) {
        ISubSystemConfigurationProxy[] proxies = this.registry.getSubSystemConfigurationProxies();
        if (proxies != null) {
            int idx = 0;
            while (idx < proxies.length) {
                ISubSystemConfiguration factory;
                if (proxies[idx].isSubSystemConfigurationActive() && (factory = proxies[idx].getSubSystemConfiguration()) != null && factory.supportsFilters()) {
                    factory.setShowFilterPools(show);
                }
                ++idx;
            }
        }
    }

    public void setShowNewHostPrompt(boolean show) {
        this.registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this, 82, null));
    }

    public void postEvent(ISystemResourceChangeEvent event) {
        this.registry.getResourceChangeManager().postNotify(event);
    }

    public void postEvent(ISystemResourceChangeListener listener, ISystemResourceChangeEvent event) {
        new SystemPostableEventNotifier(listener, event);
    }
}

