/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.snippets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.ui.internal.snippets.Snippet;
import org.eclipse.tm4e.ui.snippets.ISnippet;
import org.eclipse.tm4e.ui.snippets.ISnippetManager;

public final class SnippetManager
implements ISnippetManager {
    private static final ISnippet[] EMPTY_SNIPPETS = new ISnippet[0];
    private static final String SNIPPET_ELT = "snippet";
    private static final String EXTENSION_SNIPPETS = "snippets";
    private static @Nullable ISnippetManager INSTANCE;
    private final Map<String, @Nullable Collection<ISnippet>> snippets = new HashMap<String, Collection<ISnippet>>();

    public static ISnippetManager getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = SnippetManager.createInstance();
        return INSTANCE;
    }

    private static synchronized ISnippetManager createInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        SnippetManager manager = new SnippetManager();
        manager.load();
        return manager;
    }

    private SnippetManager() {
    }

    private void load() {
        this.loadGrammarsFromExtensionPoints();
    }

    private void loadGrammarsFromExtensionPoints() {
        IConfigurationElement[] cf;
        IConfigurationElement[] iConfigurationElementArray = cf = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tm4e.ui", EXTENSION_SNIPPETS);
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String extensionName = ce.getName();
            if (SNIPPET_ELT.equals(extensionName)) {
                this.registerSnippet(new Snippet(ce));
            }
            ++n2;
        }
    }

    private void registerSnippet(Snippet snippet) {
        String scopeName = snippet.getScopeName();
        Collection<ISnippet> snippets = this.snippets.get(scopeName);
        if (snippets == null) {
            snippets = new ArrayList<ISnippet>();
            this.snippets.put(scopeName, snippets);
        }
        snippets.add(snippet);
    }

    @Override
    public ISnippet[] getSnippets(String scopeName) {
        Collection<ISnippet> snippets = this.snippets.get(scopeName);
        return snippets != null ? (ISnippet[])snippets.toArray(ISnippet[]::new) : EMPTY_SNIPPETS;
    }
}

